/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.device.module.hardware;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.libcomm.core.device.module.hardware.AdsCalculator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lvet/inpulse/libcomm/core/device/module/hardware/Ads1293Calculator;", "Lvet/inpulse/libcomm/core/device/module/hardware/AdsCalculator;", "vRef", "", "gain", "", "<init>", "(FI)V", "getGain", "()I", "vRefTerm", "", "vRefTermInv", "adcToMilliVolts", "adcDigitalValue", "voltageToAdc", "voltageInMilliVolts", "Companion", "libcomm"})
public final class Ads1293Calculator
implements AdsCalculator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int gain;
    private final double vRefTerm;
    private final double vRefTermInv;
    public static final double ADC_MAX = 1.5925248E7;

    public Ads1293Calculator(float vRef, int gain) {
        this.gain = gain;
        this.vRefTerm = (double)((float)2 * vRef) / 3.5;
        this.vRefTermInv = 3.5 / (double)((float)2 * vRef);
    }

    public final int getGain() {
        return this.gain;
    }

    @Override
    public float adcToMilliVolts(int adcDigitalValue) {
        int adcUnsigned = adcDigitalValue & 0xFFFFFF;
        double adcIntermediate = (double)adcUnsigned / 1.5925248E7 - 0.5;
        return (float)(adcIntermediate * this.vRefTerm) * (float)1000;
    }

    @Override
    public int voltageToAdc(float voltageInMilliVolts) {
        float voltageInVolts = voltageInMilliVolts / (float)1000;
        double voltageIntermediate = this.vRefTermInv * (double)voltageInVolts + 0.5;
        return MathKt.roundToInt((double)(voltageIntermediate * 1.5925248E7));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lvet/inpulse/libcomm/core/device/module/hardware/Ads1293Calculator$Companion;", "", "<init>", "()V", "ADC_MAX", "", "libcomm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

