/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.libcomm.core.device.firmware;

import java.io.Closeable;
import kotlin.ExceptionsKt;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.libcomm.core.device.DeviceType;
import vet.inpulse.libcomm.core.device.firmware.FirmwareInfo;
import vet.inpulse.libcomm.core.device.firmware.FirmwareValidationFailedReason;
import vet.inpulse.libcomm.core.device.firmware.FirmwareValidationResult;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"validateEsp32Firmware", "Lvet/inpulse/libcomm/core/device/firmware/FirmwareValidationResult;", "firmware", "Lokio/Source;", "deviceType", "Lvet/inpulse/libcomm/core/device/DeviceType;", "libcomm"})
@SourceDebugExtension(value={"SMAP\nFirmwareValidation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirmwareValidation.kt\nvet/inpulse/libcomm/core/device/firmware/FirmwareValidationKt\n+ 2 Okio.kt\nokio/Okio__OkioKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,80:1\n72#2:81\n58#2,13:82\n75#2:210\n62#2,3:211\n77#2,3:214\n106#3:95\n78#3,22:96\n106#3:118\n78#3,22:119\n106#3:141\n78#3,22:142\n106#3:164\n78#3,22:165\n106#3:187\n78#3,22:188\n*S KotlinDebug\n*F\n+ 1 FirmwareValidation.kt\nvet/inpulse/libcomm/core/device/firmware/FirmwareValidationKt\n*L\n38#1:81\n38#1:82,13\n38#1:210\n38#1:211,3\n38#1:214,3\n66#1:95\n66#1:96,22\n67#1:118\n67#1:119,22\n68#1:141\n68#1:142,22\n69#1:164\n69#1:165,22\n70#1:187\n70#1:188,22\n*E\n"})
public final class FirmwareValidationKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    public static final FirmwareValidationResult validateEsp32Firmware(@NotNull Source firmware, @NotNull DeviceType deviceType) {
        Intrinsics.checkNotNullParameter((Object)firmware, (String)"firmware");
        Intrinsics.checkNotNullParameter((Object)((Object)deviceType), (String)"deviceType");
        try {
            Object var6_8;
            BufferedSource it;
            Throwable thrown$iv;
            Closeable $this$use$iv;
            block46: {
                block45: {
                    block44: {
                        $this$use$iv = (Closeable)Okio.buffer((Source)firmware);
                        boolean $i$f$use = false;
                        thrown$iv = null;
                        it = (BufferedSource)$this$use$iv;
                        boolean bl = false;
                        byte magic = it.readByte();
                        if (magic == -23) break block44;
                        FirmwareValidationResult firmwareValidationResult = new FirmwareValidationResult.Failed(FirmwareValidationFailedReason.InvalidMagicNumber);
                        try {
                            Closeable closeable = $this$use$iv;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        return firmwareValidationResult;
                    }
                    it.skip(11L);
                    short chipId2333333332 = it.readShortLe();
                    boolean isForDeviceType = FirmwareValidationKt.validateEsp32Firmware$isForDeviceSOC(deviceType, chipId2333333332);
                    if (isForDeviceType) break block45;
                    FirmwareValidationResult firmwareValidationResult = new FirmwareValidationResult.Failed(FirmwareValidationFailedReason.IsNotForDeviceType);
                    try {
                        Closeable closeable = $this$use$iv;
                        if (closeable != null) {
                            closeable.close();
                        }
                    }
                    catch (Throwable chipId2333333332) {
                        // empty catch block
                    }
                    return firmwareValidationResult;
                }
                it.skip(10L);
                it.skip(8L);
                long magicSegmentWord = it.readLongLe();
                if (magicSegmentWord == 2882360370L) break block46;
                FirmwareValidationResult firmwareValidationResult = new FirmwareValidationResult.Failed(FirmwareValidationFailedReason.InvalidSegmentMagicNumber);
                try {
                    Closeable closeable = $this$use$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable chipId) {
                    // empty catch block
                }
                return firmwareValidationResult;
            }
            it.skip(8L);
            String $this$trim$iv = it.readUtf8(32L);
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char c = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean match$iv$iv = Character.isISOControl(c);
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String appVersion = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            String $this$trim$iv2 = it.readUtf8(32L);
            boolean $i$f$trim3 = false;
            CharSequence $this$trim$iv$iv2 = $this$trim$iv2;
            boolean $i$f$trim4 = false;
            int startIndex$iv$iv2 = 0;
            int endIndex$iv$iv2 = $this$trim$iv$iv2.length() - 1;
            boolean startFound$iv$iv2 = false;
            while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                int index$iv$iv = !startFound$iv$iv2 ? startIndex$iv$iv2 : endIndex$iv$iv2;
                char c = $this$trim$iv$iv2.charAt(index$iv$iv);
                boolean bl = false;
                boolean match$iv$iv = Character.isISOControl(c);
                if (!startFound$iv$iv2) {
                    if (!match$iv$iv) {
                        startFound$iv$iv2 = true;
                        continue;
                    }
                    ++startIndex$iv$iv2;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv2;
            }
            String projectName = ((Object)$this$trim$iv$iv2.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString();
            String $this$trim$iv3 = it.readUtf8(16L);
            $i$f$trim5 = false;
            CharSequence $this$trim$iv$iv3 = $this$trim$iv3;
            boolean $i$f$trim52 = false;
            int startIndex$iv$iv3 = 0;
            int endIndex$iv$iv3 = $this$trim$iv$iv3.length() - 1;
            boolean startFound$iv$iv3 = false;
            while (startIndex$iv$iv3 <= endIndex$iv$iv3) {
                int index$iv$iv = !startFound$iv$iv3 ? startIndex$iv$iv3 : endIndex$iv$iv3;
                char c = $this$trim$iv$iv3.charAt(index$iv$iv);
                boolean bl = false;
                boolean match$iv$iv = Character.isISOControl(c);
                if (!startFound$iv$iv3) {
                    if (!match$iv$iv) {
                        startFound$iv$iv3 = true;
                        continue;
                    }
                    ++startIndex$iv$iv3;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv3;
            }
            String compileTime = ((Object)$this$trim$iv$iv3.subSequence(startIndex$iv$iv3, endIndex$iv$iv3 + 1)).toString();
            String $this$trim$iv4 = it.readUtf8(16L);
            $i$f$trim6 = false;
            CharSequence $this$trim$iv$iv4 = $this$trim$iv4;
            boolean $i$f$trim62 = false;
            int startIndex$iv$iv4 = 0;
            int endIndex$iv$iv4 = $this$trim$iv$iv4.length() - 1;
            boolean startFound$iv$iv4 = false;
            while (startIndex$iv$iv4 <= endIndex$iv$iv4) {
                int index$iv$iv = !startFound$iv$iv4 ? startIndex$iv$iv4 : endIndex$iv$iv4;
                char c = $this$trim$iv$iv4.charAt(index$iv$iv);
                boolean bl = false;
                boolean match$iv$iv = Character.isISOControl(c);
                if (!startFound$iv$iv4) {
                    if (!match$iv$iv) {
                        startFound$iv$iv4 = true;
                        continue;
                    }
                    ++startIndex$iv$iv4;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv4;
            }
            String compileDate = ((Object)$this$trim$iv$iv4.subSequence(startIndex$iv$iv4, endIndex$iv$iv4 + 1)).toString();
            String $this$trim$iv5 = it.readUtf8(32L);
            $i$f$trim7 = false;
            CharSequence $this$trim$iv$iv5 = $this$trim$iv5;
            boolean $i$f$trim72 = false;
            int startIndex$iv$iv5 = 0;
            int endIndex$iv$iv5 = $this$trim$iv$iv5.length() - 1;
            boolean startFound$iv$iv5 = false;
            while (startIndex$iv$iv5 <= endIndex$iv$iv5) {
                int index$iv$iv = !startFound$iv$iv5 ? startIndex$iv$iv5 : endIndex$iv$iv5;
                char c = $this$trim$iv$iv5.charAt(index$iv$iv);
                boolean bl = false;
                boolean match$iv$iv = Character.isISOControl(c);
                if (!startFound$iv$iv5) {
                    if (!match$iv$iv) {
                        startFound$iv$iv5 = true;
                        continue;
                    }
                    ++startIndex$iv$iv5;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv5;
            }
            String sdkVersion = ((Object)$this$trim$iv$iv5.subSequence(startIndex$iv$iv5, endIndex$iv$iv5 + 1)).toString();
            FirmwareValidationResult firmwareValidationResult = new FirmwareValidationResult.Success(new FirmwareInfo(appVersion, projectName, compileTime, compileDate, sdkVersion));
            try {
                Closeable closeable = $this$use$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable chipId) {
                // empty catch block
            }
            return firmwareValidationResult;
            catch (Throwable t$iv) {
                try {
                    thrown$iv = t$iv;
                    var6_8 = null;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    block48: {
                        try {
                            Closeable closeable = $this$use$iv;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv2) {
                            if (thrown$iv == null) {
                                thrown$iv = t$iv2;
                                break block48;
                            }
                            ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv2);
                        }
                    }
                }
            }
            Object result$iv = var6_8;
            Throwable throwable = thrown$iv;
            if (throwable != null) {
                throw throwable;
            }
            throw new KotlinNothingValueException();
        }
        catch (Exception e) {
            return new FirmwareValidationResult.Error(e);
        }
    }

    private static final boolean validateEsp32Firmware$isForDeviceSOC(DeviceType $deviceType, short s) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$deviceType.ordinal()]) {
            case 1, 2, 3 -> {
                if (s == 0) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (s == 9) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DeviceType.values().length];
            try {
                nArray[DeviceType.INCARDIO_V3.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.INMONITOR_20.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.BPSCAN_V2.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.AGILE_V2.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

