/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.sigproc.filters;

import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.sigproc.filters.Filter;
import vet.inpulse.sigproc.filters.FilterCoeff;
import vet.inpulse.sigproc.filters.FloatBuffer;
import vet.inpulse.sigproc.filters.IIR;
import vet.inpulse.sigproc.filters.SimpleFilter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0016J0\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0003H\u0016J0\u0010$\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0003H\u0016J\b\u0010%\u001a\u00020\u001dH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006&"}, d2={"Lvet/inpulse/sigproc/filters/BaselineFilter;", "Lvet/inpulse/sigproc/filters/Filter;", "fs", "", "baselineFreq", "", "<init>", "(IF)V", "getFs", "()I", "rawBuffer", "Lvet/inpulse/sigproc/filters/FloatBuffer;", "getRawBuffer", "()Lvet/inpulse/sigproc/filters/FloatBuffer;", "averageBuffer", "getAverageBuffer", "simpleSt", "Lvet/inpulse/sigproc/filters/SimpleFilter;", "getSimpleSt", "()Lvet/inpulse/sigproc/filters/SimpleFilter;", "activated", "", "getActivated", "()Z", "setActivated", "(Z)V", "filterData", "newData", "filt", "", "src", "", "srcOffset", "dest", "destOffset", "length", "filtFilt", "reset", "sigproc"})
public final class BaselineFilter
implements Filter {
    private final int fs;
    @NotNull
    private final FloatBuffer rawBuffer;
    @NotNull
    private final FloatBuffer averageBuffer;
    @NotNull
    private final SimpleFilter simpleSt;
    private boolean activated;

    public BaselineFilter(int fs, float baselineFreq) {
        this.fs = fs;
        this.rawBuffer = FloatBuffer.Companion.create((int)Math.rint(0.5 * (double)this.fs * 0.75));
        this.averageBuffer = FloatBuffer.Companion.create((int)Math.rint((double)this.fs * 0.75));
        FilterCoeff filterCoeff = IIR.INSTANCE.baselineCoeff(this.fs, baselineFreq);
        int n = this.fs;
        this.simpleSt = new SimpleFilter(n, filterCoeff);
        this.activated = true;
    }

    public final int getFs() {
        return this.fs;
    }

    @NotNull
    public final FloatBuffer getRawBuffer() {
        return this.rawBuffer;
    }

    @NotNull
    public final FloatBuffer getAverageBuffer() {
        return this.averageBuffer;
    }

    @NotNull
    public final SimpleFilter getSimpleSt() {
        return this.simpleSt;
    }

    @Override
    public boolean getActivated() {
        return this.activated;
    }

    @Override
    public void setActivated(boolean bl) {
        this.activated = bl;
    }

    @Override
    public float filterData(float newData) {
        float baselineValue = this.simpleSt.filterData(newData);
        this.averageBuffer.put(baselineValue);
        float average = this.averageBuffer.getSum() / (float)this.averageBuffer.getActual_size();
        float bufferedValue = this.rawBuffer.get(this.rawBuffer.getActual_size());
        this.rawBuffer.put(newData);
        return bufferedValue - average;
    }

    @Override
    public void filt(@NotNull float[] src, int srcOffset, @NotNull float[] dest, int destOffset, int length) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public void filtFilt(@NotNull float[] src, int srcOffset, @NotNull float[] dest, int destOffset, int length) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public void reset() {
        this.simpleSt.reset();
        this.rawBuffer.reset();
        this.averageBuffer.reset();
    }
}

