/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.sigproc.ecg;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import med.inpulse.signal_processing.SignalProcessing;
import med.inpulse.signal_processing.data_structures.LinkedList;
import med.inpulse.signal_processing.ecg.Complex;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.sigproc.core.SigProcErrorType;
import vet.inpulse.sigproc.ecg.ComplexDetector_jvmKt;
import vet.inpulse.sigproc.ecg.EcgComplex;
import vet.inpulse.sigproc.ecg.MarkerType;
import vet.inpulse.sigproc.ecg.Species;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00060\u0001j\u0002`\u0002:\u0001!B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J*\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u0006J,\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u0006J\u001e\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0006J\b\u0010\u001f\u001a\u00020 H\u0016R\u0015\u0010\t\u001a\u00060\nj\u0002`\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\""}, d2={"Lvet/inpulse/sigproc/ecg/ComplexDetector;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "species", "Lvet/inpulse/sigproc/ecg/Species;", "sampling_rate", "", "<init>", "(Lvet/inpulse/sigproc/ecg/Species;I)V", "detector", "Lmed/inpulse/signal_processing/ecg/ComplexDetector;", "Lvet/inpulse/sigproc/ecg/ODetector;", "getDetector", "()Lmed/inpulse/signal_processing/ecg/ComplexDetector;", "calibrate", "Lvet/inpulse/sigproc/core/SigProcErrorType;", "calibrationSignal", "", "detect", "", "Lvet/inpulse/sigproc/ecg/EcgComplex;", "detection_interval", "markers", "", "Lvet/inpulse/sigproc/ecg/MarkerType;", "cal_relative_index", "detect_average", "interval_average", "get_signal_average", "D2_interval", "original_interval", "close", "", "Companion", "sigproc"})
public final class ComplexDetector
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final med.inpulse.signal_processing.ecg.ComplexDetector detector;

    public ComplexDetector(@NotNull Species species, int sampling_rate) {
        Intrinsics.checkNotNullParameter((Object)((Object)species), (String)"species");
        this.detector = new med.inpulse.signal_processing.ecg.ComplexDetector(ComplexDetector_jvmKt.access$toOSpecies(species), sampling_rate);
    }

    @NotNull
    public final med.inpulse.signal_processing.ecg.ComplexDetector getDetector() {
        return this.detector;
    }

    @NotNull
    public final SigProcErrorType calibrate(@NotNull float[] calibrationSignal) {
        Intrinsics.checkNotNullParameter((Object)calibrationSignal, (String)"calibrationSignal");
        this.detector.calibrate(calibrationSignal);
        return SigProcErrorType.LIBSIGPROC_SUCCESS;
    }

    @NotNull
    public final List<EcgComplex> detect(@NotNull float[] detection_interval, @NotNull Set<? extends MarkerType> markers, int cal_relative_index) {
        Intrinsics.checkNotNullParameter((Object)detection_interval, (String)"detection_interval");
        Intrinsics.checkNotNullParameter(markers, (String)"markers");
        ArrayList possibleTypes = ComplexDetector_jvmKt.access$toMarkerTypeList(markers);
        LinkedList detected = this.detector.detect(detection_interval, possibleTypes, (long)cal_relative_index);
        List retList = new ArrayList();
        Intrinsics.checkNotNull((Object)detected);
        ComplexDetector_jvmKt.access$consume(detected, arg_0 -> ComplexDetector.detect$lambda$0(possibleTypes, retList, arg_0));
        return retList;
    }

    @NotNull
    public final EcgComplex detect_average(@NotNull float[] detection_interval, @NotNull float[] interval_average, @NotNull Set<? extends MarkerType> markers, int cal_relative_index) {
        Intrinsics.checkNotNullParameter((Object)detection_interval, (String)"detection_interval");
        Intrinsics.checkNotNullParameter((Object)interval_average, (String)"interval_average");
        Intrinsics.checkNotNullParameter(markers, (String)"markers");
        ArrayList possibleTypes = ComplexDetector_jvmKt.access$toMarkerTypeList(markers);
        Complex detected = this.detector.detectAverage(detection_interval, interval_average, possibleTypes, (long)cal_relative_index);
        Intrinsics.checkNotNull((Object)detected);
        return ComplexDetector_jvmKt.access$consumeComplex(detected, possibleTypes);
    }

    @NotNull
    public final float[] get_signal_average(@NotNull float[] D2_interval, @NotNull float[] original_interval, int cal_relative_index) {
        Intrinsics.checkNotNullParameter((Object)D2_interval, (String)"D2_interval");
        Intrinsics.checkNotNullParameter((Object)original_interval, (String)"original_interval");
        float[] fArray = this.detector.getSignalAverage(D2_interval, original_interval, (long)cal_relative_index);
        Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"getSignalAverage(...)");
        return fArray;
    }

    @Override
    public void close() {
        this.detector.free();
    }

    private static final Unit detect$lambda$0(ArrayList $possibleTypes, List $retList, Complex it) {
        Intrinsics.checkNotNull((Object)it);
        EcgComplex realEcgComplex = ComplexDetector_jvmKt.access$consumeComplex(it, $possibleTypes);
        $retList.add(realEcgComplex);
        return Unit.INSTANCE;
    }

    static {
        SignalProcessing.load();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lvet/inpulse/sigproc/ecg/ComplexDetector$Companion;", "", "<init>", "()V", "sigproc"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

