/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.math.wavelet;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.math.wavelet.WaveletCoefficients;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\r\b\u0086\b\u0018\u0000 32\u00020\u0001:\u00013BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0004\b\f\u0010\rJF\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0007JF\u0010\"\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0007J(\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005H\u0002J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010)\u001a\u00020\u0005H\u0016J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\u0005H\u00c6\u0003J\t\u0010,\u001a\u00020\u0007H\u00c6\u0003J\t\u0010-\u001a\u00020\u0007H\u00c6\u0003J\t\u0010.\u001a\u00020\u0007H\u00c6\u0003J\t\u0010/\u001a\u00020\u0007H\u00c6\u0003J\t\u00100\u001a\u00020\u0005H\u00c6\u0003JO\u00101\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\u0005H\u00c6\u0001J\t\u00102\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011\u00a8\u00064"}, d2={"Lvet/inpulse/math/wavelet/Wavelet;", "", "name", "", "minSize", "", "scalingDecompositionCoefficients", "", "waveletDecompositionCoefficients", "scalingReconstructionCoefficients", "waveletReconstructionCoefficients", "offset", "<init>", "(Ljava/lang/String;I[D[D[D[DI)V", "getName", "()Ljava/lang/String;", "getMinSize", "()I", "getScalingDecompositionCoefficients", "()[D", "getWaveletDecompositionCoefficients", "getScalingReconstructionCoefficients", "getWaveletReconstructionCoefficients", "getOffset", "forwardStep", "", "src", "srcOffset", "srcStride", "dest", "destOffset", "destStride", "length", "workspace", "inverseStep", "clearArray", "array", "stride", "equals", "", "other", "hashCode", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "toString", "Companion", "math"})
@SourceDebugExtension(value={"SMAP\nWavelet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Wavelet.kt\nvet/inpulse/math/wavelet/Wavelet\n+ 2 SignalUtils.kt\nvet/inpulse/math/SignalUtilsKt\n*L\n1#1,198:1\n206#2:199\n206#2:200\n206#2:201\n206#2:202\n206#2:203\n206#2:204\n206#2:205\n*S KotlinDebug\n*F\n+ 1 Wavelet.kt\nvet/inpulse/math/wavelet/Wavelet\n*L\n117#1:199\n118#1:200\n128#1:201\n150#1:202\n151#1:203\n162#1:204\n168#1:205\n*E\n"})
public final class Wavelet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    private final int minSize;
    @NotNull
    private final double[] scalingDecompositionCoefficients;
    @NotNull
    private final double[] waveletDecompositionCoefficients;
    @NotNull
    private final double[] scalingReconstructionCoefficients;
    @NotNull
    private final double[] waveletReconstructionCoefficients;
    private final int offset;

    public Wavelet(@NotNull String name, int minSize, @NotNull double[] scalingDecompositionCoefficients, @NotNull double[] waveletDecompositionCoefficients, @NotNull double[] scalingReconstructionCoefficients, @NotNull double[] waveletReconstructionCoefficients, int offset) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)scalingDecompositionCoefficients, (String)"scalingDecompositionCoefficients");
        Intrinsics.checkNotNullParameter((Object)waveletDecompositionCoefficients, (String)"waveletDecompositionCoefficients");
        Intrinsics.checkNotNullParameter((Object)scalingReconstructionCoefficients, (String)"scalingReconstructionCoefficients");
        Intrinsics.checkNotNullParameter((Object)waveletReconstructionCoefficients, (String)"waveletReconstructionCoefficients");
        this.name = name;
        this.minSize = minSize;
        this.scalingDecompositionCoefficients = scalingDecompositionCoefficients;
        this.waveletDecompositionCoefficients = waveletDecompositionCoefficients;
        this.scalingReconstructionCoefficients = scalingReconstructionCoefficients;
        this.waveletReconstructionCoefficients = waveletReconstructionCoefficients;
        this.offset = offset;
    }

    public /* synthetic */ Wavelet(String string, int n, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x40) != 0) {
            n2 = 0;
        }
        this(string, n, dArray, dArray2, dArray3, dArray4, n2);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getMinSize() {
        return this.minSize;
    }

    @NotNull
    public final double[] getScalingDecompositionCoefficients() {
        return this.scalingDecompositionCoefficients;
    }

    @NotNull
    public final double[] getWaveletDecompositionCoefficients() {
        return this.waveletDecompositionCoefficients;
    }

    @NotNull
    public final double[] getScalingReconstructionCoefficients() {
        return this.scalingReconstructionCoefficients;
    }

    @NotNull
    public final double[] getWaveletReconstructionCoefficients() {
        return this.waveletReconstructionCoefficients;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final void forwardStep(@NotNull double[] src, int srcOffset, int srcStride, @NotNull double[] dest, int destOffset, int destStride, int length, @NotNull double[] workspace) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        this.clearArray(workspace, 0, 1, length);
        int nmod = this.scalingDecompositionCoefficients.length * length - this.offset;
        int n1 = length - 1;
        int nh = length >> 1;
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)length)), (int)2);
        int n = intProgression.getFirst();
        int n2 = intProgression.getLast();
        int n3 = intProgression.getStep();
        int n4 = 0;
        if (n3 > 0 && n <= n2 || n3 < 0 && n2 <= n) {
            while (true) {
                int ii = n4++;
                int i = n;
                double h = 0.0;
                double g = 0.0;
                int ni = i + nmod;
                int n5 = this.scalingDecompositionCoefficients.length;
                for (int k = 0; k < n5; ++k) {
                    int offset$iv;
                    int stride$iv;
                    int jf = n1 & ni + k;
                    int n6 = srcOffset;
                    int n7 = srcStride;
                    int index$iv = jf;
                    boolean $i$f$element = false;
                    h += this.scalingDecompositionCoefficients[k] * src[index$iv * stride$iv + offset$iv];
                    offset$iv = srcOffset;
                    stride$iv = srcStride;
                    index$iv = jf;
                    $i$f$element = false;
                    g += this.waveletDecompositionCoefficients[k] * src[index$iv * stride$iv + offset$iv];
                }
                workspace[ii] = workspace[ii] + h;
                int n8 = ii + nh;
                workspace[n8] = workspace[n8] + g;
                if (i == n2) break;
                n += n3;
            }
        }
        for (int i = 0; i < length; ++i) {
            n = destOffset;
            n2 = destStride;
            int index$iv = i;
            boolean $i$f$element = false;
            dest[index$iv * stride$iv + offset$iv] = workspace[i];
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void inverseStep(@NotNull double[] src, int srcOffset, int srcStride, @NotNull double[] dest, int destOffset, int destStride, int length, @NotNull double[] workspace) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        this.clearArray(workspace, 0, 1, length);
        int nmod = this.scalingDecompositionCoefficients.length * length - this.offset;
        int n1 = length - 1;
        int nh = length >> 1;
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)length)), (int)2);
        int n = intProgression.getFirst();
        int n2 = intProgression.getLast();
        int n3 = intProgression.getStep();
        int n4 = 0;
        if (n3 > 0 && n <= n2 || n3 < 0 && n2 <= n) {
            while (true) {
                void offset$iv;
                void stride$iv;
                void offset$iv2;
                void stride$iv2;
                int ii = n4++;
                int i = n;
                int n5 = srcOffset;
                int n6 = srcStride;
                int index$iv = ii;
                int $i$f$element = 0;
                double ai = src[index$iv * stride$iv2 + offset$iv2];
                index$iv = srcOffset;
                $i$f$element = srcStride;
                int index$iv2 = ii + nh;
                boolean $i$f$element2 = false;
                double ai1 = src[index$iv2 * stride$iv + offset$iv];
                int ni = i + nmod;
                int n7 = this.scalingReconstructionCoefficients.length;
                for (int k = 0; k < n7; ++k) {
                    int jf = n1 & ni + k;
                    workspace[jf] = workspace[jf] + (this.scalingReconstructionCoefficients[k] * ai + this.waveletReconstructionCoefficients[k] * ai1);
                }
                if (i == n2) break;
                n += n3;
            }
        }
        for (int i = 0; i < length; ++i) {
            n = destOffset;
            n2 = destStride;
            int index$iv = i;
            boolean $i$f$element = false;
            dest[index$iv * stride$iv + offset$iv] = workspace[i];
        }
    }

    private final void clearArray(double[] array, int offset, int stride, int length) {
        int i = 0;
        while (i < length) {
            int n = offset;
            int n2 = stride;
            int index$iv = i++;
            boolean $i$f$element = false;
            array[index$iv * stride$iv + offset$iv] = 0.0;
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Wavelet cfr_ignored_0 = (Wavelet)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)((Wavelet)other).name)) {
            return false;
        }
        if (this.minSize != ((Wavelet)other).minSize) {
            return false;
        }
        if (!Arrays.equals(this.scalingDecompositionCoefficients, ((Wavelet)other).scalingDecompositionCoefficients)) {
            return false;
        }
        if (!Arrays.equals(this.waveletDecompositionCoefficients, ((Wavelet)other).waveletDecompositionCoefficients)) {
            return false;
        }
        if (!Arrays.equals(this.scalingReconstructionCoefficients, ((Wavelet)other).scalingReconstructionCoefficients)) {
            return false;
        }
        return Arrays.equals(this.waveletReconstructionCoefficients, ((Wavelet)other).waveletReconstructionCoefficients);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.minSize;
        result = 31 * result + Arrays.hashCode(this.scalingDecompositionCoefficients);
        result = 31 * result + Arrays.hashCode(this.waveletDecompositionCoefficients);
        result = 31 * result + Arrays.hashCode(this.scalingReconstructionCoefficients);
        result = 31 * result + Arrays.hashCode(this.waveletReconstructionCoefficients);
        return result;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    public final int component2() {
        return this.minSize;
    }

    @NotNull
    public final double[] component3() {
        return this.scalingDecompositionCoefficients;
    }

    @NotNull
    public final double[] component4() {
        return this.waveletDecompositionCoefficients;
    }

    @NotNull
    public final double[] component5() {
        return this.scalingReconstructionCoefficients;
    }

    @NotNull
    public final double[] component6() {
        return this.waveletReconstructionCoefficients;
    }

    public final int component7() {
        return this.offset;
    }

    @NotNull
    public final Wavelet copy(@NotNull String name, int minSize, @NotNull double[] scalingDecompositionCoefficients, @NotNull double[] waveletDecompositionCoefficients, @NotNull double[] scalingReconstructionCoefficients, @NotNull double[] waveletReconstructionCoefficients, int offset) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)scalingDecompositionCoefficients, (String)"scalingDecompositionCoefficients");
        Intrinsics.checkNotNullParameter((Object)waveletDecompositionCoefficients, (String)"waveletDecompositionCoefficients");
        Intrinsics.checkNotNullParameter((Object)scalingReconstructionCoefficients, (String)"scalingReconstructionCoefficients");
        Intrinsics.checkNotNullParameter((Object)waveletReconstructionCoefficients, (String)"waveletReconstructionCoefficients");
        return new Wavelet(name, minSize, scalingDecompositionCoefficients, waveletDecompositionCoefficients, scalingReconstructionCoefficients, waveletReconstructionCoefficients, offset);
    }

    public static /* synthetic */ Wavelet copy$default(Wavelet wavelet, String string, int n, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            string = wavelet.name;
        }
        if ((n3 & 2) != 0) {
            n = wavelet.minSize;
        }
        if ((n3 & 4) != 0) {
            dArray = wavelet.scalingDecompositionCoefficients;
        }
        if ((n3 & 8) != 0) {
            dArray2 = wavelet.waveletDecompositionCoefficients;
        }
        if ((n3 & 0x10) != 0) {
            dArray3 = wavelet.scalingReconstructionCoefficients;
        }
        if ((n3 & 0x20) != 0) {
            dArray4 = wavelet.waveletReconstructionCoefficients;
        }
        if ((n3 & 0x40) != 0) {
            n2 = wavelet.offset;
        }
        return wavelet.copy(string, n, dArray, dArray2, dArray3, dArray4, n2);
    }

    @NotNull
    public String toString() {
        return "Wavelet(name=" + this.name + ", minSize=" + this.minSize + ", scalingDecompositionCoefficients=" + Arrays.toString(this.scalingDecompositionCoefficients) + ", waveletDecompositionCoefficients=" + Arrays.toString(this.waveletDecompositionCoefficients) + ", scalingReconstructionCoefficients=" + Arrays.toString(this.scalingReconstructionCoefficients) + ", waveletReconstructionCoefficients=" + Arrays.toString(this.waveletReconstructionCoefficients) + ", offset=" + this.offset + ")";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007\u00a8\u0006\n"}, d2={"Lvet/inpulse/math/wavelet/Wavelet$Companion;", "", "<init>", "()V", "buildOrthonormalSpace", "Lvet/inpulse/math/wavelet/WaveletCoefficients;", "scalingDecompositionCoefficients", "", "buildBiOrthonormalSpace", "waveletDecompositionCoefficients", "math"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WaveletCoefficients buildOrthonormalSpace(@NotNull double[] scalingDecompositionCoefficients) {
            int i;
            Intrinsics.checkNotNullParameter((Object)scalingDecompositionCoefficients, (String)"scalingDecompositionCoefficients");
            double[] sdc = scalingDecompositionCoefficients;
            double[] wdc = new double[sdc.length];
            double[] src = new double[sdc.length];
            double[] wrc = new double[sdc.length];
            int n = sdc.length;
            for (i = 0; i < n; ++i) {
                double c = sdc[sdc.length - 1 - i];
                wdc[i] = i % 2 == 0 ? c : -c;
            }
            n = sdc.length;
            for (i = 0; i < n; ++i) {
                src[i] = sdc[i];
                wrc[i] = wdc[i];
            }
            return new WaveletCoefficients(sdc, wdc, src, wrc);
        }

        @NotNull
        public final WaveletCoefficients buildBiOrthonormalSpace(@NotNull double[] scalingDecompositionCoefficients, @NotNull double[] waveletDecompositionCoefficients) {
            Intrinsics.checkNotNullParameter((Object)scalingDecompositionCoefficients, (String)"scalingDecompositionCoefficients");
            Intrinsics.checkNotNullParameter((Object)waveletDecompositionCoefficients, (String)"waveletDecompositionCoefficients");
            double[] sdc = scalingDecompositionCoefficients;
            double[] wdc = waveletDecompositionCoefficients;
            double[] src = new double[sdc.length];
            double[] wrc = new double[sdc.length];
            int n = sdc.length;
            for (int i = 0; i < n; ++i) {
                if (i % 2 == 0) {
                    src[i] = -wdc[i];
                    wrc[i] = -sdc[i];
                    continue;
                }
                src[i] = wdc[i];
                wrc[i] = sdc[i];
            }
            return new WaveletCoefficients(sdc, wdc, src, wrc);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

