/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.math.linalg;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.math.SignalUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B!\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\nJ\u0011\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0086\u0002J\u0019\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0007H\u0086\u0002J\u0011\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010 \u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010!\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0000H\u0086\u0002J\u0013\u0010\"\u001a\u00020#2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010$\u001a\u00020\u0017H\u0016J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\t\u0010'\u001a\u00020(H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R$\u0010\b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010R$\u0010\t\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u000e\"\u0004\b\u0014\u0010\u0010R\u0011\u0010\u001b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000e\u00a8\u0006)"}, d2={"Lvet/inpulse/math/linalg/Vec3;", "", "data", "", "<init>", "([D)V", "x", "", "y", "z", "(DDD)V", "getData", "()[D", "getX", "()D", "setX", "(D)V", "getY", "setY", "getZ", "setZ", "get", "pos", "", "set", "", "value", "length", "getLength", "plus", "other", "plusAssign", "minus", "minusAssign", "equals", "", "hashCode", "component1", "copy", "toString", "", "math"})
@SourceDebugExtension(value={"SMAP\nVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Vector.kt\nvet/inpulse/math/linalg/Vec3\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public final class Vec3 {
    @NotNull
    private final double[] data;
    private final double length;

    public Vec3(@NotNull double[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.data = data;
        this.length = SignalUtilsKt.norm(this.data, 0, 1, this.data.length, 2);
    }

    public /* synthetic */ Vec3(double[] dArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            dArray = new double[3];
        }
        this(dArray);
    }

    @NotNull
    public final double[] getData() {
        return this.data;
    }

    public final double getX() {
        return this.data[0];
    }

    public final void setX(double x) {
        this.data[0] = x;
    }

    public final double getY() {
        return this.data[1];
    }

    public final void setY(double y) {
        this.data[1] = y;
    }

    public final double getZ() {
        return this.data[2];
    }

    public final void setZ(double z) {
        this.data[2] = z;
    }

    public final double get(int pos) {
        if (!(0 <= pos ? pos < 3 : false)) {
            boolean bl = false;
            String string = "Only positions in [0; 2]";
            throw new IllegalArgumentException(string.toString());
        }
        return this.data[pos];
    }

    public final void set(int pos, double value) {
        if (!(0 <= pos ? pos < 3 : false)) {
            boolean bl = false;
            String string = "Only positions in [0; 2]";
            throw new IllegalArgumentException(string.toString());
        }
        this.data[pos] = value;
    }

    public final double getLength() {
        return this.length;
    }

    public Vec3(double x, double y, double z) {
        this(null, 1, null);
        this.data[0] = x;
        this.data[1] = y;
        this.data[2] = z;
    }

    @NotNull
    public final Vec3 plus(@NotNull Vec3 other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Vec3(this.getX() + other.getX(), this.getY() + other.getY(), this.getZ() + other.getZ());
    }

    public final void plusAssign(@NotNull Vec3 other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.setX(this.getX() + other.getX());
        this.setY(this.getY() + other.getY());
        this.setZ(this.getZ() + other.getZ());
    }

    @NotNull
    public final Vec3 minus(@NotNull Vec3 other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Vec3(this.getX() - other.getX(), this.getY() - other.getY(), this.getZ() - other.getZ());
    }

    public final void minusAssign(@NotNull Vec3 other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.setX(this.getX() - other.getX());
        this.setY(this.getY() - other.getY());
        this.setZ(this.getZ() - other.getZ());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Vec3 cfr_ignored_0 = (Vec3)other;
        if (!Arrays.equals(this.data, ((Vec3)other).data)) {
            return false;
        }
        return this.length == ((Vec3)other).length;
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.data);
        result = 31 * result + Double.hashCode(this.length);
        return result;
    }

    @NotNull
    public final double[] component1() {
        return this.data;
    }

    @NotNull
    public final Vec3 copy(@NotNull double[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return new Vec3(data);
    }

    public static /* synthetic */ Vec3 copy$default(Vec3 vec3, double[] dArray, int n, Object object) {
        if ((n & 1) != 0) {
            dArray = vec3.data;
        }
        return vec3.copy(dArray);
    }

    @NotNull
    public String toString() {
        return "Vec3(data=" + Arrays.toString(this.data) + ")";
    }

    public Vec3() {
        this(null, 1, null);
    }
}

