/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.math.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.math.filter.Filter;
import vet.inpulse.shared.utils.InpulseExperimental;

@InpulseExperimental
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001&B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J\u0016\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J\u001e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J\u0016\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J\u001e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J\u001e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J\u0016\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J\u0016\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J\u00a5\u0001\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u000526\u0010\u001a\u001a2\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\u001e0\u001b2K\u0010\u001f\u001aG\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u001e0 H\u0002J\u001e\u0010!\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J\u001e\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J&\u0010#\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006'"}, d2={"Lvet/inpulse/math/filter/Iir;", "", "<init>", "()V", "butterworthQFactor", "", "getButterworthQFactor", "()D", "calcKandNorm", "Lvet/inpulse/math/filter/Iir$KAndNorm;", "cutoffFrequency", "samplingFrequency", "qFactor", "lowPass2ndOrder", "Lvet/inpulse/math/filter/Filter;", "lowPassButter2ndOrder", "highPass2ndOrder", "highPassButter2ndOrder", "bandPass2ndOrder", "centerFrequency", "notch2ndOrder", "lowPass1stOrder", "highPass1stOrder", "nOrderButterworth", "order", "", "provideFirstOrder", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "Lvet/inpulse/math/filter/Filter$Single;", "provideSecondOrder", "Lkotlin/Function3;", "lowPassButterNOrder", "highPassButterNOrder", "bandPassButterNOrder", "highPassFrequency", "lowPassFrequency", "KAndNorm", "math"})
@SourceDebugExtension(value={"SMAP\nIir.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Iir.kt\nvet/inpulse/math/filter/Iir\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,228:1\n1#2:229\n37#3:230\n36#3,3:231\n*S KotlinDebug\n*F\n+ 1 Iir.kt\nvet/inpulse/math/filter/Iir\n*L\n182#1:230\n182#1:231,3\n*E\n"})
public final class Iir {
    @NotNull
    public static final Iir INSTANCE = new Iir();
    private static final double butterworthQFactor = 1.0 / Math.sqrt(2.0);

    private Iir() {
    }

    public final double getButterworthQFactor() {
        return butterworthQFactor;
    }

    private final KAndNorm calcKandNorm(double cutoffFrequency, double samplingFrequency, double qFactor) {
        double k = Math.tan(Math.PI * cutoffFrequency / samplingFrequency);
        double norm = 1.0 / (1.0 + k / qFactor + k * k);
        return new KAndNorm(k, norm);
    }

    @NotNull
    public final Filter lowPass2ndOrder(double cutoffFrequency, double samplingFrequency, double qFactor) {
        KAndNorm kAndNorm = this.calcKandNorm(cutoffFrequency, samplingFrequency, qFactor);
        double k = kAndNorm.component1();
        double norm = kAndNorm.component2();
        double a0 = k * k * norm;
        double a1 = (double)2 * a0;
        double a2 = a0;
        double b1 = (double)2 * (k * k - 1.0) * norm;
        double b2 = (1.0 - k / qFactor + k * k) * norm;
        return new Filter.Single.Biquad(a0, a1, a2, b1, b2);
    }

    @NotNull
    public final Filter lowPassButter2ndOrder(double cutoffFrequency, double samplingFrequency) {
        return this.lowPass2ndOrder(cutoffFrequency, samplingFrequency, butterworthQFactor);
    }

    @NotNull
    public final Filter highPass2ndOrder(double cutoffFrequency, double samplingFrequency, double qFactor) {
        KAndNorm kAndNorm = this.calcKandNorm(cutoffFrequency, samplingFrequency, qFactor);
        double k = kAndNorm.component1();
        double norm = kAndNorm.component2();
        double a0 = 1.0 * norm;
        double a1 = (double)-2 * a0;
        double a2 = a0;
        double b1 = (double)2 * (k * k - 1.0) * norm;
        double b2 = (1.0 - k / qFactor + k * k) * norm;
        return new Filter.Single.Biquad(a0, a1, a2, b1, b2);
    }

    @NotNull
    public final Filter highPassButter2ndOrder(double cutoffFrequency, double samplingFrequency) {
        return this.highPass2ndOrder(cutoffFrequency, samplingFrequency, butterworthQFactor);
    }

    @NotNull
    public final Filter bandPass2ndOrder(double centerFrequency, double samplingFrequency, double qFactor) {
        KAndNorm kAndNorm = this.calcKandNorm(centerFrequency, samplingFrequency, qFactor);
        double k = kAndNorm.component1();
        double norm = kAndNorm.component2();
        double a0 = k / qFactor * norm;
        double a1 = 0.0;
        double a2 = -a0;
        double b1 = (double)2 * (k * k - 1.0) * norm;
        double b2 = (1.0 - k / qFactor + k * k) * norm;
        return new Filter.Single.Biquad(a0, a1, a2, b1, b2);
    }

    @NotNull
    public final Filter notch2ndOrder(double centerFrequency, double samplingFrequency, double qFactor) {
        KAndNorm kAndNorm = this.calcKandNorm(centerFrequency, samplingFrequency, qFactor);
        double k = kAndNorm.component1();
        double norm = kAndNorm.component2();
        double a0 = (1.0 + k * k) * norm;
        double a1 = (double)2 * (k * k - 1.0) * norm;
        double a2 = a0;
        double b1 = a1;
        double b2 = (1.0 - k / qFactor + k * k) * norm;
        return new Filter.Single.Biquad(a0, a1, a2, b1, b2);
    }

    @NotNull
    public final Filter lowPass1stOrder(double cutoffFrequency, double samplingFrequency) {
        double k = this.calcKandNorm(cutoffFrequency, samplingFrequency, 1.0).component1();
        double norm = 1.0 / (1.0 / k + 1.0);
        double b1 = (1.0 - 1.0 / k) * norm;
        return new Filter.Single.FirstOrder(norm, norm, b1);
    }

    @NotNull
    public final Filter highPass1stOrder(double cutoffFrequency, double samplingFrequency) {
        double k = this.calcKandNorm(cutoffFrequency, samplingFrequency, 1.0).component1();
        double norm = 1.0 / (k + 1.0);
        double a1 = -norm;
        double b1 = (k - 1.0) * norm;
        return new Filter.Single.FirstOrder(norm, a1, b1);
    }

    private final Filter nOrderButterworth(int order, double cutoffFrequency, double samplingFrequency, Function2<? super Double, ? super Double, ? extends Filter.Single> provideFirstOrder, Function3<? super Double, ? super Double, ? super Double, ? extends Filter.Single> provideSecondOrder) {
        Filter filter;
        if (!(order >= 1)) {
            boolean $i$a$-require-Iir$nOrderButterworth$22 = false;
            String $i$a$-require-Iir$nOrderButterworth$22 = "Invalid order: " + order + ". Must be >= 1.";
            throw new IllegalArgumentException($i$a$-require-Iir$nOrderButterworth$22.toString());
        }
        int n = order;
        if (n == 1) {
            filter = this.lowPass1stOrder(cutoffFrequency, samplingFrequency);
        } else if (n == 2) {
            filter = this.lowPassButter2ndOrder(cutoffFrequency, samplingFrequency);
        } else {
            boolean bl = Integer.MIN_VALUE <= n ? n < 1 : false;
            if (bl) {
                throw new IllegalArgumentException("order < 1");
            }
            int numFirstOrder = order % 2;
            int numBiquads = (order - numFirstOrder) / 2;
            double piStep = Math.PI / (double)order;
            double firstPi = numFirstOrder > 0 ? piStep : Math.PI / (double)(order * 2);
            List filters = new ArrayList();
            for (int i = 0; i < numBiquads; ++i) {
                double fPi = firstPi + piStep * (double)i;
                double qFactor = 1.0 / (2.0 * Math.cos(fPi));
                filters.add(provideSecondOrder.invoke((Object)cutoffFrequency, (Object)samplingFrequency, (Object)qFactor));
            }
            if (numFirstOrder > 0) {
                filters.add(provideFirstOrder.invoke((Object)cutoffFrequency, (Object)samplingFrequency));
            }
            Collection $this$toTypedArray$iv = filters;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            filter = new Filter.Cascaded(thisCollection$iv.toArray(new Filter.Single[0]));
        }
        return filter;
    }

    @NotNull
    public final Filter lowPassButterNOrder(int order, double cutoffFrequency, double samplingFrequency) {
        return this.nOrderButterworth(order, cutoffFrequency, samplingFrequency, (Function2<? super Double, ? super Double, ? extends Filter.Single>)((Function2)Iir::lowPassButterNOrder$lambda$1), (Function3<? super Double, ? super Double, ? super Double, ? extends Filter.Single>)((Function3)Iir::lowPassButterNOrder$lambda$2));
    }

    @NotNull
    public final Filter highPassButterNOrder(int order, double cutoffFrequency, double samplingFrequency) {
        return this.nOrderButterworth(order, cutoffFrequency, samplingFrequency, (Function2<? super Double, ? super Double, ? extends Filter.Single>)((Function2)Iir::highPassButterNOrder$lambda$3), (Function3<? super Double, ? super Double, ? super Double, ? extends Filter.Single>)((Function3)Iir::highPassButterNOrder$lambda$4));
    }

    @NotNull
    public final Filter bandPassButterNOrder(int order, double highPassFrequency, double lowPassFrequency, double samplingFrequency) {
        Filter highPass = this.highPassButterNOrder(order, highPassFrequency, samplingFrequency);
        Filter lowPass = this.lowPassButterNOrder(order, lowPassFrequency, samplingFrequency);
        return highPass.combine(lowPass);
    }

    private static final Filter.Single lowPassButterNOrder$lambda$1(double fc, double fs) {
        Filter filter = INSTANCE.lowPass1stOrder(fc, fs);
        Intrinsics.checkNotNull((Object)filter, (String)"null cannot be cast to non-null type vet.inpulse.math.filter.Filter.Single");
        return (Filter.Single)filter;
    }

    private static final Filter.Single lowPassButterNOrder$lambda$2(double fc, double fs, double q) {
        Filter filter = INSTANCE.lowPass2ndOrder(fc, fs, q);
        Intrinsics.checkNotNull((Object)filter, (String)"null cannot be cast to non-null type vet.inpulse.math.filter.Filter.Single");
        return (Filter.Single)filter;
    }

    private static final Filter.Single highPassButterNOrder$lambda$3(double fc, double fs) {
        Filter filter = INSTANCE.highPass1stOrder(fc, fs);
        Intrinsics.checkNotNull((Object)filter, (String)"null cannot be cast to non-null type vet.inpulse.math.filter.Filter.Single");
        return (Filter.Single)filter;
    }

    private static final Filter.Single highPassButterNOrder$lambda$4(double fc, double fs, double q) {
        Filter filter = INSTANCE.highPass2ndOrder(fc, fs, q);
        Intrinsics.checkNotNull((Object)filter, (String)"null cannot be cast to non-null type vet.inpulse.math.filter.Filter.Single");
        return (Filter.Single)filter;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lvet/inpulse/math/filter/Iir$KAndNorm;", "", "k", "", "norm", "<init>", "(DD)V", "getK", "()D", "getNorm", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "math"})
    private static final class KAndNorm {
        private final double k;
        private final double norm;

        public KAndNorm(double k, double norm) {
            this.k = k;
            this.norm = norm;
        }

        public final double getK() {
            return this.k;
        }

        public final double getNorm() {
            return this.norm;
        }

        public final double component1() {
            return this.k;
        }

        public final double component2() {
            return this.norm;
        }

        @NotNull
        public final KAndNorm copy(double k, double norm) {
            return new KAndNorm(k, norm);
        }

        public static /* synthetic */ KAndNorm copy$default(KAndNorm kAndNorm, double d, double d2, int n, Object object) {
            if ((n & 1) != 0) {
                d = kAndNorm.k;
            }
            if ((n & 2) != 0) {
                d2 = kAndNorm.norm;
            }
            return kAndNorm.copy(d, d2);
        }

        @NotNull
        public String toString() {
            return "KAndNorm(k=" + this.k + ", norm=" + this.norm + ")";
        }

        public int hashCode() {
            int result = Double.hashCode(this.k);
            result = result * 31 + Double.hashCode(this.norm);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof KAndNorm)) {
                return false;
            }
            KAndNorm kAndNorm = (KAndNorm)other;
            if (Double.compare(this.k, kAndNorm.k) != 0) {
                return false;
            }
            return Double.compare(this.norm, kAndNorm.norm) == 0;
        }
    }
}

