/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.math.fft;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.math.ArraysUtilsKt;
import vet.inpulse.math.SignalUtilsKt;
import vet.inpulse.math.complex.Complex;
import vet.inpulse.math.complex.ComplexArray;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0006\n\u0002\b\n\u001a\u001c\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u001a&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002\u001a\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0002\u001a&\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002\u001a,\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000e2\b\b\u0002\u0010\u0006\u001a\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\u00022\b\b\u0002\u0010\u000b\u001a\u00020\u0002\u001aH\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u000e2\b\b\u0002\u0010\u0006\u001a\u00020\u00022\b\b\u0002\u0010\u0014\u001a\u00020\u00022\b\b\u0002\u0010\u0015\u001a\u00020\u00022\b\b\u0002\u0010\u0016\u001a\u00020\u00022\b\b\u0002\u0010\u0017\u001a\u00020\u0002\u001a,\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\u00022\b\b\u0002\u0010\u000b\u001a\u00020\u0002\u001aH\u0010\u0018\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00022\b\b\u0002\u0010\u001a\u001a\u00020\u00022\b\b\u0002\u0010\u001b\u001a\u00020\u00022\b\b\u0002\u0010\u001c\u001a\u00020\u00022\b\b\u0002\u0010\u001d\u001a\u00020\u0002\u001a,\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u001e\u001a\u00020\u00022\b\b\u0002\u0010\u001a\u001a\u00020\u00022\b\b\u0002\u0010\u001b\u001a\u00020\u0002\u001a\u001e\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u0002\u001aH\u0010#\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u001a\u001a\u00020\u00022\b\b\u0002\u0010\u001b\u001a\u00020\u00022\b\b\u0002\u0010\u001e\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u00042\b\b\u0002\u0010%\u001a\u00020\u00022\b\b\u0002\u0010&\u001a\u00020\u0002\u001aH\u0010'\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u001a\u001a\u00020\u00022\b\b\u0002\u0010\u001b\u001a\u00020\u00022\b\b\u0002\u0010\u001e\u001a\u00020\u00022\u0006\u0010(\u001a\u00020\u00042\b\b\u0002\u0010%\u001a\u00020\u00022\b\b\u0002\u0010&\u001a\u00020\u0002\u001a.\u0010)\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010*\u001a\u00020\u0002\"&\u0010\u0000\u001a\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"sinCosLookupTables", "", "", "Lkotlin/Pair;", "", "getLUT", "length", "blackmanWindow", "", "out", "offset", "stride", "bitReverse", "array", "Lvet/inpulse/math/complex/ComplexArray;", "fft", "data", "realFft", "source", "destination", "sourceOffset", "sourceStride", "destinationOffset", "destinationStride", "singleSidedSpectrum", "spectrumOut", "fftOffset", "fftStride", "spectrumOffset", "spectrumStride", "fftLength", "fftPositiveFrequencyBucket", "frequency", "", "samplingRate", "realSpectralPower", "powerOut", "powerOffset", "powerStride", "complexSpectralPower", "power", "spectrogram", "windowSize", "math"})
@SourceDebugExtension(value={"SMAP\nFft.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fft.kt\nvet/inpulse/math/fft/FftKt\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 SignalUtils.kt\nvet/inpulse/math/SignalUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,337:1\n382#2,7:338\n206#3:345\n206#3:346\n206#3:347\n206#3:348\n206#3:349\n206#3:351\n206#3:352\n206#3:353\n206#3:354\n206#3:355\n206#3:356\n206#3:357\n206#3:358\n206#3:359\n206#3:360\n206#3:361\n1#4:350\n*S KotlinDebug\n*F\n+ 1 Fft.kt\nvet/inpulse/math/fft/FftKt\n*L\n20#1:338,7\n36#1:345\n66#1:346\n69#1:347\n70#1:348\n73#1:349\n109#1:351\n113#1:352\n117#1:353\n120#1:354\n124#1:355\n224#1:356\n225#1:357\n290#1:358\n291#1:359\n316#1:360\n317#1:361\n*E\n"})
public final class FftKt {
    @NotNull
    private static final Map<Integer, Pair<double[], double[]>> sinCosLookupTables = new LinkedHashMap();

    /*
     * WARNING - void declaration
     */
    private static final Pair<double[], double[]> getLUT(int length) {
        Object object;
        void $this$getOrPut$iv;
        Map<Integer, Pair<double[], double[]>> map = sinCosLookupTables;
        Integer key$iv = length;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            int n = length / 2;
            double[] sinArray = new double[n];
            double[] cosArray = new double[n];
            for (int i = 0; i < n; ++i) {
                sinArray[i] = Math.sin(Math.PI * -2 * (double)i / (double)length);
                cosArray[i] = Math.cos(Math.PI * -2 * (double)i / (double)length);
            }
            Pair answer$iv = TuplesKt.to((Object)sinArray, (Object)cosArray);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Pair)object;
    }

    /*
     * WARNING - void declaration
     */
    public static final void blackmanWindow(@NotNull double[] out, int offset, int stride, int length) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        for (int n = 0; n < length; ++n) {
            void offset$iv;
            void stride$iv;
            int n2 = offset;
            int n3 = stride;
            int index$iv = n;
            boolean $i$f$element = false;
            int index = index$iv * stride$iv + offset$iv;
            out[index] = 0.42 - 0.5 * Math.cos(Math.PI * 2 * (double)n / (double)(length - 1));
            double cfr_ignored_0 = 0.08 * Math.cos(Math.PI * 4 * (double)n / (double)(length - 1));
        }
    }

    @NotNull
    public static final double[] blackmanWindow(int length) {
        double[] window = new double[length];
        FftKt.blackmanWindow(window, 0, 1, length);
        return window;
    }

    public static final void bitReverse(@NotNull ComplexArray array, int offset, int stride, int length) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        int j = 0;
        int n1 = 0;
        int n2 = length / 2;
        Complex tempC1 = new Complex(0.0, 0.0, 3, null);
        Complex tempC2 = new Complex(0.0, 0.0, 3, null);
        int n = length - 1;
        for (int i = 1; i < n; ++i) {
            int offset$iv;
            int stride$iv;
            for (n1 = n2; j >= n1; j -= n1, n1 /= 2) {
            }
            if (i >= (j += n1)) continue;
            int n3 = offset;
            int n4 = stride;
            int index$iv = i;
            boolean $i$f$element = false;
            array.get(index$iv * stride$iv + offset$iv, tempC1);
            offset$iv = offset;
            stride$iv = stride;
            index$iv = j;
            $i$f$element = false;
            array.get(index$iv * stride$iv + offset$iv, tempC2);
            offset$iv = offset;
            stride$iv = stride;
            index$iv = i;
            $i$f$element = false;
            array.set(index$iv * stride$iv + offset$iv, tempC2);
            offset$iv = offset;
            stride$iv = stride;
            index$iv = j;
            $i$f$element = false;
            array.set(index$iv * stride$iv + offset$iv, tempC1);
        }
    }

    public static final void fft(@NotNull ComplexArray data, int length, int offset, int stride) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!(SignalUtilsKt.intIsBinary(length) || length == 1)) {
            boolean $i$a$-require-FftKt$fft$22 = false;
            String $i$a$-require-FftKt$fft$22 = "Length must be a power of 2. Was " + length + ".";
            throw new IllegalArgumentException($i$a$-require-FftKt$fft$22.toString());
        }
        int m = SignalUtilsKt.binaryLog(length);
        int n1 = 0;
        int n2 = 1;
        int a = 0;
        Complex wk = new Complex(0.0, 0.0, 3, null);
        Complex tempC1 = new Complex(0.0, 0.0, 3, null);
        Complex tempC2 = new Complex(0.0, 0.0, 3, null);
        Pair<double[], double[]> pair = FftKt.getLUT(length);
        double[] sin = (double[])pair.component1();
        double[] cos = (double[])pair.component2();
        FftKt.bitReverse(data, offset, stride, length);
        for (int i = 0; i < m; ++i) {
            n1 = n2;
            n2 += n2;
            a = 0;
            int n = n1;
            block1: for (int j = 0; j < n; ++j) {
                wk.set(cos[a], sin[a]);
                a += 1 << m - i - 1;
                IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)j, (int)length)), (int)n2);
                int k = intProgression.getFirst();
                int n3 = intProgression.getLast();
                int n4 = intProgression.getStep();
                if ((n4 <= 0 || k > n3) && (n4 >= 0 || n3 > k)) continue;
                while (true) {
                    int offset$iv;
                    int stride$iv;
                    int n5 = offset;
                    int n6 = stride;
                    int index$iv = k + n1;
                    boolean $i$f$element = false;
                    data.get(index$iv * stride$iv + offset$iv, tempC2);
                    tempC2.timesAssign(wk);
                    offset$iv = offset;
                    stride$iv = stride;
                    index$iv = k;
                    $i$f$element = false;
                    data.get(index$iv * stride$iv + offset$iv, tempC1);
                    tempC1.minusAssign(tempC2);
                    offset$iv = offset;
                    stride$iv = stride;
                    index$iv = k + n1;
                    $i$f$element = false;
                    data.set(index$iv * stride$iv + offset$iv, tempC1);
                    offset$iv = offset;
                    stride$iv = stride;
                    index$iv = k;
                    $i$f$element = false;
                    data.get(index$iv * stride$iv + offset$iv, tempC1);
                    tempC1.plusAssign(tempC2);
                    offset$iv = offset;
                    stride$iv = stride;
                    index$iv = k;
                    $i$f$element = false;
                    data.set(index$iv * stride$iv + offset$iv, tempC1);
                    if (k == n3) continue block1;
                    k += n4;
                }
            }
        }
    }

    public static /* synthetic */ void fft$default(ComplexArray complexArray, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = complexArray.getSize();
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = 1;
        }
        FftKt.fft(complexArray, n, n2, n3);
    }

    public static final void realFft(@NotNull double[] source, @NotNull ComplexArray destination, int length, int sourceOffset, int sourceStride, int destinationOffset, int destinationStride) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        ArraysUtilsKt.copy(source, sourceOffset, sourceStride, destination.getData(), destinationOffset * 2, destinationStride * 2, length);
        FftKt.fft(destination, length, destinationOffset, destinationStride);
    }

    public static /* synthetic */ void realFft$default(double[] dArray, ComplexArray complexArray, int n, int n2, int n3, int n4, int n5, int n6, Object object) {
        if ((n6 & 4) != 0) {
            n = dArray.length;
        }
        if ((n6 & 8) != 0) {
            n2 = 0;
        }
        if ((n6 & 0x10) != 0) {
            n3 = 1;
        }
        if ((n6 & 0x20) != 0) {
            n4 = 0;
        }
        if ((n6 & 0x40) != 0) {
            n5 = 1;
        }
        FftKt.realFft(dArray, complexArray, n, n2, n3, n4, n5);
    }

    @NotNull
    public static final ComplexArray realFft(@NotNull double[] source, int length, int offset, int stride) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        ComplexArray destination = new ComplexArray(length);
        FftKt.realFft(source, destination, length, offset, stride, 0, 1);
        return destination;
    }

    public static /* synthetic */ ComplexArray realFft$default(double[] dArray, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = dArray.length;
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = 1;
        }
        return FftKt.realFft(dArray, n, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    public static final void singleSidedSpectrum(@NotNull ComplexArray fft, @NotNull double[] spectrumOut, int length, int fftOffset, int fftStride, int spectrumOffset, int spectrumStride) {
        Intrinsics.checkNotNullParameter((Object)fft, (String)"fft");
        Intrinsics.checkNotNullParameter((Object)spectrumOut, (String)"spectrumOut");
        if (!SignalUtilsKt.intIsBinary(length)) {
            boolean $i$a$-require-FftKt$singleSidedSpectrum$22 = false;
            String $i$a$-require-FftKt$singleSidedSpectrum$22 = "Length must be a power of 2. Was " + length + ".";
            throw new IllegalArgumentException($i$a$-require-FftKt$singleSidedSpectrum$22.toString());
        }
        int l = length / 2;
        spectrumOut[spectrumOffset] = fft.get(fftOffset).getMag() / (double)l;
        Complex f = new Complex(0.0, 0.0, 3, null);
        int k = 1;
        while (k < l) {
            double v;
            void offset$iv;
            void stride$iv;
            void offset$iv2;
            int stride$iv2;
            int n = fftOffset;
            int n2 = fftStride;
            int index$iv = k;
            boolean $i$f$element = false;
            int inputIndex = index$iv * stride$iv2 + offset$iv2;
            stride$iv2 = spectrumOffset;
            index$iv = spectrumStride;
            int index$iv2 = k++;
            boolean $i$f$element2 = false;
            int outputIndex = index$iv2 * stride$iv + offset$iv;
            fft.get(inputIndex, f);
            spectrumOut[outputIndex] = v = (double)2 * f.getMag() / (double)l;
        }
    }

    public static /* synthetic */ void singleSidedSpectrum$default(ComplexArray complexArray, double[] dArray, int n, int n2, int n3, int n4, int n5, int n6, Object object) {
        if ((n6 & 4) != 0) {
            n = complexArray.getSize();
        }
        if ((n6 & 8) != 0) {
            n2 = 0;
        }
        if ((n6 & 0x10) != 0) {
            n3 = 1;
        }
        if ((n6 & 0x20) != 0) {
            n4 = 0;
        }
        if ((n6 & 0x40) != 0) {
            n5 = 1;
        }
        FftKt.singleSidedSpectrum(complexArray, dArray, n, n2, n3, n4, n5);
    }

    @NotNull
    public static final double[] singleSidedSpectrum(@NotNull ComplexArray fft, int fftLength, int fftOffset, int fftStride) {
        Intrinsics.checkNotNullParameter((Object)fft, (String)"fft");
        int length = fftLength / 2;
        double[] spectrum = new double[length];
        FftKt.singleSidedSpectrum$default(fft, spectrum, fftLength, fftOffset, fftStride, 0, 0, 96, null);
        return spectrum;
    }

    public static /* synthetic */ double[] singleSidedSpectrum$default(ComplexArray complexArray, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = complexArray.getSize();
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = 1;
        }
        return FftKt.singleSidedSpectrum(complexArray, n, n2, n3);
    }

    public static final int fftPositiveFrequencyBucket(double frequency, double samplingRate, int fftLength) {
        if (!(frequency <= samplingRate)) {
            boolean bl = false;
            String string = "Frequency must be <= samplingRate. Was frequency=" + frequency + ", samplingRate=" + samplingRate + ".";
            throw new IllegalArgumentException(string.toString());
        }
        return MathKt.roundToInt((double)(frequency / samplingRate * (double)fftLength));
    }

    /*
     * WARNING - void declaration
     */
    public static final void realSpectralPower(@NotNull ComplexArray fft, int fftOffset, int fftStride, int fftLength, @NotNull double[] powerOut, int powerOffset, int powerStride) {
        Intrinsics.checkNotNullParameter((Object)fft, (String)"fft");
        Intrinsics.checkNotNullParameter((Object)powerOut, (String)"powerOut");
        if (!SignalUtilsKt.intIsBinary(fftLength)) {
            boolean $i$a$-require-FftKt$realSpectralPower$22 = false;
            String $i$a$-require-FftKt$realSpectralPower$22 = "Length must be a power of 2. Was " + fftLength + ".";
            throw new IllegalArgumentException($i$a$-require-FftKt$realSpectralPower$22.toString());
        }
        int length = fftLength / 2;
        Complex f = new Complex(0.0, 0.0, 3, null);
        double scaling = 1.0 / (Math.PI * 2 * (double)fftLength);
        int nyquist = length - 1;
        for (int k = 0; k < length; ++k) {
            void offset$iv;
            void stride$iv;
            void offset$iv2;
            int stride$iv2;
            int n = fftOffset;
            int n2 = fftStride;
            int index$iv = k;
            boolean $i$f$element = false;
            int inputIndex = index$iv * stride$iv2 + offset$iv2;
            stride$iv2 = powerOffset;
            index$iv = powerStride;
            int index$iv2 = k;
            boolean $i$f$element2 = false;
            int outputIndex = index$iv2 * stride$iv + offset$iv;
            fft.get(inputIndex, f);
            double p = scaling * f.getMagSqr();
            if (k != 0 && k != nyquist) {
                p *= (double)2;
            }
            powerOut[outputIndex] = p;
        }
    }

    public static /* synthetic */ void realSpectralPower$default(ComplexArray complexArray, int n, int n2, int n3, double[] dArray, int n4, int n5, int n6, Object object) {
        if ((n6 & 2) != 0) {
            n = 0;
        }
        if ((n6 & 4) != 0) {
            n2 = 1;
        }
        if ((n6 & 8) != 0) {
            n3 = complexArray.getSize();
        }
        if ((n6 & 0x20) != 0) {
            n4 = 0;
        }
        if ((n6 & 0x40) != 0) {
            n5 = 1;
        }
        FftKt.realSpectralPower(complexArray, n, n2, n3, dArray, n4, n5);
    }

    /*
     * WARNING - void declaration
     */
    public static final void complexSpectralPower(@NotNull ComplexArray fft, int fftOffset, int fftStride, int fftLength, @NotNull double[] power, int powerOffset, int powerStride) {
        Intrinsics.checkNotNullParameter((Object)fft, (String)"fft");
        Intrinsics.checkNotNullParameter((Object)power, (String)"power");
        if (!SignalUtilsKt.intIsBinary(fftLength)) {
            boolean $i$a$-require-FftKt$complexSpectralPower$22 = false;
            String $i$a$-require-FftKt$complexSpectralPower$22 = "Length must be a power of 2. Was " + fftLength + ".";
            throw new IllegalArgumentException($i$a$-require-FftKt$complexSpectralPower$22.toString());
        }
        Complex f = new Complex(0.0, 0.0, 3, null);
        double scaling = 1.0 / (Math.PI * 2 * (double)fftLength);
        int k = 0;
        while (k < fftLength) {
            void offset$iv;
            void stride$iv;
            void offset$iv2;
            int stride$iv2;
            int n = fftOffset;
            int n2 = fftStride;
            int index$iv = k;
            boolean $i$f$element = false;
            int inputIndex = index$iv * stride$iv2 + offset$iv2;
            stride$iv2 = powerOffset;
            index$iv = powerStride;
            int index$iv2 = k++;
            boolean $i$f$element2 = false;
            int outputIndex = index$iv2 * stride$iv + offset$iv;
            fft.get(inputIndex, f);
            power[outputIndex] = scaling * f.getMagSqr();
        }
    }

    public static /* synthetic */ void complexSpectralPower$default(ComplexArray complexArray, int n, int n2, int n3, double[] dArray, int n4, int n5, int n6, Object object) {
        if ((n6 & 2) != 0) {
            n = 0;
        }
        if ((n6 & 4) != 0) {
            n2 = 1;
        }
        if ((n6 & 8) != 0) {
            n3 = complexArray.getSize();
        }
        if ((n6 & 0x20) != 0) {
            n4 = 0;
        }
        if ((n6 & 0x40) != 0) {
            n5 = 1;
        }
        FftKt.complexSpectralPower(complexArray, n, n2, n3, dArray, n4, n5);
    }

    public static final void spectrogram(@NotNull ComplexArray data, int offset, int stride, int length, int windowSize) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int iterations = (int)Math.floor((double)length / (double)windowSize);
        for (int i = 0; i < iterations; ++i) {
            int dataOffset = windowSize * i;
            FftKt.fft(data, offset + dataOffset, stride, windowSize);
        }
    }
}

