/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.math.complex;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.math.complex.Complex;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010\u001a\u001a\u00020\u001bJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020%H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006&"}, d2={"Lvet/inpulse/math/complex/Polar;", "", "r", "", "alpha", "<init>", "(DD)V", "getR", "()D", "setR", "(D)V", "getAlpha", "setAlpha", "reciprocal", "getReciprocal", "()Lvet/inpulse/math/complex/Polar;", "plus", "p", "plusAssign", "", "minus", "minusAssign", "times", "timesAssign", "div", "divAssign", "toComplex", "Lvet/inpulse/math/complex/Complex;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "math"})
@SourceDebugExtension(value={"SMAP\nComplex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Complex.kt\nvet/inpulse/math/complex/Polar\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,250:1\n1#2:251\n*E\n"})
public final class Polar {
    private double r;
    private double alpha;

    public Polar(double r, double alpha) {
        this.r = r;
        this.alpha = alpha;
    }

    public /* synthetic */ Polar(double d, double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 1.0;
        }
        this(d, d2);
    }

    public final double getR() {
        return this.r;
    }

    public final void setR(double d) {
        this.r = d;
    }

    public final double getAlpha() {
        return this.alpha;
    }

    public final void setAlpha(double d) {
        this.alpha = d;
    }

    @NotNull
    public final Polar getReciprocal() {
        return new Polar(1.0 / this.r, -this.alpha);
    }

    @NotNull
    public final Polar plus(@NotNull Polar p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return this.toComplex().plus(p.toComplex()).toPolar();
    }

    public final void plusAssign(@NotNull Polar p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Polar r = this.plus(p);
        this.r = r.r;
        this.alpha = r.alpha;
    }

    @NotNull
    public final Polar minus(@NotNull Polar p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return this.toComplex().minus(p.toComplex()).toPolar();
    }

    public final void minusAssign(@NotNull Polar p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Polar r = this.minus(p);
        this.r = r.r;
        this.alpha = r.alpha;
    }

    @NotNull
    public final Polar times(@NotNull Polar p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return new Polar(this.r * p.r, this.alpha - p.alpha);
    }

    public final void timesAssign(@NotNull Polar p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        this.r *= p.r;
        this.alpha -= p.alpha;
    }

    @NotNull
    public final Polar div(@NotNull Polar p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        if (!(!(p.r == 0.0))) {
            boolean bl = false;
            String string = "Magnitude r == 0.";
            throw new IllegalArgumentException(string.toString());
        }
        return new Polar(this.r / p.r, this.alpha + p.alpha);
    }

    public final void divAssign(@NotNull Polar p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        if (!(!(p.r == 0.0))) {
            boolean bl = false;
            String string = "Magnitude r == 0.";
            throw new IllegalArgumentException(string.toString());
        }
        this.r /= p.r;
        this.alpha -= p.alpha;
    }

    @NotNull
    public final Complex toComplex() {
        double real = this.r * Math.cos(this.alpha);
        double imag = this.r * Math.sin(this.alpha);
        return new Complex(real, imag);
    }

    public final double component1() {
        return this.r;
    }

    public final double component2() {
        return this.alpha;
    }

    @NotNull
    public final Polar copy(double r, double alpha) {
        return new Polar(r, alpha);
    }

    public static /* synthetic */ Polar copy$default(Polar polar, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = polar.r;
        }
        if ((n & 2) != 0) {
            d2 = polar.alpha;
        }
        return polar.copy(d, d2);
    }

    @NotNull
    public String toString() {
        return "Polar(r=" + this.r + ", alpha=" + this.alpha + ")";
    }

    public int hashCode() {
        int result = Double.hashCode(this.r);
        result = result * 31 + Double.hashCode(this.alpha);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Polar)) {
            return false;
        }
        Polar polar = (Polar)other;
        if (Double.compare(this.r, polar.r) != 0) {
            return false;
        }
        return Double.compare(this.alpha, polar.alpha) == 0;
    }
}

