/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.math.complex;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.math.complex.Complex;
import vet.inpulse.math.complex.Polar;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0015\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\n\u001a\u00020\u0001H\u0086\u0002\u001a\u0015\u0010\t\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\n\u001a\u00020\u0001H\u0086\u0002\u001a\u0015\u0010\t\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\n\u001a\u00020\u0001H\u0086\u0002\u001a\u0015\u0010\u000b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\n\u001a\u00020\u0001H\u0086\u0002\u001a\u0015\u0010\u000b\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\n\u001a\u00020\u0001H\u0086\u0002\u001a\u0015\u0010\u000b\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\n\u001a\u00020\u0001H\u0086\u0002\u001a\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\r2\u0006\u0010\n\u001a\u00020\u0001\u001a\u000e\u0010\u000e\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001\u001a\u0016\u0010\u000f\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0007\u001a\u0016\u0010\u000f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0007\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\b\u00a8\u0006\u0013"}, d2={"i", "Lvet/inpulse/math/complex/Complex;", "", "getI", "(D)Lvet/inpulse/math/complex/Complex;", "", "(F)Lvet/inpulse/math/complex/Complex;", "", "(I)Lvet/inpulse/math/complex/Complex;", "plus", "c", "minus", "sqrt", "", "exp", "pow", "n", "Lvet/inpulse/math/complex/Polar;", "p", "math"})
public final class ComplexKt {
    @NotNull
    public static final Complex getI(double $this$i) {
        return new Complex(0.0, $this$i);
    }

    @NotNull
    public static final Complex getI(float $this$i) {
        return new Complex(0.0, $this$i);
    }

    @NotNull
    public static final Complex getI(int $this$i) {
        return new Complex(0.0, $this$i);
    }

    @NotNull
    public static final Complex plus(double $this$plus, @NotNull Complex c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return new Complex($this$plus + c.getReal(), c.getImag());
    }

    @NotNull
    public static final Complex plus(float $this$plus, @NotNull Complex c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return new Complex((double)$this$plus + c.getReal(), c.getImag());
    }

    @NotNull
    public static final Complex plus(int $this$plus, @NotNull Complex c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return new Complex((double)$this$plus + c.getReal(), c.getImag());
    }

    @NotNull
    public static final Complex minus(double $this$minus, @NotNull Complex c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return new Complex($this$minus - c.getReal(), -c.getImag());
    }

    @NotNull
    public static final Complex minus(float $this$minus, @NotNull Complex c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return new Complex((double)$this$minus - c.getReal(), -c.getImag());
    }

    @NotNull
    public static final Complex minus(int $this$minus, @NotNull Complex c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return new Complex((double)$this$minus - c.getReal(), -c.getImag());
    }

    @NotNull
    public static final List<Complex> sqrt(@NotNull Complex c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        if (c.getImag() == 0.0) {
            return c.getReal() >= 0.0 ? CollectionsKt.listOf((Object)new Complex(Math.sqrt(c.getReal()), 0.0)) : CollectionsKt.listOf((Object)new Complex(0.0, Math.sqrt(c.getReal())));
        }
        double sigma = Math.sqrt((c.getReal() + c.getMag()) / (double)2);
        double delta = Math.signum(c.getImag()) * Math.sqrt((-c.getReal() + c.getMag()) / (double)2);
        Object[] objectArray = new Complex[]{new Complex(sigma, delta), new Complex(-sigma, -delta)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public static final Complex exp(@NotNull Complex c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        double realPart = Math.exp(c.getReal());
        double complexRealPart = Math.cos(c.getImag());
        double complexImagPart = Math.sin(c.getImag());
        return new Complex(realPart * complexRealPart, realPart * complexImagPart);
    }

    @NotNull
    public static final Complex pow(@NotNull Complex c, int n) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Polar polar = c.toPolar();
        double rN = Math.pow(polar.getR(), n);
        double realPart = rN * Math.cos((double)n * polar.getAlpha());
        double imagPart = rN * Math.sin((double)n * polar.getAlpha());
        return new Complex(realPart, imagPart);
    }

    @NotNull
    public static final Polar pow(@NotNull Polar p, int n) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        double rN = Math.pow(p.getR(), n);
        double realPart = rN * Math.cos((double)n * p.getAlpha());
        double imagPart = rN * Math.sin((double)n * p.getAlpha());
        return new Complex(realPart, imagPart).toPolar();
    }
}

