/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.math.complex;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.math.ArraysUtilsKt;
import vet.inpulse.math.complex.Complex;
import vet.inpulse.math.complex.ComplexIterator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0013\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\u0004\u0010\tJ\u0011\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0003H\u0086\u0002J\u0019\u0010\u0010\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\bH\u0086\u0002J\u0019\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\bH\u0086\u0002J\t\u0010\u0016\u001a\u00020\u0017H\u0086\u0002J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0000J&\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0003J\u000e\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0000J\u001e\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003J\u001e\u0010 \u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003J\u0013\u0010!\u001a\u00020\"2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010#\u001a\u00020\u0003H\u0016J\b\u0010$\u001a\u00020%H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006'"}, d2={"Lvet/inpulse/math/complex/ComplexArray;", "", "size", "", "<init>", "(I)V", "init", "Lkotlin/Function1;", "Lvet/inpulse/math/complex/Complex;", "(ILkotlin/jvm/functions/Function1;)V", "getSize", "()I", "data", "", "getData", "()[D", "get", "pos", "", "out", "set", "value", "iterator", "Lvet/inpulse/math/complex/ComplexIterator;", "copyInto", "other", "offset", "destOffset", "length", "copyFrom", "reals", "stride", "imags", "equals", "", "hashCode", "toString", "", "Companion", "math"})
@SourceDebugExtension(value={"SMAP\nComplexArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComplexArray.kt\nvet/inpulse/math/complex/ComplexArray\n+ 2 SignalUtils.kt\nvet/inpulse/math/SignalUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,165:1\n206#2:166\n206#2:167\n206#2:168\n206#2:170\n206#2:171\n1#3:169\n*S KotlinDebug\n*F\n+ 1 ComplexArray.kt\nvet/inpulse/math/complex/ComplexArray\n*L\n68#1:166\n75#1:167\n83#1:168\n105#1:170\n110#1:171\n*E\n"})
public final class ComplexArray {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int size;
    @NotNull
    private final double[] data;

    public ComplexArray(int size) {
        this.size = size;
        this.data = new double[this.size * 2];
    }

    public final int getSize() {
        return this.size;
    }

    @NotNull
    public final double[] getData() {
        return this.data;
    }

    public ComplexArray(int size, @NotNull Function1<? super Integer, Complex> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        this(size);
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)(size * 2))), (int)2);
        int i = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
            while (true) {
                Complex c = (Complex)init.invoke((Object)(i / 2));
                this.data[i] = c.getReal();
                this.data[i + 1] = c.getImag();
                if (i == n) break;
                i += n2;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Complex get(int pos) {
        void offset$iv;
        void stride$iv;
        boolean bl = false;
        int n = 2;
        int index$iv = pos;
        boolean $i$f$element = false;
        int index = index$iv * stride$iv + offset$iv;
        double real = this.data[index];
        double imag = this.data[index + 1];
        return new Complex(real, imag);
    }

    /*
     * WARNING - void declaration
     */
    public final void get(int pos, @NotNull Complex out) {
        void offset$iv;
        void stride$iv;
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        boolean bl = false;
        int n = 2;
        int index$iv = pos;
        boolean $i$f$element = false;
        int index = index$iv * stride$iv + offset$iv;
        double real = this.data[index];
        double imag = this.data[index + 1];
        out.setReal(real);
        out.setImag(imag);
    }

    /*
     * WARNING - void declaration
     */
    public final void set(int pos, @NotNull Complex value) {
        void offset$iv;
        void stride$iv;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean bl = false;
        int n = 2;
        int index$iv = pos;
        boolean $i$f$element = false;
        int index = index$iv * stride$iv + offset$iv;
        this.data[index] = value.getReal();
        this.data[index + 1] = value.getImag();
    }

    @NotNull
    public final ComplexIterator iterator() {
        return new ComplexIterator(this);
    }

    public final void copyInto(@NotNull ComplexArray other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(other.data.length >= this.data.length)) {
            boolean bl = false;
            String string = "Data does not fit into dest (required size: " + this.data.length + ". actual size: " + other.data.length;
            throw new IllegalArgumentException(string.toString());
        }
        ArraysUtilsKt.copy(this.data, 0, 1, other.data, 0, 1, this.data.length);
    }

    public final void copyInto(int offset, @NotNull ComplexArray other, int destOffset, int length) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ArraysUtilsKt.copy(this.data, offset * 2, 1, other.data, destOffset * 2, 1, length * 2);
    }

    public final void copyFrom(@NotNull ComplexArray other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(this.data.length >= other.data.length)) {
            boolean bl = false;
            String string = "Data does not fit into dest (required size: " + other.data.length + ". actual size: " + this.data.length;
            throw new IllegalArgumentException(string.toString());
        }
        ArraysUtilsKt.copy(other.data, 0, 1, this.data, 0, 1, other.data.length);
    }

    /*
     * WARNING - void declaration
     */
    public final void reals(@NotNull double[] out, int offset, int stride) {
        void offset$iv;
        void stride$iv;
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        int n = offset;
        int n2 = stride;
        int index$iv = this.size;
        boolean $i$f$element = false;
        if (!(index$iv * stride$iv + offset$iv >= out.length)) {
            boolean bl = false;
            String string = "Array does not have the required size to store this ComplexArray. Required size is " + this.size + ". Out size was " + out.length;
            throw new IllegalArgumentException(string.toString());
        }
        ArraysUtilsKt.copy(this.data, 0, 2, out, offset, stride, this.size);
    }

    /*
     * WARNING - void declaration
     */
    public final void imags(@NotNull double[] out, int offset, int stride) {
        void offset$iv;
        void stride$iv;
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        int n = offset;
        int n2 = stride;
        int index$iv = this.size;
        boolean $i$f$element = false;
        if (!(index$iv * stride$iv + offset$iv >= out.length)) {
            boolean bl = false;
            String string = "Array does not have the required size to store this ComplexArray. Required size is " + this.size + ". Out size was " + out.length;
            throw new IllegalArgumentException(string.toString());
        }
        ArraysUtilsKt.copy(this.data, 1, 2, out, offset, stride, this.size);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ComplexArray cfr_ignored_0 = (ComplexArray)other;
        if (this.size != ((ComplexArray)other).size) {
            return false;
        }
        return Arrays.equals(this.data, ((ComplexArray)other).data);
    }

    public int hashCode() {
        int result = this.size;
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    @NotNull
    public String toString() {
        String string = Arrays.toString(this.data);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return "ComplexArray(data=" + string + ")";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\b\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tJ&\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tJ>\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t\u00a8\u0006\u0013"}, d2={"Lvet/inpulse/math/complex/ComplexArray$Companion;", "", "<init>", "()V", "fromReals", "Lvet/inpulse/math/complex/ComplexArray;", "reals", "", "offset", "", "stride", "length", "fromImags", "imags", "fromRealsAndImags", "realsOffset", "realsStride", "imagsOffset", "imagsStride", "math"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ComplexArray fromReals(@NotNull double[] reals, int offset, int stride, int length) {
            Intrinsics.checkNotNullParameter((Object)reals, (String)"reals");
            ComplexArray complexes = new ComplexArray(length);
            ArraysUtilsKt.copy(reals, offset, stride, complexes.getData(), 0, 2, length);
            return complexes;
        }

        @NotNull
        public final ComplexArray fromImags(@NotNull double[] imags, int offset, int stride, int length) {
            Intrinsics.checkNotNullParameter((Object)imags, (String)"imags");
            ComplexArray complexes = new ComplexArray(length);
            ArraysUtilsKt.copy(imags, offset, stride, complexes.getData(), 1, 2, length);
            return complexes;
        }

        @NotNull
        public final ComplexArray fromRealsAndImags(@NotNull double[] reals, int realsOffset, int realsStride, @NotNull double[] imags, int imagsOffset, int imagsStride, int length) {
            Intrinsics.checkNotNullParameter((Object)reals, (String)"reals");
            Intrinsics.checkNotNullParameter((Object)imags, (String)"imags");
            ComplexArray complexes = new ComplexArray(length);
            ArraysUtilsKt.copy(reals, realsOffset, realsStride, complexes.getData(), 0, 2, length);
            ArraysUtilsKt.copy(imags, imagsOffset, imagsStride, complexes.getData(), 1, 2, length);
            return complexes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

