/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.math;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.math.Curve;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J;\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006 "}, d2={"Lvet/inpulse/math/ExpCurve;", "Lvet/inpulse/math/Curve;", "a", "", "b", "c", "d", "offset", "<init>", "(DDDDD)V", "getA", "()D", "getB", "getC", "getD", "getOffset", "eval", "x", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "math"})
public final class ExpCurve
implements Curve {
    private final double a;
    private final double b;
    private final double c;
    private final double d;
    private final double offset;

    public ExpCurve(double a, double b, double c, double d, double offset) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.offset = offset;
    }

    public /* synthetic */ ExpCurve(double d, double d2, double d3, double d4, double d5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            d5 = 0.0;
        }
        this(d, d2, d3, d4, d5);
    }

    public final double getA() {
        return this.a;
    }

    public final double getB() {
        return this.b;
    }

    public final double getC() {
        return this.c;
    }

    public final double getD() {
        return this.d;
    }

    public final double getOffset() {
        return this.offset;
    }

    @Override
    public double eval(double x) {
        return this.a * Math.exp(this.b * x) + this.c * Math.exp(this.d * x) + this.offset;
    }

    public final double component1() {
        return this.a;
    }

    public final double component2() {
        return this.b;
    }

    public final double component3() {
        return this.c;
    }

    public final double component4() {
        return this.d;
    }

    public final double component5() {
        return this.offset;
    }

    @NotNull
    public final ExpCurve copy(double a, double b, double c, double d, double offset) {
        return new ExpCurve(a, b, c, d, offset);
    }

    public static /* synthetic */ ExpCurve copy$default(ExpCurve expCurve, double d, double d2, double d3, double d4, double d5, int n, Object object) {
        if ((n & 1) != 0) {
            d = expCurve.a;
        }
        if ((n & 2) != 0) {
            d2 = expCurve.b;
        }
        if ((n & 4) != 0) {
            d3 = expCurve.c;
        }
        if ((n & 8) != 0) {
            d4 = expCurve.d;
        }
        if ((n & 0x10) != 0) {
            d5 = expCurve.offset;
        }
        return expCurve.copy(d, d2, d3, d4, d5);
    }

    @NotNull
    public String toString() {
        return "ExpCurve(a=" + this.a + ", b=" + this.b + ", c=" + this.c + ", d=" + this.d + ", offset=" + this.offset + ")";
    }

    public int hashCode() {
        int result = Double.hashCode(this.a);
        result = result * 31 + Double.hashCode(this.b);
        result = result * 31 + Double.hashCode(this.c);
        result = result * 31 + Double.hashCode(this.d);
        result = result * 31 + Double.hashCode(this.offset);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExpCurve)) {
            return false;
        }
        ExpCurve expCurve = (ExpCurve)other;
        if (Double.compare(this.a, expCurve.a) != 0) {
            return false;
        }
        if (Double.compare(this.b, expCurve.b) != 0) {
            return false;
        }
        if (Double.compare(this.c, expCurve.c) != 0) {
            return false;
        }
        if (Double.compare(this.d, expCurve.d) != 0) {
            return false;
        }
        return Double.compare(this.offset, expCurve.offset) == 0;
    }
}

