/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.SineOscillator;
import com.jsyn.unitgen.UnitFilter;

public class WaveFolder
extends UnitFilter {
    public UnitInputPort amount = new UnitInputPort("Amount");
    private static final double MAX_SCALE = 8.0;

    public WaveFolder() {
        this.addPort(this.amount);
        this.amount.setup(0.0, 0.0, 8.0);
    }

    @Override
    public void generate(int start, int limit) {
        double[] inputs = this.input.getValues();
        double[] scales = this.amount.getValues();
        double[] outputs = this.output.getValues();
        for (int i = start; i < limit; ++i) {
            double inputValue = inputs[i];
            double scaleValue = scales[i];
            scaleValue = Math.max(scaleValue, 1.0E-5);
            double phase = inputValue * scaleValue;
            phase = (phase + 256.0 + 1.0) * 0.5;
            phase -= Math.floor(phase);
            phase = phase * 2.0 - 1.0;
            double folded = SineOscillator.fastSin(phase);
            if (scaleValue < 1.0) {
                folded /= scaleValue * (-2.141592653589793 * scaleValue + Math.PI);
            }
            outputs[i] = folded;
        }
    }
}

