/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.devices.javasound;

import com.jsyn.devices.AudioDeviceInputStream;
import com.jsyn.devices.AudioDeviceManager;
import com.jsyn.devices.AudioDeviceOutputStream;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;

public class JavaSoundAudioDevice
implements AudioDeviceManager {
    private static final int BYTES_PER_SAMPLE = 2;
    private static final boolean USE_BIG_ENDIAN = false;
    ArrayList<DeviceInfo> deviceRecords;
    private double suggestedOutputLatency = 0.04;
    private double suggestedInputLatency = 0.1;
    private int defaultInputDeviceID = -1;
    private int defaultOutputDeviceID = -1;

    public JavaSoundAudioDevice() {
        String osName = System.getProperty("os.name");
        if (osName.contains("Windows")) {
            this.suggestedOutputLatency = 0.08;
        }
        this.deviceRecords = new ArrayList();
        this.sniffAvailableMixers();
    }

    private void dumpAvailableMixers() {
        for (DeviceInfo deviceInfo : this.deviceRecords) {
            System.out.println("" + deviceInfo);
        }
    }

    private void sniffAvailableMixers() {
        Mixer.Info[] mixers = AudioSystem.getMixerInfo();
        for (int i = 0; i < mixers.length; ++i) {
            DeviceInfo deviceInfo = new DeviceInfo();
            deviceInfo.name = mixers[i].getName();
            Mixer mixer = AudioSystem.getMixer(mixers[i]);
            Line.Info[] lines = mixer.getTargetLineInfo();
            deviceInfo.maxInputs = this.scanMaxChannels(lines);
            if (this.defaultInputDeviceID < 0 && deviceInfo.maxInputs > 0) {
                this.defaultInputDeviceID = i;
            }
            lines = mixer.getSourceLineInfo();
            deviceInfo.maxOutputs = this.scanMaxChannels(lines);
            if (this.defaultOutputDeviceID < 0 && deviceInfo.maxOutputs > 0) {
                this.defaultOutputDeviceID = i;
            }
            this.deviceRecords.add(deviceInfo);
        }
    }

    private int scanMaxChannels(Line.Info[] lines) {
        int maxChannels = 0;
        for (Line.Info line : lines) {
            int numChannels;
            if (!(line instanceof DataLine.Info) || (numChannels = this.scanMaxChannels((DataLine.Info)line)) <= maxChannels) continue;
            maxChannels = numChannels;
        }
        return maxChannels;
    }

    private int scanMaxChannels(DataLine.Info info) {
        int maxChannels = 0;
        for (AudioFormat format : info.getFormats()) {
            int numChannels = format.getChannels();
            if (numChannels <= maxChannels) continue;
            maxChannels = numChannels;
        }
        return maxChannels;
    }

    @Override
    public AudioDeviceOutputStream createOutputStream(int deviceID, int frameRate, int samplesPerFrame) {
        return new JavaSoundOutputStream(deviceID, frameRate, samplesPerFrame);
    }

    @Override
    public AudioDeviceInputStream createInputStream(int deviceID, int frameRate, int samplesPerFrame) {
        return new JavaSoundInputStream(deviceID, frameRate, samplesPerFrame);
    }

    @Override
    public double getDefaultHighInputLatency(int deviceID) {
        return 0.3;
    }

    @Override
    public double getDefaultHighOutputLatency(int deviceID) {
        return 0.3;
    }

    @Override
    public int getDefaultInputDeviceID() {
        return this.defaultInputDeviceID;
    }

    @Override
    public int getDefaultOutputDeviceID() {
        return this.defaultOutputDeviceID;
    }

    @Override
    public double getDefaultLowInputLatency(int deviceID) {
        return 0.1;
    }

    @Override
    public double getDefaultLowOutputLatency(int deviceID) {
        return 0.1;
    }

    @Override
    public int getDeviceCount() {
        return this.deviceRecords.size();
    }

    @Override
    public String getDeviceName(int deviceID) {
        return this.deviceRecords.get((int)deviceID).name;
    }

    @Override
    public int getMaxInputChannels(int deviceID) {
        return this.deviceRecords.get((int)deviceID).maxInputs;
    }

    @Override
    public int getMaxOutputChannels(int deviceID) {
        return this.deviceRecords.get((int)deviceID).maxOutputs;
    }

    @Override
    public int setSuggestedOutputLatency(double latency) {
        this.suggestedOutputLatency = latency;
        return 0;
    }

    @Override
    public int setSuggestedInputLatency(double latency) {
        this.suggestedInputLatency = latency;
        return 0;
    }

    @Override
    public String getName() {
        return "JavaSound";
    }

    private class JavaSoundInputStream
    extends JavaSoundStream
    implements AudioDeviceInputStream {
        TargetDataLine line;

        public JavaSoundInputStream(int deviceID, int frameRate, int samplesPerFrame) {
            super(deviceID, frameRate, samplesPerFrame);
        }

        @Override
        public void start() {
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, this.format);
            if (AudioSystem.isLineSupported(info)) {
                try {
                    this.line = (TargetDataLine)this.getDataLine(info);
                    int bufferSize = this.calculateBufferSize(JavaSoundAudioDevice.this.suggestedInputLatency);
                    this.line.open(this.format, bufferSize);
                    this.line.start();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.line = null;
                }
            }
        }

        @Override
        public double read() {
            double[] buffer = new double[1];
            this.read(buffer, 0, 1);
            return buffer[0];
        }

        @Override
        public int read(double[] buffer) {
            return this.read(buffer, 0, buffer.length);
        }

        @Override
        public int read(double[] buffer, int start, int count) {
            if (this.bytes == null || this.bytes.length * 2 < count) {
                this.bytes = new byte[count * 2];
            }
            int bytesRead = this.line.read(this.bytes, 0, this.bytes.length);
            int bi = 0;
            for (int i = 0; i < count; ++i) {
                int sample = this.bytes[bi++] & 0xFF;
                buffer[i + start] = (double)(sample += this.bytes[bi++] << 8) * 3.051850947599719E-5;
            }
            return bytesRead / 4;
        }

        @Override
        public void stop() {
            if (this.line != null) {
                this.line.drain();
                this.line.close();
            } else {
                new RuntimeException("AudioInput stop attempted when no line created.").printStackTrace();
            }
        }

        @Override
        public double getLatency() {
            if (this.line == null) {
                return 0.0;
            }
            int numBytes = this.line.getBufferSize();
            int numFrames = numBytes / (2 * this.samplesPerFrame);
            return (double)numFrames / (double)this.frameRate;
        }

        @Override
        public int available() {
            return this.line.available() / 2;
        }

        @Override
        public void close() {
        }
    }

    private class JavaSoundOutputStream
    extends JavaSoundStream
    implements AudioDeviceOutputStream {
        SourceDataLine line;

        public JavaSoundOutputStream(int deviceID, int frameRate, int samplesPerFrame) {
            super(deviceID, frameRate, samplesPerFrame);
        }

        @Override
        public void start() {
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.format);
            if (AudioSystem.isLineSupported(info)) {
                try {
                    this.line = (SourceDataLine)this.getDataLine(info);
                    int bufferSize = this.calculateBufferSize(JavaSoundAudioDevice.this.suggestedOutputLatency);
                    this.line.open(this.format, bufferSize);
                    this.line.start();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.line = null;
                }
            }
        }

        @Override
        public void write(double value) {
            double[] buffer = new double[]{value};
            this.write(buffer, 0, 1);
        }

        @Override
        public void write(double[] buffer) {
            this.write(buffer, 0, buffer.length);
        }

        @Override
        public void write(double[] buffer, int start, int count) {
            if (this.bytes == null || this.bytes.length * 2 < count) {
                this.bytes = new byte[count * 2];
            }
            int byteIndex = 0;
            for (int i = 0; i < count; ++i) {
                double temp = 32767.0 * buffer[i + start] + 32768.5;
                int sample = (int)temp - 32768;
                if (sample > Short.MAX_VALUE) {
                    sample = Short.MAX_VALUE;
                } else if (sample < Short.MIN_VALUE) {
                    sample = Short.MIN_VALUE;
                }
                this.bytes[byteIndex++] = (byte)sample;
                this.bytes[byteIndex++] = (byte)(sample >> 8);
            }
            this.line.write(this.bytes, 0, byteIndex);
        }

        @Override
        public void stop() {
            if (this.line != null) {
                this.line.stop();
                this.line.flush();
                this.line.close();
                this.line = null;
            } else {
                new RuntimeException("AudioOutput stop attempted when no line created.").printStackTrace();
            }
        }

        @Override
        public double getLatency() {
            if (this.line == null) {
                return 0.0;
            }
            int numBytes = this.line.getBufferSize();
            int numFrames = numBytes / (2 * this.samplesPerFrame);
            return (double)numFrames / (double)this.frameRate;
        }

        @Override
        public void close() {
        }
    }

    private static class JavaSoundStream {
        AudioFormat format;
        byte[] bytes;
        int frameRate;
        int deviceID;
        int samplesPerFrame;

        public JavaSoundStream(int deviceID, int frameRate, int samplesPerFrame) {
            this.deviceID = deviceID;
            this.frameRate = frameRate;
            this.samplesPerFrame = samplesPerFrame;
            this.format = new AudioFormat(frameRate, 16, samplesPerFrame, true, false);
        }

        Line getDataLine(DataLine.Info info) throws LineUnavailableException {
            Line dataLine;
            if (this.deviceID >= 0) {
                Mixer.Info[] mixers = AudioSystem.getMixerInfo();
                Mixer mixer = AudioSystem.getMixer(mixers[this.deviceID]);
                dataLine = mixer.getLine(info);
            } else {
                dataLine = AudioSystem.getLine(info);
            }
            return dataLine;
        }

        int calculateBufferSize(double suggestedOutputLatency) {
            int numFrames = (int)(suggestedOutputLatency * (double)this.frameRate);
            return numFrames * this.samplesPerFrame * 2;
        }
    }

    static class DeviceInfo {
        String name;
        int maxInputs;
        int maxOutputs;

        DeviceInfo() {
        }

        public String toString() {
            return "AudioDevice: " + this.name + ", max in = " + this.maxInputs + ", max out = " + this.maxOutputs;
        }
    }
}

