/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.app.shared.data;

import androidx.compose.material.icons.Icons;
import androidx.compose.material.icons.filled.BluetoothKt;
import androidx.compose.material.icons.filled.UsbKt;
import androidx.compose.material.icons.filled.WifiKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.vector.ImageVector;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.app.shared.data.DeviceInterfaceSamplingFrequency;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u0003\u0013\u0014\u0015B!\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u0082\u0001\u0003\u0016\u0017\u0018\u00a8\u0006\u0019"}, d2={"Lvet/inpulse/app/shared/data/DeviceInterface;", "", "displayText", "", "icon", "Landroidx/compose/ui/graphics/vector/ImageVector;", "maxSamplingFrequency", "Lvet/inpulse/app/shared/data/DeviceInterfaceSamplingFrequency;", "<init>", "(Ljava/lang/String;Landroidx/compose/ui/graphics/vector/ImageVector;Lvet/inpulse/app/shared/data/DeviceInterfaceSamplingFrequency;)V", "getDisplayText", "()Ljava/lang/String;", "getIcon", "()Landroidx/compose/ui/graphics/vector/ImageVector;", "getMaxSamplingFrequency", "()Lvet/inpulse/app/shared/data/DeviceInterfaceSamplingFrequency;", "samplingFrequencyIsAllowed", "", "samplingFrequency", "Bluetooth", "Usb", "Wifi", "Lvet/inpulse/app/shared/data/DeviceInterface$Bluetooth;", "Lvet/inpulse/app/shared/data/DeviceInterface$Usb;", "Lvet/inpulse/app/shared/data/DeviceInterface$Wifi;", "shared"})
@StabilityInferred(parameters=1)
public abstract sealed class DeviceInterface {
    @NotNull
    private final String displayText;
    @NotNull
    private final ImageVector icon;
    @NotNull
    private final DeviceInterfaceSamplingFrequency maxSamplingFrequency;
    public static final int $stable;

    private DeviceInterface(String displayText, ImageVector icon, DeviceInterfaceSamplingFrequency maxSamplingFrequency) {
        this.displayText = displayText;
        this.icon = icon;
        this.maxSamplingFrequency = maxSamplingFrequency;
    }

    @NotNull
    public final String getDisplayText() {
        return this.displayText;
    }

    @NotNull
    public final ImageVector getIcon() {
        return this.icon;
    }

    @NotNull
    public final DeviceInterfaceSamplingFrequency getMaxSamplingFrequency() {
        return this.maxSamplingFrequency;
    }

    public final boolean samplingFrequencyIsAllowed(@NotNull DeviceInterfaceSamplingFrequency samplingFrequency) {
        Intrinsics.checkNotNullParameter((Object)((Object)samplingFrequency), (String)"samplingFrequency");
        return samplingFrequency.ordinal() <= this.maxSamplingFrequency.ordinal();
    }

    public /* synthetic */ DeviceInterface(String displayText, ImageVector icon, DeviceInterfaceSamplingFrequency maxSamplingFrequency, DefaultConstructorMarker $constructor_marker) {
        this(displayText, icon, maxSamplingFrequency);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c7\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lvet/inpulse/app/shared/data/DeviceInterface$Bluetooth;", "Lvet/inpulse/app/shared/data/DeviceInterface;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "shared"})
    @StabilityInferred(parameters=1)
    public static final class Bluetooth
    extends DeviceInterface {
        @NotNull
        public static final Bluetooth INSTANCE = new Bluetooth();
        public static final int $stable;

        private Bluetooth() {
            super("Bluetooth", BluetoothKt.getBluetooth((Icons.Filled)Icons.Filled.INSTANCE), DeviceInterfaceSamplingFrequency.HZ_1000, null);
        }

        @NotNull
        public String toString() {
            return "Bluetooth";
        }

        public int hashCode() {
            return 413244216;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Bluetooth)) {
                return false;
            }
            Bluetooth cfr_ignored_0 = (Bluetooth)other;
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c7\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lvet/inpulse/app/shared/data/DeviceInterface$Usb;", "Lvet/inpulse/app/shared/data/DeviceInterface;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "shared"})
    @StabilityInferred(parameters=1)
    public static final class Usb
    extends DeviceInterface {
        @NotNull
        public static final Usb INSTANCE = new Usb();
        public static final int $stable;

        private Usb() {
            super("USB", UsbKt.getUsb((Icons.Filled)Icons.Filled.INSTANCE), DeviceInterfaceSamplingFrequency.HZ_2000, null);
        }

        @NotNull
        public String toString() {
            return "Usb";
        }

        public int hashCode() {
            return -179286642;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Usb)) {
                return false;
            }
            Usb cfr_ignored_0 = (Usb)other;
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c7\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lvet/inpulse/app/shared/data/DeviceInterface$Wifi;", "Lvet/inpulse/app/shared/data/DeviceInterface;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "shared"})
    @StabilityInferred(parameters=1)
    public static final class Wifi
    extends DeviceInterface {
        @NotNull
        public static final Wifi INSTANCE = new Wifi();
        public static final int $stable;

        private Wifi() {
            super("Wi-Fi", WifiKt.getWifi((Icons.Filled)Icons.Filled.INSTANCE), DeviceInterfaceSamplingFrequency.HZ_4000, null);
        }

        @NotNull
        public String toString() {
            return "Wifi";
        }

        public int hashCode() {
            return -1262868405;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Wifi)) {
                return false;
            }
            Wifi cfr_ignored_0 = (Wifi)other;
            return true;
        }
    }
}

