/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.app.shared.auth;

import androidx.datastore.core.DataStore;
import androidx.datastore.core.DataStoreFactory;
import androidx.datastore.core.Storage;
import androidx.datastore.core.handlers.ReplaceFileCorruptionHandler;
import androidx.datastore.core.okio.OkioSerializer;
import androidx.datastore.core.okio.OkioStorage;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.app.shared.auth.AccessOption;
import vet.inpulse.app.shared.preferences.subTypes.UserSelectedAccessFromPreferences;
import vet.inpulse.app.shared.utils.OkioExtrasKt;
import vet.inpulse.core.models.cloud.auth.Authentication;
import vet.inpulse.core.models.cloud.auth.OrganizationMetadata;
import vet.inpulse.core.models.cloud.auth.TelemedicineCenterMetadata;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a6\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u001a\n\u0010\f\u001a\u00020\r*\u00020\u000e\u001a\n\u0010\f\u001a\u00020\r*\u00020\u000f\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\r\u00a8\u0006\u0012"}, d2={"authenticationDataStore", "Landroidx/datastore/core/DataStore;", "Lvet/inpulse/core/models/cloud/auth/Authentication;", "json", "Lkotlinx/serialization/json/Json;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "fileSystem", "Lokio/FileSystem;", "producePath", "Lkotlin/Function0;", "Lokio/Path;", "toAccessOption", "Lvet/inpulse/app/shared/auth/AccessOption;", "Lvet/inpulse/core/models/cloud/auth/OrganizationMetadata;", "Lvet/inpulse/core/models/cloud/auth/TelemedicineCenterMetadata;", "toUserSelectedAccessFromPreferences", "Lvet/inpulse/app/shared/preferences/subTypes/UserSelectedAccessFromPreferences;", "shared"})
@SourceDebugExtension(value={"SMAP\nAuthentication.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Authentication.kt\nvet/inpulse/app/shared/auth/AuthenticationKt\n+ 2 DataStoreUtils.kt\nvet/inpulse/app/shared/utils/DataStoreUtilsKt\n*L\n1#1,257:1\n20#2,10:258\n50#2,13:268\n*S KotlinDebug\n*F\n+ 1 Authentication.kt\nvet/inpulse/app/shared/auth/AuthenticationKt\n*L\n235#1:258,10\n235#1:268,13\n*E\n"})
public final class AuthenticationKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DataStore<Authentication> authenticationDataStore(@NotNull Json json, @NotNull CoroutineScope scope, @NotNull FileSystem fileSystem, @NotNull Function0<Path> producePath) {
        void scope$iv;
        void producePath$iv;
        void fileSystem$iv;
        void json$iv;
        void defaultValue$iv;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter(producePath, (String)"producePath");
        Authentication.Anonymous anonymous = Authentication.Anonymous.INSTANCE;
        Json json2 = json;
        CoroutineScope coroutineScope = scope;
        FileSystem fileSystem2 = fileSystem;
        Function0<Path> function0 = producePath;
        ReplaceFileCorruptionHandler corruptionHandler$iv = null;
        List migrations$iv = CollectionsKt.emptyList();
        boolean $i$f$kotlinxSerializationDataStore = false;
        OkioSerializer<Authentication> serializer$iv = new OkioSerializer<Authentication>((Object)defaultValue$iv, (Json)json$iv){
            private final Authentication defaultValue;
            final /* synthetic */ Object $defaultValue;
            final /* synthetic */ Json $json;
            {
                this.$defaultValue = $defaultValue;
                this.$json = $json;
                this.defaultValue = $defaultValue;
            }

            public Authentication getDefaultValue() {
                return this.defaultValue;
            }

            /*
             * WARNING - void declaration
             */
            public Object readFrom(BufferedSource source, Continuation<? super Authentication> $completion) {
                Object object;
                String s = source.readUtf8();
                if (StringsKt.isBlank((CharSequence)s)) {
                    return this.$defaultValue;
                }
                try {
                    void this_$iv;
                    object = this.$json;
                    String string$iv = s;
                    boolean $i$f$decodeFromString = false;
                    this_$iv.getSerializersModule();
                    object = this_$iv.decodeFromString((DeserializationStrategy)Authentication.Companion.serializer(), string$iv);
                }
                catch (Exception exception) {
                    object = this.$defaultValue;
                }
                return object;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public Object writeTo(Object t, BufferedSink sink, Continuation $completion) {
                void this_$iv;
                Json json = this.$json;
                Object value$iv = t;
                boolean $i$f$encodeToString = false;
                this_$iv.getSerializersModule();
                String s = this_$iv.encodeToString((SerializationStrategy)Authentication.Companion.serializer(), value$iv);
                sink.writeUtf8(s);
                return Unit.INSTANCE;
            }
        };
        OkioStorage storage$iv = new OkioStorage((FileSystem)fileSystem$iv, (OkioSerializer)serializer$iv, null, (Function0)new Function0<Path>((Function0<Path>)producePath$iv, (FileSystem)fileSystem$iv){
            final /* synthetic */ Function0<Path> $producePath;
            final /* synthetic */ FileSystem $fileSystem;
            {
                this.$producePath = $producePath;
                this.$fileSystem = $fileSystem;
            }

            public final Path invoke() {
                Path path = OkioExtrasKt.absolute((Path)this.$producePath.invoke(), this.$fileSystem);
                return path;
            }
        }, 4, null);
        return DataStoreFactory.INSTANCE.create((Storage)storage$iv, corruptionHandler$iv, migrations$iv, (CoroutineScope)scope$iv);
    }

    public static /* synthetic */ DataStore authenticationDataStore$default(Json json, CoroutineScope coroutineScope, FileSystem fileSystem, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            json = (Json)Json.Default;
        }
        if ((n & 2) != 0) {
            coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
        }
        return AuthenticationKt.authenticationDataStore(json, coroutineScope, fileSystem, (Function0<Path>)function0);
    }

    @NotNull
    public static final AccessOption toAccessOption(@NotNull OrganizationMetadata $this$toAccessOption) {
        Intrinsics.checkNotNullParameter((Object)$this$toAccessOption, (String)"<this>");
        return new AccessOption.Organization($this$toAccessOption.getId(), $this$toAccessOption.getName());
    }

    @NotNull
    public static final AccessOption toAccessOption(@NotNull TelemedicineCenterMetadata $this$toAccessOption) {
        Intrinsics.checkNotNullParameter((Object)$this$toAccessOption, (String)"<this>");
        return AccessOption.TelemedicineCenter.INSTANCE;
    }

    @Nullable
    public static final UserSelectedAccessFromPreferences toUserSelectedAccessFromPreferences(@NotNull AccessOption $this$toUserSelectedAccessFromPreferences) {
        UserSelectedAccessFromPreferences userSelectedAccessFromPreferences;
        Intrinsics.checkNotNullParameter((Object)$this$toUserSelectedAccessFromPreferences, (String)"<this>");
        AccessOption accessOption = $this$toUserSelectedAccessFromPreferences;
        if (accessOption instanceof AccessOption.Organization) {
            userSelectedAccessFromPreferences = new UserSelectedAccessFromPreferences.Organization(((AccessOption.Organization)$this$toUserSelectedAccessFromPreferences).getId());
        } else if (Intrinsics.areEqual((Object)accessOption, (Object)AccessOption.TelemedicineCenter.INSTANCE)) {
            userSelectedAccessFromPreferences = UserSelectedAccessFromPreferences.TelemedicineCenter.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return userSelectedAccessFromPreferences;
    }
}

