/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.app.shared.analysis.ecg.data;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.core.models.model.WaveformMetadata;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\b\u0018\u0000 ,2\u00020\u0001:\u0001,BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u001b\u001a\u00020\u001cJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010#\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0017JV\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00c6\u0001\u00a2\u0006\u0002\u0010%J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010)\u001a\u00020\u0003H\u00d6\u0001J\t\u0010*\u001a\u00020+H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0015\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0019\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000f\u00a8\u0006-"}, d2={"Lvet/inpulse/app/shared/analysis/ecg/data/AnalysisWaveformMetadata;", "", "waveformIndex", "", "samplingFrequency", "", "waveformSize", "absoluteStartIndex", "downSamplingFactor", "downSampledStartIndex", "startTime", "", "<init>", "(IFIIIILjava/lang/Long;)V", "getWaveformIndex", "()I", "getSamplingFrequency", "()F", "getWaveformSize", "getAbsoluteStartIndex", "getDownSamplingFactor", "getDownSampledStartIndex", "getStartTime", "()Ljava/lang/Long;", "Ljava/lang/Long;", "downSampledSize", "getDownSampledSize", "toWaveformMetadata", "Lvet/inpulse/core/models/model/WaveformMetadata;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "(IFIIIILjava/lang/Long;)Lvet/inpulse/app/shared/analysis/ecg/data/AnalysisWaveformMetadata;", "equals", "", "other", "hashCode", "toString", "", "Companion", "shared"})
@StabilityInferred(parameters=1)
public final class AnalysisWaveformMetadata {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int waveformIndex;
    private final float samplingFrequency;
    private final int waveformSize;
    private final int absoluteStartIndex;
    private final int downSamplingFactor;
    private final int downSampledStartIndex;
    @Nullable
    private final Long startTime;
    private final int downSampledSize;
    public static final int $stable;

    public AnalysisWaveformMetadata(int waveformIndex, float samplingFrequency, int waveformSize, int absoluteStartIndex, int downSamplingFactor, int downSampledStartIndex, @Nullable Long startTime) {
        this.waveformIndex = waveformIndex;
        this.samplingFrequency = samplingFrequency;
        this.waveformSize = waveformSize;
        this.absoluteStartIndex = absoluteStartIndex;
        this.downSamplingFactor = downSamplingFactor;
        this.downSampledStartIndex = downSampledStartIndex;
        this.startTime = startTime;
        this.downSampledSize = this.waveformSize / this.downSamplingFactor;
    }

    public final int getWaveformIndex() {
        return this.waveformIndex;
    }

    public final float getSamplingFrequency() {
        return this.samplingFrequency;
    }

    public final int getWaveformSize() {
        return this.waveformSize;
    }

    public final int getAbsoluteStartIndex() {
        return this.absoluteStartIndex;
    }

    public final int getDownSamplingFactor() {
        return this.downSamplingFactor;
    }

    public final int getDownSampledStartIndex() {
        return this.downSampledStartIndex;
    }

    @Nullable
    public final Long getStartTime() {
        return this.startTime;
    }

    public final int getDownSampledSize() {
        return this.downSampledSize;
    }

    @NotNull
    public final WaveformMetadata toWaveformMetadata() {
        return (WaveformMetadata)new WaveformMetadata.V1(this.waveformSize, this.samplingFrequency, this.startTime);
    }

    public final int component1() {
        return this.waveformIndex;
    }

    public final float component2() {
        return this.samplingFrequency;
    }

    public final int component3() {
        return this.waveformSize;
    }

    public final int component4() {
        return this.absoluteStartIndex;
    }

    public final int component5() {
        return this.downSamplingFactor;
    }

    public final int component6() {
        return this.downSampledStartIndex;
    }

    @Nullable
    public final Long component7() {
        return this.startTime;
    }

    @NotNull
    public final AnalysisWaveformMetadata copy(int waveformIndex, float samplingFrequency, int waveformSize, int absoluteStartIndex, int downSamplingFactor, int downSampledStartIndex, @Nullable Long startTime) {
        return new AnalysisWaveformMetadata(waveformIndex, samplingFrequency, waveformSize, absoluteStartIndex, downSamplingFactor, downSampledStartIndex, startTime);
    }

    public static /* synthetic */ AnalysisWaveformMetadata copy$default(AnalysisWaveformMetadata analysisWaveformMetadata, int n, float f, int n2, int n3, int n4, int n5, Long l, int n6, Object object) {
        if ((n6 & 1) != 0) {
            n = analysisWaveformMetadata.waveformIndex;
        }
        if ((n6 & 2) != 0) {
            f = analysisWaveformMetadata.samplingFrequency;
        }
        if ((n6 & 4) != 0) {
            n2 = analysisWaveformMetadata.waveformSize;
        }
        if ((n6 & 8) != 0) {
            n3 = analysisWaveformMetadata.absoluteStartIndex;
        }
        if ((n6 & 0x10) != 0) {
            n4 = analysisWaveformMetadata.downSamplingFactor;
        }
        if ((n6 & 0x20) != 0) {
            n5 = analysisWaveformMetadata.downSampledStartIndex;
        }
        if ((n6 & 0x40) != 0) {
            l = analysisWaveformMetadata.startTime;
        }
        return analysisWaveformMetadata.copy(n, f, n2, n3, n4, n5, l);
    }

    @NotNull
    public String toString() {
        return "AnalysisWaveformMetadata(waveformIndex=" + this.waveformIndex + ", samplingFrequency=" + this.samplingFrequency + ", waveformSize=" + this.waveformSize + ", absoluteStartIndex=" + this.absoluteStartIndex + ", downSamplingFactor=" + this.downSamplingFactor + ", downSampledStartIndex=" + this.downSampledStartIndex + ", startTime=" + this.startTime + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.waveformIndex);
        result = result * 31 + Float.hashCode(this.samplingFrequency);
        result = result * 31 + Integer.hashCode(this.waveformSize);
        result = result * 31 + Integer.hashCode(this.absoluteStartIndex);
        result = result * 31 + Integer.hashCode(this.downSamplingFactor);
        result = result * 31 + Integer.hashCode(this.downSampledStartIndex);
        result = result * 31 + (this.startTime == null ? 0 : ((Object)this.startTime).hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnalysisWaveformMetadata)) {
            return false;
        }
        AnalysisWaveformMetadata analysisWaveformMetadata = (AnalysisWaveformMetadata)other;
        if (this.waveformIndex != analysisWaveformMetadata.waveformIndex) {
            return false;
        }
        if (Float.compare(this.samplingFrequency, analysisWaveformMetadata.samplingFrequency) != 0) {
            return false;
        }
        if (this.waveformSize != analysisWaveformMetadata.waveformSize) {
            return false;
        }
        if (this.absoluteStartIndex != analysisWaveformMetadata.absoluteStartIndex) {
            return false;
        }
        if (this.downSamplingFactor != analysisWaveformMetadata.downSamplingFactor) {
            return false;
        }
        if (this.downSampledStartIndex != analysisWaveformMetadata.downSampledStartIndex) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.startTime, (Object)analysisWaveformMetadata.startTime);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t\u00a8\u0006\u000e"}, d2={"Lvet/inpulse/app/shared/analysis/ecg/data/AnalysisWaveformMetadata$Companion;", "", "<init>", "()V", "fromWaveformMetadata", "Lvet/inpulse/app/shared/analysis/ecg/data/AnalysisWaveformMetadata;", "waveformMetadata", "Lvet/inpulse/core/models/model/WaveformMetadata;", "waveformIndex", "", "chartsSamplingFrequency", "", "absoluteStartIndex", "downSampledStartIndex", "shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AnalysisWaveformMetadata fromWaveformMetadata(@NotNull WaveformMetadata waveformMetadata, int waveformIndex, float chartsSamplingFrequency, int absoluteStartIndex, int downSampledStartIndex) {
            Intrinsics.checkNotNullParameter((Object)waveformMetadata, (String)"waveformMetadata");
            if (!(waveformMetadata instanceof WaveformMetadata.V1)) {
                throw new NoWhenBranchMatchedException();
            }
            int downSamplingFactor = MathKt.roundToInt((float)(((WaveformMetadata.V1)waveformMetadata).getSamplingFrequency() / chartsSamplingFrequency));
            return new AnalysisWaveformMetadata(waveformIndex, ((WaveformMetadata.V1)waveformMetadata).getSamplingFrequency(), ((WaveformMetadata.V1)waveformMetadata).getNumSamples(), absoluteStartIndex, downSamplingFactor, downSampledStartIndex, ((WaveformMetadata.V1)waveformMetadata).getStartTime());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

