/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexzhirkevich.keight.js.interpreter;

import io.github.alexzhirkevich.keight.js.SyntaxError;
import io.github.alexzhirkevich.keight.js.interpreter.NumberFormat;
import io.github.alexzhirkevich.keight.js.interpreter.TemplateStringToken;
import io.github.alexzhirkevich.keight.js.interpreter.Token;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.CharRange;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0082\u0001\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010*\n\u0002\u0010\f\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0000\u001a*\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0012\u0010\t\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\u0012\u0010\n\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\u0012\u0010\u000b\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\u0012\u0010\f\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\u0012\u0010\r\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\u0012\u0010\u000e\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\u0012\u0010\u000f\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\u0012\u0010\u0011\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\u0012\u0010\u0012\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\u0012\u0010\u0013\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\u001c\u0010\u0014\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u0002H\u0002\u001a\u0012\u0010\u0016\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\u0012\u0010\u0017\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\u0012\u0010\u0018\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\u0012\u0010\u0019\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\u0012\u0010\u001a\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\u0012\u0010\u001b\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\u0012\u0010\u001c\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\u0012\u0010\u001d\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\u0012\u0010\u001e\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\u0012\u0010\u001f\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\u0012\u0010 \u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\u0012\u0010!\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\u0012\u0010\"\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\u0012\u0010#\u001a\u00020$*\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\u0017\u0010'\u001a\u00020(*\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0002\u0010)\u001a\u001a\u0010*\u001a\u00020$*\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010+\u001a\u00020\u0005H\u0002\u001a\u001f\u0010,\u001a\u00020-*\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010.\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\u0010/\u001a\f\u00103\u001a\u000204*\u00020\u0003H\u0002\u001a\f\u00105\u001a\u00020\u0003*\u00020\u0003H\u0002\u001a\f\u00106\u001a\u00020\u0003*\u00020\u0003H\u0000\u001a\u001a\u00107\u001a\u000208*\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010.\u001a\u00020\u0007H\u0000\u001a\u001a\u0010D\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010.\u001a\u00020\u0007H\u0002\u001a\u001f\u0010E\u001a\u00020F*\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010G\"\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00070&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u00102\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"'\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020;0:8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b>\u0010?\u001a\u0004\b<\u0010=\"'\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020A0:8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bC\u0010?\u001a\u0004\bB\u0010=\"\u001e\u0010H\u001a\u0012\u0012\u0004\u0012\u00020\u00070Ij\b\u0012\u0004\u0012\u00020\u0007`JX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"$\u0010K\u001a\u0012\u0012\u0004\u0012\u0002040Ij\b\u0012\u0004\u0012\u000204`JX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010M\"\u001e\u0010N\u001a\u0012\u0012\u0004\u0012\u00020\u00070Ij\b\u0012\u0004\u0012\u00020\u0007`JX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001e\u0010P\u001a\u0012\u0012\u0004\u0012\u00020\u00070Ij\b\u0012\u0004\u0012\u00020\u0007`JX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001e\u0010Q\u001a\u0012\u0012\u0004\u0012\u00020\u00070Ij\b\u0012\u0004\u0012\u00020\u0007`JX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"tokenize", "", "Lio/github/alexzhirkevich/keight/js/interpreter/Token;", "", "ignoreWhitespaces", "", "", "", "untilEndOfBlock", "questionMark", "nullishCoalescing", "period", "doublePeriod", "assign", "eq", "plus", "Lio/github/alexzhirkevich/keight/js/interpreter/Token$Operator;", "minus", "mul", "exp", "div", "prev", "mod", "and", "andLogical", "or", "orLogical", "xor", "less", "greater", "shl", "shr", "ushr", "not", "neq", "hashbangComment", "Lio/github/alexzhirkevich/keight/js/interpreter/Token$Comment;", "REGEX_FLAGS", "", "regex", "Lio/github/alexzhirkevich/keight/js/interpreter/Token$Regex;", "(Ljava/util/ListIterator;)Ljava/lang/String;", "comment", "isSingleLine", "string", "Lio/github/alexzhirkevich/keight/js/interpreter/Token$Str;", "start", "(Ljava/util/ListIterator;C)Ljava/lang/String;", "UNICODE_REGEX", "Lkotlin/text/Regex;", "UNICODE_REGEX_SURROGATE", "toUnicodePoint", "", "unescape", "escape", "number", "Lio/github/alexzhirkevich/keight/js/interpreter/Token$Num;", "keywords", "", "Lio/github/alexzhirkevich/keight/js/interpreter/Token$Identifier$Keyword;", "getKeywords", "()Ljava/util/Map;", "keywords$delegate", "Lkotlin/Lazy;", "reserved", "Lio/github/alexzhirkevich/keight/js/interpreter/Token$Identifier$Reserved;", "getReserved", "reserved$delegate", "identifier", "templateString", "Lio/github/alexzhirkevich/keight/js/interpreter/Token$TemplateString;", "(Ljava/util/ListIterator;Z)Ljava/util/List;", "STRING_START", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "LSEP", "getLSEP", "()Ljava/util/HashSet;", "NUMBERS", "NumberFormatIndicators", "IDENTIFIER_ALPHABET", "PROPERTY_ALPHABET_WITH_NUM", "keight"})
@SourceDebugExtension(value={"SMAP\nLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lexer.kt\nio/github/alexzhirkevich/keight/js/interpreter/LexerKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Parser.kt\nio/github/alexzhirkevich/keight/js/interpreter/ParserKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,678:1\n1088#2,2:679\n1#3:681\n1#3:724\n1862#4,5:682\n1862#4,5:687\n1862#4,5:692\n1862#4,5:697\n1208#5,2:702\n1236#5,4:704\n1208#5,2:708\n1236#5,4:710\n1617#5,9:714\n1869#5:723\n1870#5:725\n1626#5:726\n*S KotlinDebug\n*F\n+ 1 Lexer.kt\nio/github/alexzhirkevich/keight/js/interpreter/LexerKt\n*L\n30#1:679,2\n674#1:724\n383#1:682,5\n526#1:687,5\n533#1:692,5\n541#1:697,5\n580#1:702,2\n580#1:704,4\n584#1:708,2\n584#1:710,4\n674#1:714,9\n674#1:723\n674#1:725\n674#1:726\n*E\n"})
public final class LexerKt {
    @NotNull
    private static final Set<Character> REGEX_FLAGS;
    @NotNull
    private static final Regex UNICODE_REGEX;
    @NotNull
    private static final Regex UNICODE_REGEX_SURROGATE;
    @NotNull
    private static final Lazy keywords$delegate;
    @NotNull
    private static final Lazy reserved$delegate;
    @NotNull
    private static final HashSet<Character> STRING_START;
    @NotNull
    private static final HashSet<Integer> LSEP;
    @NotNull
    private static final HashSet<Character> NUMBERS;
    @NotNull
    private static final List<Character> NumberFormatIndicators;
    @NotNull
    private static final HashSet<Character> IDENTIFIER_ALPHABET;
    @NotNull
    private static final HashSet<Character> PROPERTY_ALPHABET_WITH_NUM;

    @NotNull
    public static final List<Token> tokenize(@NotNull String $this$tokenize, boolean ignoreWhitespaces) {
        Intrinsics.checkNotNullParameter((Object)$this$tokenize, (String)"<this>");
        return LexerKt.tokenize(StringsKt.toList((CharSequence)$this$tokenize).listIterator(), false, ignoreWhitespaces);
    }

    public static /* synthetic */ List tokenize$default(String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return LexerKt.tokenize(string, bl);
    }

    private static final List<Token> tokenize(ListIterator<Character> $this$tokenize, boolean untilEndOfBlock, boolean ignoreWhitespaces) {
        List list2;
        block57: {
            List $this$tokenize_u24lambda_u244 = list2 = CollectionsKt.createListBuilder();
            boolean bl = false;
            try {
                int blockStack = 0;
                while ($this$tokenize.hasNext()) {
                    Token token;
                    Collection collection;
                    block59: {
                        Token it;
                        char c;
                        block63: {
                            Token token2;
                            block64: {
                                block65: {
                                    boolean bl2;
                                    block56: {
                                        block62: {
                                            block61: {
                                                block60: {
                                                    block58: {
                                                        collection = $this$tokenize_u24lambda_u244;
                                                        c = $this$tokenize.next().charValue();
                                                        if (c != '=') break block58;
                                                        token = LexerKt.assign($this$tokenize);
                                                        break block59;
                                                    }
                                                    if (c != '+') break block60;
                                                    token = LexerKt.plus($this$tokenize);
                                                    break block59;
                                                }
                                                if (c != '-') break block61;
                                                token = LexerKt.minus($this$tokenize);
                                                break block59;
                                            }
                                            if (c != '*') break block62;
                                            token = LexerKt.mul($this$tokenize);
                                            break block59;
                                        }
                                        if (c != '/') break block63;
                                        it = token2 = LexerKt.div($this$tokenize, (Token)CollectionsKt.lastOrNull((List)$this$tokenize_u24lambda_u244));
                                        boolean bl3 = false;
                                        if (!(it instanceof Token.Comment)) break block64;
                                        if (((Token.Comment)it).isSingleLine()) break block65;
                                        CharSequence $this$any$iv = ((Token.Comment)it).getValue();
                                        boolean $i$f$any = false;
                                        for (int i = 0; i < $this$any$iv.length(); ++i) {
                                            char element$iv;
                                            char it2 = element$iv = $this$any$iv.charAt(i);
                                            boolean bl4 = false;
                                            if (!LSEP.contains(it2)) continue;
                                            bl2 = true;
                                            break block56;
                                        }
                                        bl2 = false;
                                    }
                                    if (!bl2) break block64;
                                }
                                $this$tokenize_u24lambda_u244.add(Token.NewLine.INSTANCE);
                            }
                            token = token2;
                            break block59;
                        }
                        if (c == '#') {
                            token = LexerKt.hashbangComment($this$tokenize);
                        } else if (c == '%') {
                            token = LexerKt.mod($this$tokenize);
                        } else if (c == '&') {
                            token = LexerKt.and($this$tokenize);
                        } else if (c == '|') {
                            token = LexerKt.or($this$tokenize);
                        } else if (c == '^') {
                            token = LexerKt.xor($this$tokenize);
                        } else if (c == '<') {
                            token = LexerKt.less($this$tokenize);
                        } else if (c == '>') {
                            token = LexerKt.greater($this$tokenize);
                        } else if (c == '!') {
                            token = LexerKt.not($this$tokenize);
                        } else if (c == '.') {
                            token = LexerKt.period($this$tokenize);
                        } else if (c == '?') {
                            token = LexerKt.questionMark($this$tokenize);
                        } else if (c == '~') {
                            token = Token.Operator.Bitwise.Reverse.INSTANCE;
                        } else if (c == '{') {
                            Token.Operator.Bracket.CurlyOpen curlyOpen = Token.Operator.Bracket.CurlyOpen.INSTANCE;
                            it = curlyOpen;
                            boolean bl5 = false;
                            ++blockStack;
                            token = curlyOpen;
                        } else if (c == '}') {
                            Token.Operator.Bracket.CurlyClose curlyClose = Token.Operator.Bracket.CurlyClose.INSTANCE;
                            it = curlyClose;
                            boolean bl6 = false;
                            if ((blockStack += -1) < 0 && untilEndOfBlock) break block57;
                            token = curlyClose;
                        } else if (c == '(') {
                            token = Token.Operator.Bracket.RoundOpen.INSTANCE;
                        } else if (c == ')') {
                            token = Token.Operator.Bracket.RoundClose.INSTANCE;
                        } else if (c == '[') {
                            token = Token.Operator.Bracket.SquareOpen.INSTANCE;
                        } else if (c == ']') {
                            token = Token.Operator.Bracket.SquareClose.INSTANCE;
                        } else if (c == ':') {
                            token = Token.Operator.Colon.INSTANCE;
                        } else if (c == ';') {
                            token = Token.Operator.SemiColon.INSTANCE;
                        } else if (c == ',') {
                            token = Token.Operator.Comma.INSTANCE;
                        } else if (c == '\n' || c == '\u2028') {
                            token = Token.NewLine.INSTANCE;
                        } else if (c == '`') {
                            token = Token.TemplateString.box-impl(LexerKt.templateString($this$tokenize, ignoreWhitespaces));
                        } else if (STRING_START.contains(Character.valueOf(c))) {
                            token = Token.Str.box-impl(LexerKt.string($this$tokenize, c));
                        } else if (NUMBERS.contains(Character.valueOf(c))) {
                            token = LexerKt.number($this$tokenize, c);
                        } else {
                            boolean isWhiteSpace = CharsKt.isWhitespace((char)c);
                            if (isWhiteSpace && ignoreWhitespaces) continue;
                            token = isWhiteSpace ? Token.Whitespace.box-impl(Token.Whitespace.constructor-impl(c)) : LexerKt.identifier($this$tokenize, c);
                        }
                    }
                    Token token3 = token;
                    collection.add(token3);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new SyntaxError((Object)"Invalid or unexpected token", null, 2, null);
            }
        }
        return CollectionsKt.build((List)list2);
    }

    static /* synthetic */ List tokenize$default(ListIterator listIterator, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return LexerKt.tokenize(listIterator, bl, bl2);
    }

    private static final Token questionMark(ListIterator<Character> $this$questionMark) {
        Token token;
        if (!$this$questionMark.hasNext()) {
            return Token.Operator.QuestionMark.INSTANCE;
        }
        switch ($this$questionMark.next().charValue()) {
            case '?': {
                token = LexerKt.nullishCoalescing($this$questionMark);
                break;
            }
            case '.': {
                token = Token.Operator.OptionalChaining.INSTANCE;
                break;
            }
            default: {
                Token.Operator.QuestionMark questionMark;
                Token.Operator.QuestionMark it = questionMark = Token.Operator.QuestionMark.INSTANCE;
                boolean bl = false;
                $this$questionMark.previous();
                token = questionMark;
            }
        }
        return token;
    }

    private static final Token nullishCoalescing(ListIterator<Character> $this$nullishCoalescing) {
        Token token;
        if (!$this$nullishCoalescing.hasNext()) {
            return Token.Operator.NullishCoalescing.INSTANCE;
        }
        if ($this$nullishCoalescing.next().charValue() == '=') {
            token = Token.Operator.Assign.NullCoalescingAssign.INSTANCE;
        } else {
            Token.Operator.NullishCoalescing nullishCoalescing;
            Token.Operator.NullishCoalescing it = nullishCoalescing = Token.Operator.NullishCoalescing.INSTANCE;
            boolean bl = false;
            $this$nullishCoalescing.previous();
            token = nullishCoalescing;
        }
        return token;
    }

    private static final Token period(ListIterator<Character> $this$period) {
        Token token;
        if (!$this$period.hasNext()) {
            return Token.Operator.Period.INSTANCE;
        }
        if ($this$period.next().charValue() == '.') {
            token = LexerKt.doublePeriod($this$period);
        } else {
            Token.Operator.Period period;
            Token.Operator.Period it = period = Token.Operator.Period.INSTANCE;
            boolean bl = false;
            $this$period.previous();
            token = period;
        }
        return token;
    }

    private static final Token doublePeriod(ListIterator<Character> $this$doublePeriod) {
        Token token;
        if (!$this$doublePeriod.hasNext()) {
            return Token.Operator.DoublePeriod.INSTANCE;
        }
        if ($this$doublePeriod.next().charValue() == '.') {
            token = Token.Operator.Spread.INSTANCE;
        } else {
            Token.Operator.DoublePeriod doublePeriod;
            Token.Operator.DoublePeriod it = doublePeriod = Token.Operator.DoublePeriod.INSTANCE;
            boolean bl = false;
            $this$doublePeriod.previous();
            token = doublePeriod;
        }
        return token;
    }

    private static final Token assign(ListIterator<Character> $this$assign) {
        Token token;
        if (!$this$assign.hasNext()) {
            return Token.Operator.Assign.Assignment.INSTANCE;
        }
        switch ($this$assign.next().charValue()) {
            case '=': {
                token = LexerKt.eq($this$assign);
                break;
            }
            case '>': {
                token = Token.Operator.Arrow.INSTANCE;
                break;
            }
            default: {
                Token.Operator.Assign.Assignment assignment;
                Token.Operator.Assign.Assignment it = assignment = Token.Operator.Assign.Assignment.INSTANCE;
                boolean bl = false;
                $this$assign.previous();
                token = assignment;
            }
        }
        return token;
    }

    private static final Token eq(ListIterator<Character> $this$eq) {
        Token token;
        if (!$this$eq.hasNext()) {
            return Token.Operator.Compare.Eq.INSTANCE;
        }
        if ($this$eq.next().charValue() == '=') {
            token = Token.Operator.Compare.StrictEq.INSTANCE;
        } else {
            Token.Operator.Compare.Eq eq;
            Token.Operator.Compare.Eq it = eq = Token.Operator.Compare.Eq.INSTANCE;
            boolean bl = false;
            $this$eq.previous();
            token = eq;
        }
        return token;
    }

    private static final Token.Operator plus(ListIterator<Character> $this$plus) {
        Token.Operator operator;
        if (!$this$plus.hasNext()) {
            return Token.Operator.Arithmetic.Plus.INSTANCE;
        }
        switch ($this$plus.next().charValue()) {
            case '+': {
                operator = Token.Operator.Arithmetic.Inc.INSTANCE;
                break;
            }
            case '=': {
                operator = Token.Operator.Assign.PlusAssign.INSTANCE;
                break;
            }
            default: {
                Token.Operator.Arithmetic.Plus plus;
                Token.Operator.Arithmetic.Plus it = plus = Token.Operator.Arithmetic.Plus.INSTANCE;
                boolean bl = false;
                $this$plus.previous();
                operator = plus;
            }
        }
        return operator;
    }

    private static final Token.Operator minus(ListIterator<Character> $this$minus) {
        Token.Operator operator;
        if (!$this$minus.hasNext()) {
            return Token.Operator.Arithmetic.Minus.INSTANCE;
        }
        switch ($this$minus.next().charValue()) {
            case '-': {
                operator = Token.Operator.Arithmetic.Dec.INSTANCE;
                break;
            }
            case '=': {
                operator = Token.Operator.Assign.MinusAssign.INSTANCE;
                break;
            }
            default: {
                Token.Operator.Arithmetic.Minus minus;
                Token.Operator.Arithmetic.Minus it = minus = Token.Operator.Arithmetic.Minus.INSTANCE;
                boolean bl = false;
                $this$minus.previous();
                operator = minus;
            }
        }
        return operator;
    }

    private static final Token.Operator mul(ListIterator<Character> $this$mul) {
        Token.Operator operator;
        if (!$this$mul.hasNext()) {
            return Token.Operator.Arithmetic.Mul.INSTANCE;
        }
        switch ($this$mul.next().charValue()) {
            case '=': {
                operator = Token.Operator.Assign.MulAssign.INSTANCE;
                break;
            }
            case '*': {
                operator = LexerKt.exp($this$mul);
                break;
            }
            default: {
                Token.Operator.Arithmetic.Mul mul2;
                Token.Operator.Arithmetic.Mul it = mul2 = Token.Operator.Arithmetic.Mul.INSTANCE;
                boolean bl = false;
                $this$mul.previous();
                operator = mul2;
            }
        }
        return operator;
    }

    private static final Token.Operator exp(ListIterator<Character> $this$exp) {
        Token.Operator operator;
        if (!$this$exp.hasNext()) {
            return Token.Operator.Arithmetic.Exp.INSTANCE;
        }
        if ($this$exp.next().charValue() == '=') {
            operator = Token.Operator.Assign.ExpAssign.INSTANCE;
        } else {
            Token.Operator.Arithmetic.Exp exp;
            Token.Operator.Arithmetic.Exp it = exp = Token.Operator.Arithmetic.Exp.INSTANCE;
            boolean bl = false;
            $this$exp.previous();
            operator = exp;
        }
        return operator;
    }

    private static final Token div(ListIterator<Character> $this$div, Token prev) {
        Token token;
        if (!$this$div.hasNext()) {
            return Token.Operator.Arithmetic.Div.INSTANCE;
        }
        char next2 = $this$div.next().charValue();
        switch (next2) {
            case '/': {
                token = LexerKt.comment($this$div, true);
                break;
            }
            case '*': {
                token = LexerKt.comment($this$div, false);
                break;
            }
            default: {
                Token.Operator operator;
                Token token2 = prev;
                if (token2 == null || token2 instanceof Token.NewLine || token2 instanceof Token.Operator.Logical || token2 instanceof Token.Operator.Arithmetic || token2 instanceof Token.Operator.Compare || token2 instanceof Token.Operator.Assign || token2 instanceof Token.Operator.Comma || token2 instanceof Token.Operator.Colon || token2 instanceof Token.Operator.SemiColon || token2 instanceof Token.Operator.Arrow || token2 instanceof Token.Operator.QuestionMark || token2 instanceof Token.Operator.NullishCoalescing || token2 instanceof Token.Operator.Bracket.RoundOpen || token2 instanceof Token.Operator.Bracket.CurlyOpen || token2 instanceof Token.Operator.Bracket.SquareOpen) {
                    $this$div.previous();
                    token = Token.Regex.box-impl(LexerKt.regex($this$div));
                    break;
                }
                if (next2 == '=') {
                    operator = Token.Operator.Assign.DivAssign.INSTANCE;
                } else {
                    Token.Operator.Arithmetic.Div div2;
                    Token.Operator.Arithmetic.Div it = div2 = Token.Operator.Arithmetic.Div.INSTANCE;
                    boolean bl = false;
                    $this$div.previous();
                    operator = div2;
                }
                token = operator;
            }
        }
        return token;
    }

    private static final Token mod(ListIterator<Character> $this$mod) {
        Token token;
        if (!$this$mod.hasNext()) {
            return Token.Operator.Arithmetic.Mod.INSTANCE;
        }
        if ($this$mod.next().charValue() == '=') {
            token = Token.Operator.Assign.ModAssign.INSTANCE;
        } else {
            Token.Operator.Arithmetic.Mod mod2;
            Token.Operator.Arithmetic.Mod it = mod2 = Token.Operator.Arithmetic.Mod.INSTANCE;
            boolean bl = false;
            $this$mod.previous();
            token = mod2;
        }
        return token;
    }

    private static final Token and(ListIterator<Character> $this$and) {
        Token token;
        if (!$this$and.hasNext()) {
            return Token.Operator.Bitwise.And.INSTANCE;
        }
        switch ($this$and.next().charValue()) {
            case '&': {
                token = LexerKt.andLogical($this$and);
                break;
            }
            case '=': {
                token = Token.Operator.Assign.BitAndAssign.INSTANCE;
                break;
            }
            default: {
                Token.Operator.Bitwise.And and;
                Token.Operator.Bitwise.And it = and = Token.Operator.Bitwise.And.INSTANCE;
                boolean bl = false;
                $this$and.previous();
                token = and;
            }
        }
        return token;
    }

    private static final Token andLogical(ListIterator<Character> $this$andLogical) {
        Token token;
        if (!$this$andLogical.hasNext()) {
            return Token.Operator.Logical.And.INSTANCE;
        }
        if ($this$andLogical.next().charValue() == '=') {
            token = Token.Operator.Assign.LogicAndAssign.INSTANCE;
        } else {
            Token.Operator.Logical.And and;
            Token.Operator.Logical.And it = and = Token.Operator.Logical.And.INSTANCE;
            boolean bl = false;
            $this$andLogical.previous();
            token = and;
        }
        return token;
    }

    private static final Token or(ListIterator<Character> $this$or) {
        Token token;
        if (!$this$or.hasNext()) {
            return Token.Operator.Bitwise.Or.INSTANCE;
        }
        switch ($this$or.next().charValue()) {
            case '|': {
                token = LexerKt.orLogical($this$or);
                break;
            }
            case '=': {
                token = Token.Operator.Assign.BitOrAssign.INSTANCE;
                break;
            }
            default: {
                Token.Operator.Bitwise.Or or;
                Token.Operator.Bitwise.Or it = or = Token.Operator.Bitwise.Or.INSTANCE;
                boolean bl = false;
                $this$or.previous();
                token = or;
            }
        }
        return token;
    }

    private static final Token orLogical(ListIterator<Character> $this$orLogical) {
        Token token;
        if (!$this$orLogical.hasNext()) {
            return Token.Operator.Logical.Or.INSTANCE;
        }
        if ($this$orLogical.next().charValue() == '=') {
            token = Token.Operator.Assign.LogicOrAssign.INSTANCE;
        } else {
            Token.Operator.Logical.Or or;
            Token.Operator.Logical.Or it = or = Token.Operator.Logical.Or.INSTANCE;
            boolean bl = false;
            $this$orLogical.previous();
            token = or;
        }
        return token;
    }

    private static final Token xor(ListIterator<Character> $this$xor) {
        Token token;
        if (!$this$xor.hasNext()) {
            return Token.Operator.Bitwise.Xor.INSTANCE;
        }
        if ($this$xor.next().charValue() == '=') {
            token = Token.Operator.Assign.BitXorAssign.INSTANCE;
        } else {
            Token.Operator.Bitwise.Xor xor;
            Token.Operator.Bitwise.Xor it = xor = Token.Operator.Bitwise.Xor.INSTANCE;
            boolean bl = false;
            $this$xor.previous();
            token = xor;
        }
        return token;
    }

    private static final Token less(ListIterator<Character> $this$less) {
        Token token;
        if (!$this$less.hasNext()) {
            return Token.Operator.Compare.Less.INSTANCE;
        }
        switch ($this$less.next().charValue()) {
            case '<': {
                token = LexerKt.shl($this$less);
                break;
            }
            case '=': {
                token = Token.Operator.Compare.LessOrEq.INSTANCE;
                break;
            }
            default: {
                Token.Operator.Compare.Less less;
                Token.Operator.Compare.Less it = less = Token.Operator.Compare.Less.INSTANCE;
                boolean bl = false;
                $this$less.previous();
                token = less;
            }
        }
        return token;
    }

    private static final Token greater(ListIterator<Character> $this$greater) {
        Token token;
        if (!$this$greater.hasNext()) {
            return Token.Operator.Compare.Greater.INSTANCE;
        }
        switch ($this$greater.next().charValue()) {
            case '>': {
                token = LexerKt.shr($this$greater);
                break;
            }
            case '=': {
                token = Token.Operator.Compare.GreaterOrEq.INSTANCE;
                break;
            }
            default: {
                Token.Operator.Compare.Greater greater;
                Token.Operator.Compare.Greater it = greater = Token.Operator.Compare.Greater.INSTANCE;
                boolean bl = false;
                $this$greater.previous();
                token = greater;
            }
        }
        return token;
    }

    private static final Token shl(ListIterator<Character> $this$shl) {
        Token token;
        if (!$this$shl.hasNext()) {
            return Token.Operator.Bitwise.Shl.INSTANCE;
        }
        if ($this$shl.next().charValue() == '=') {
            token = Token.Operator.Assign.ShlAssign.INSTANCE;
        } else {
            Token.Operator.Bitwise.Shl shl;
            Token.Operator.Bitwise.Shl it = shl = Token.Operator.Bitwise.Shl.INSTANCE;
            boolean bl = false;
            $this$shl.previous();
            token = shl;
        }
        return token;
    }

    private static final Token shr(ListIterator<Character> $this$shr) {
        Token token;
        if (!$this$shr.hasNext()) {
            return Token.Operator.Bitwise.Shr.INSTANCE;
        }
        switch ($this$shr.next().charValue()) {
            case '=': {
                token = Token.Operator.Assign.ShrAssign.INSTANCE;
                break;
            }
            case '>': {
                token = LexerKt.ushr($this$shr);
                break;
            }
            default: {
                Token.Operator.Bitwise.Shr shr;
                Token.Operator.Bitwise.Shr it = shr = Token.Operator.Bitwise.Shr.INSTANCE;
                boolean bl = false;
                $this$shr.previous();
                token = shr;
            }
        }
        return token;
    }

    private static final Token ushr(ListIterator<Character> $this$ushr) {
        Token token;
        if (!$this$ushr.hasNext()) {
            return Token.Operator.Bitwise.Ushr.INSTANCE;
        }
        if ($this$ushr.next().charValue() == '=') {
            token = Token.Operator.Assign.UshrAssign.INSTANCE;
        } else {
            Token.Operator.Bitwise.Ushr ushr;
            Token.Operator.Bitwise.Ushr it = ushr = Token.Operator.Bitwise.Ushr.INSTANCE;
            boolean bl = false;
            $this$ushr.previous();
            token = ushr;
        }
        return token;
    }

    private static final Token not(ListIterator<Character> $this$not) {
        Token token;
        if (!$this$not.hasNext()) {
            return Token.Operator.Logical.Not.INSTANCE;
        }
        if ($this$not.next().charValue() == '=') {
            token = LexerKt.neq($this$not);
        } else {
            Token.Operator.Logical.Not not;
            Token.Operator.Logical.Not it = not = Token.Operator.Logical.Not.INSTANCE;
            boolean bl = false;
            $this$not.previous();
            token = not;
        }
        return token;
    }

    private static final Token neq(ListIterator<Character> $this$neq) {
        Token token;
        if (!$this$neq.hasNext()) {
            return Token.Operator.Compare.Neq.INSTANCE;
        }
        if ($this$neq.next().charValue() == '=') {
            token = Token.Operator.Compare.StrictNeq.INSTANCE;
        } else {
            Token.Operator.Compare.Neq neq;
            Token.Operator.Compare.Neq it = neq = Token.Operator.Compare.Neq.INSTANCE;
            boolean bl = false;
            $this$neq.previous();
            token = neq;
        }
        return token;
    }

    private static final Token.Comment hashbangComment(ListIterator<Character> $this$hashbangComment) {
        boolean value$iv = $this$hashbangComment.hasNext() && $this$hashbangComment.next().charValue() == '!';
        boolean $i$f$syntaxCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Unexpected #";
            throw new SyntaxError((Object)message$iv.toString(), null, 2, null);
        }
        return LexerKt.comment($this$hashbangComment, true);
    }

    private static final String regex(ListIterator<Character> $this$regex) {
        StringBuilder stringBuilder;
        StringBuilder $this$regex_u24lambda_u2430 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$regex_u24lambda_u2430.append('/');
        boolean isAtFlags = false;
        while ($this$regex.hasNext()) {
            char next2 = $this$regex.next().charValue();
            if (isAtFlags && !REGEX_FLAGS.contains(Character.valueOf(next2))) {
                $this$regex.previous();
                break;
            }
            $this$regex_u24lambda_u2430.append(next2);
            if (next2 != '/') continue;
            isAtFlags = true;
        }
        return Token.Regex.constructor-impl(stringBuilder.toString());
    }

    private static final Token.Comment comment(ListIterator<Character> $this$comment, boolean isSingleLine) {
        StringBuilder stringBuilder;
        StringBuilder $this$comment_u24lambda_u2431 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (isSingleLine) {
            char n;
            while ($this$comment.hasNext() && !LSEP.contains(n = $this$comment.next().charValue())) {
                $this$comment_u24lambda_u2431.append(n);
            }
        } else {
            char a = $this$comment.next().charValue();
            char b = $this$comment.next().charValue();
            while (a != '*' || b != '/') {
                $this$comment_u24lambda_u2431.append(a);
                a = b;
                b = $this$comment.next().charValue();
            }
        }
        String value2 = stringBuilder.toString();
        return new Token.Comment(value2, isSingleLine);
    }

    @NotNull
    public static final String string(@NotNull ListIterator<Character> $this$string, char start) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter($this$string, (String)"<this>");
        try {
            StringBuilder $this$string_u24lambda_u2432 = charSequence = new StringBuilder();
            boolean bl = false;
            boolean isEscaping = false;
            char n = $this$string.next().charValue();
            while (isEscaping || n != start) {
                $this$string_u24lambda_u2432.append(n);
                isEscaping = n == '\\' ? !isEscaping : false;
                n = $this$string.next().charValue();
            }
            charSequence = charSequence.toString();
        }
        catch (NoSuchElementException t) {
            throw new SyntaxError((Object)"Unexpected string", null, 2, null);
        }
        CharSequence str = charSequence;
        return Token.Str.constructor-impl(LexerKt.unescape((String)str));
    }

    private static final int toUnicodePoint(String $this$toUnicodePoint) {
        return Integer.parseInt(StringsKt.removeSuffix((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)$this$toUnicodePoint, (CharSequence)"\\u"), (CharSequence)"{"), (CharSequence)"}"), CharsKt.checkRadix((int)16));
    }

    private static final String unescape(String $this$unescape) {
        CharSequence charSequence = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)$this$unescape, (String)"\\'", (String)"'", (boolean)false, (int)4, null), (String)"\\\"", (String)"\"", (boolean)false, (int)4, null), (String)"\\n", (String)"\n", (boolean)false, (int)4, null), (String)"\\r", (String)"\r", (boolean)false, (int)4, null), (String)"\\t", (String)"\t", (boolean)false, (int)4, null), (String)"\\b", (String)"\b", (boolean)false, (int)4, null), (String)"\\\\", (String)"\"", (boolean)false, (int)4, null);
        Regex regex = UNICODE_REGEX_SURROGATE;
        Function1 function1 = LexerKt::unescape$lambda$33;
        charSequence = regex.replace(charSequence, function1);
        regex = UNICODE_REGEX;
        function1 = LexerKt::unescape$lambda$34;
        return regex.replace(charSequence, function1);
    }

    @NotNull
    public static final String escape(@NotNull String $this$escape) {
        Intrinsics.checkNotNullParameter((Object)$this$escape, (String)"<this>");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)$this$escape, (String)"'", (String)"\\'", (boolean)false, (int)4, null), (String)"\"", (String)"\\\"", (boolean)false, (int)4, null), (String)"\n", (String)"\\n", (boolean)false, (int)4, null), (String)"\r", (String)"\\r", (boolean)false, (int)4, null), (String)"\t", (String)"\\t", (boolean)false, (int)4, null), (String)"\b", (String)"\\b", (boolean)false, (int)4, null), (String)"\"", (String)"\\\\", (boolean)false, (int)4, null);
    }

    @NotNull
    public static final Token.Num number(@NotNull ListIterator<Character> $this$number, char start) {
        Token.Num num;
        Intrinsics.checkNotNullParameter($this$number, (String)"<this>");
        StringBuilder value2 = new StringBuilder();
        NumberFormat numberFormat = null;
        numberFormat = NumberFormat.Dec;
        boolean isFloat = false;
        char ch = start;
        boolean wasE = false;
        while (true) {
            char c;
            if ((c = ch) == 'e' || c == 'E') {
                if (wasE) break;
                wasE = true;
                if (numberFormat == NumberFormat.Dec) {
                    isFloat = true;
                }
            } else if (c == '.') {
                if (isFloat) break;
                isFloat = true;
            } else {
                boolean $i$f$syntaxCheck;
                boolean value$iv;
                Character c2 = NumberFormat.Hex.getPrefix();
                if (c2 != null && c == c2.charValue()) {
                    value$iv = numberFormat == NumberFormat.Dec && !isFloat;
                    $i$f$syntaxCheck = false;
                    if (!value$iv) {
                        boolean bl = false;
                        String message$iv = "Invalid number";
                        throw new SyntaxError((Object)message$iv.toString(), null, 2, null);
                    }
                    numberFormat = NumberFormat.Hex;
                } else {
                    Character c3 = NumberFormat.Oct.getPrefix();
                    if (c3 != null && c == c3.charValue()) {
                        value$iv = numberFormat == NumberFormat.Dec && !isFloat;
                        $i$f$syntaxCheck = false;
                        if (!value$iv) {
                            boolean bl = false;
                            String message$iv = "Invalid number";
                            throw new SyntaxError((Object)message$iv.toString(), null, 2, null);
                        }
                        numberFormat = NumberFormat.Oct;
                    } else {
                        Character c4 = NumberFormat.Bin.getPrefix();
                        if (c4 != null && c == c4.charValue() && numberFormat != NumberFormat.Hex) {
                            value$iv = numberFormat == NumberFormat.Dec && !isFloat;
                            $i$f$syntaxCheck = false;
                            if (!value$iv) {
                                boolean bl = false;
                                String message$iv = "Invalid number";
                                throw new SyntaxError((Object)message$iv.toString(), null, 2, null);
                            }
                            numberFormat = NumberFormat.Bin;
                        }
                    }
                }
            }
            value2.append(ch);
            ch = Character.toLowerCase($this$number.next().charValue());
            if (numberFormat.getAlphabet().contains(Character.valueOf(ch)) || NumberFormatIndicators.contains(Character.valueOf(ch))) continue;
            if (ch != '-' && ch != '+') break;
            Character c5 = StringsKt.lastOrNull((CharSequence)value2);
            c = 'e';
            if (c5 == null || c5.charValue() != c) break;
        }
        $this$number.previous();
        try {
            Token.Num num2;
            block22: {
                Object object;
                block24: {
                    String n;
                    block23: {
                        block21: {
                            if (StringsKt.endsWith$default((CharSequence)value2, (char)'.', (boolean)false, (int)2, null)) {
                                $this$number.previous();
                                isFloat = false;
                            }
                            if (!isFloat) break block21;
                            String string = value2.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                            double number = Double.parseDouble(StringsKt.replace$default((String)string, (String)"_", (String)"", (boolean)false, (int)4, null));
                            num2 = new Token.Num(number, numberFormat, isFloat);
                            break block22;
                        }
                        String string = value2.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                        char[] cArray = new char[]{'.'};
                        n = StringsKt.replace$default((String)StringsKt.trimEnd((String)string, (char[])cArray), (String)"_", (String)"", (boolean)false, (int)4, null);
                        boolean bl = false;
                        object = numberFormat.getPrefix();
                        if (object == null) break block23;
                        char p0 = ((Character)object).charValue();
                        boolean bl2 = false;
                        String string2 = StringsKt.substringAfter$default((String)n, (char)p0, null, (int)2, null);
                        object = string2;
                        if (string2 != null) break block24;
                    }
                    object = n;
                }
                long number = UStringsKt.toULong((String)object, (int)numberFormat.getRadix());
                num2 = new Token.Num(number, numberFormat, isFloat);
            }
            num = num2;
        }
        catch (NumberFormatException t) {
            throw new SyntaxError((Object)("Unexpected token '" + value2 + "'"), (Throwable)t);
        }
        return num;
    }

    private static final Map<String, Token.Identifier.Keyword> getKeywords() {
        Lazy lazy = keywords$delegate;
        return (Map)lazy.getValue();
    }

    private static final Map<String, Token.Identifier.Reserved> getReserved() {
        Lazy lazy = reserved$delegate;
        return (Map)lazy.getValue();
    }

    private static final Token identifier(ListIterator<Character> $this$identifier, char start) {
        Token token;
        StringBuilder value2 = new StringBuilder(String.valueOf(start));
        while ($this$identifier.hasNext()) {
            char next2 = $this$identifier.next().charValue();
            if (!PROPERTY_ALPHABET_WITH_NUM.contains(Character.valueOf(next2))) {
                $this$identifier.previous();
                break;
            }
            value2.append(next2);
        }
        String string = value2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = LexerKt.unescape(string);
        if (Intrinsics.areEqual((Object)string2, (Object)"new")) {
            token = Token.Operator.New.INSTANCE;
        } else if (Intrinsics.areEqual((Object)string2, (Object)"in")) {
            token = Token.Operator.In.INSTANCE;
        } else if (Intrinsics.areEqual((Object)string2, (Object)"instanceof")) {
            token = Token.Operator.Instanceof.INSTANCE;
        } else if (Intrinsics.areEqual((Object)string2, (Object)"typeof")) {
            token = Token.Operator.Typeof.INSTANCE;
        } else if (Intrinsics.areEqual((Object)string2, (Object)"void")) {
            token = Token.Operator.Void.INSTANCE;
        } else if (Intrinsics.areEqual((Object)string2, (Object)"delete")) {
            token = Token.Operator.Delete.INSTANCE;
        } else if (LexerKt.getKeywords().containsKey(string2)) {
            Token.Identifier.Keyword keyword = LexerKt.getKeywords().get(string2);
            Intrinsics.checkNotNull((Object)keyword);
            token = keyword;
        } else if (LexerKt.getReserved().containsKey(string2)) {
            Token.Identifier.Reserved reserved = LexerKt.getReserved().get(string2);
            Intrinsics.checkNotNull((Object)reserved);
            token = reserved;
        } else {
            token = Token.Identifier.Property.box-impl(Token.Identifier.Property.constructor-impl(string2));
        }
        return token;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<? extends TemplateStringToken> templateString(ListIterator<Character> $this$templateString, boolean ignoreWhitespaces) {
        List list2;
        List $this$templateString_u24lambda_u2444 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        StringBuilder str = new StringBuilder();
        boolean isEscaping = false;
        while (true) {
            Comparable<StringBuilder> comparable;
            char next2;
            if ((next2 = $this$templateString.next().charValue()) == '`' && !isEscaping) break;
            if (next2 == '$' && !isEscaping) {
                char nNext = $this$templateString.next().charValue();
                if (nNext == '{') {
                    void $this$templateString_u24lambda_u2444_u24lambda_u2443;
                    List list3;
                    LexerKt.templateString$lambda$44$addStr(str, $this$templateString_u24lambda_u2444);
                    List list4 = list3 = CollectionsKt.createListBuilder();
                    List list5 = $this$templateString_u24lambda_u2444;
                    boolean bl2 = false;
                    $this$templateString_u24lambda_u2444_u24lambda_u2443.add(Token.Operator.Bracket.CurlyOpen.INSTANCE);
                    $this$templateString_u24lambda_u2444_u24lambda_u2443.addAll((Collection)LexerKt.tokenize($this$templateString, true, ignoreWhitespaces));
                    $this$templateString_u24lambda_u2444_u24lambda_u2443.add(Token.Operator.Bracket.CurlyClose.INSTANCE);
                    comparable = list5.add(TemplateStringToken.Template.box-impl(TemplateStringToken.Template.constructor-impl(CollectionsKt.build((List)list3))));
                } else {
                    str.append(next2);
                    comparable = str.append(nNext);
                }
            } else {
                comparable = str.append(next2);
            }
            isEscaping = next2 == '\\' ? !isEscaping : false;
        }
        LexerKt.templateString$lambda$44$addStr(str, $this$templateString_u24lambda_u2444);
        List tokens = CollectionsKt.build((List)list2);
        return Token.TemplateString.constructor-impl(tokens);
    }

    @NotNull
    public static final HashSet<Integer> getLSEP() {
        return LSEP;
    }

    private static final CharSequence unescape$lambda$33(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int sub2 = LexerKt.toUnicodePoint(it.getValue()) - 65536;
        int high = sub2 / 1024 + 55296;
        int low = sub2 % 1024 + 56320;
        if (high < 0 || high > 65535) {
            throw new IllegalArgumentException("Invalid Char code: " + high);
        }
        if (low < 0 || low > 65535) {
            throw new IllegalArgumentException("Invalid Char code: " + low);
        }
        return "" + (char)high + (char)low;
    }

    private static final CharSequence unescape$lambda$34(MatchResult it) {
        char c;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int unicode = LexerKt.toUnicodePoint(it.getValue());
        if (LSEP.contains(unicode)) {
            c = '\n';
        } else {
            if (unicode < 0 || unicode > 65535) {
                throw new IllegalArgumentException("Invalid Char code: " + unicode);
            }
            c = (char)unicode;
        }
        return String.valueOf(c);
    }

    /*
     * WARNING - void declaration
     */
    private static final Map keywords_delegate$lambda$40() {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = (Iterable)Token.Identifier.Keyword.getEntries();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Token.Identifier.Keyword keyword = (Token.Identifier.Keyword)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getIdentifier(), element$iv$iv);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map reserved_delegate$lambda$42() {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = (Iterable)Token.Identifier.Reserved.getEntries();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Token.Identifier.Reserved reserved = (Token.Identifier.Reserved)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getIdentifier(), element$iv$iv);
        }
        return destination$iv$iv;
    }

    private static final void templateString$lambda$44$addStr(StringBuilder str, List<TemplateStringToken> $this_buildList) {
        if (((CharSequence)str).length() > 0) {
            String string = str.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            $this_buildList.add(TemplateStringToken.Str.box-impl(TemplateStringToken.Str.constructor-impl(LexerKt.unescape(string))));
            StringsKt.clear((StringBuilder)str);
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapNotNullTo$iv$iv;
        Object[] objectArray = new Character[]{Character.valueOf('d'), Character.valueOf('g'), Character.valueOf('i'), Character.valueOf('m'), Character.valueOf('s'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('y')};
        REGEX_FLAGS = SetsKt.setOf((Object[])objectArray);
        UNICODE_REGEX = new Regex("\\\\u[{]?[0-9a-fA-F]{4}[}]?");
        UNICODE_REGEX_SURROGATE = new Regex("\\\\u[{][0-9a-fA-F]{5,6}[}]");
        keywords$delegate = LazyKt.lazy(LexerKt::keywords_delegate$lambda$40);
        reserved$delegate = LazyKt.lazy(LexerKt::reserved_delegate$lambda$42);
        objectArray = new Character[]{Character.valueOf('\"'), Character.valueOf('\'')};
        STRING_START = SetsKt.hashSetOf((Object[])objectArray);
        objectArray = new Integer[]{13, 10, 8232, 8233};
        LSEP = SetsKt.hashSetOf((Object[])objectArray);
        objectArray = new Character[]{Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9')};
        NUMBERS = SetsKt.hashSetOf((Object[])objectArray);
        Iterable $this$mapNotNull$iv = (Iterable)NumberFormat.getEntries();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Character it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            NumberFormat it = (NumberFormat)((Object)element$iv$iv);
            boolean bl2 = false;
            if (it.getPrefix() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        NumberFormatIndicators = (List)var3_3;
        IDENTIFIER_ALPHABET = CollectionsKt.toHashSet((Iterable)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.toList((Iterable)((Iterable)new CharRange('a', 'z'))), (Iterable)CollectionsKt.toList((Iterable)((Iterable)new CharRange('A', 'Z')))), (Object)Character.valueOf('$')), (Object)Character.valueOf('_')));
        PROPERTY_ALPHABET_WITH_NUM = CollectionsKt.toHashSet((Iterable)SetsKt.plus((Set)IDENTIFIER_ALPHABET, (Iterable)NUMBERS));
    }
}

