/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.krafiks;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.Paint;
import androidx.compose.ui.graphics.SkiaBackedPaint_skikoKt;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.drawscope.DrawStyle;
import androidx.compose.ui.graphics.drawscope.Fill;
import androidx.compose.ui.text.MultiParagraph;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextMeasurer;
import androidx.compose.ui.text.TextStyle;
import dev.romainguy.kotlin.math.Float2;
import dev.romainguy.kotlin.math.Float4;
import dev.romainguy.kotlin.math.Mat4;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.krafiks.Camera;
import vet.inpulse.krafiks.CircularFloatArray;
import vet.inpulse.krafiks.ComposeUtilsKt;
import vet.inpulse.krafiks.GLES_jvmKt;
import vet.inpulse.krafiks.Grid;
import vet.inpulse.krafiks.KotlinMathExtKt;
import vet.inpulse.krafiks.KrafiksChart;
import vet.inpulse.krafiks.LayoutBuilder;
import vet.inpulse.krafiks.MarkerDrawer;
import vet.inpulse.krafiks.Markers;
import vet.inpulse.krafiks.Mesh;
import vet.inpulse.krafiks.MeshCache;
import vet.inpulse.krafiks.Renderer;
import vet.inpulse.krafiks.VertexBufferLayout;
import vet.inpulse.krafiks.VertexBufferLayoutKt;
import vet.inpulse.krafiks.WaveformDrawMode;
import vet.inpulse.krafiks.WaveformLabel;
import vet.inpulse.krafiks.WaveformLegend;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u001d\b\u0016\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\tJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\rH\u0016J\u0018\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\rH\u0016J\u0013\u0010\u007f\u001a\u00020\u001c2\u000b\u0010\u0080\u0001\u001a\u0006\u0012\u0002\b\u00030hJ\u0007\u0010\u0081\u0001\u001a\u00020\u001cJ\u0011\u0010\u0082\u0001\u001a\u00020#2\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001J\u0011\u0010\u0085\u0001\u001a\u00020\u00072\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001J\u0011\u0010\u0086\u0001\u001a\u00020\u00072\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001J%\u0010\u0087\u0001\u001a\u00020\u001c2\b\u0010\u0083\u0001\u001a\u00030\u0084\u00012\b\u0010\u0088\u0001\u001a\u00030\u0089\u00012\b\u0010\u008a\u0001\u001a\u00030\u008b\u0001J6\u0010\u008c\u0001\u001a\u00020\u001c2\b\u0010\u0083\u0001\u001a\u00030\u0084\u00012\b\u0010\u0088\u0001\u001a\u00030\u0089\u00012\u0007\u0010\u008d\u0001\u001a\u00020|2\u0007\u0010\u008e\u0001\u001a\u00020\u00072\u0007\u0010\u008f\u0001\u001a\u00020\u0007J6\u0010\u0090\u0001\u001a\u00020\u001c2\b\u0010\u0083\u0001\u001a\u00030\u0084\u00012\b\u0010\u0088\u0001\u001a\u00030\u0089\u00012\u0007\u0010\u008d\u0001\u001a\u00020|2\u0007\u0010\u008e\u0001\u001a\u00020\u00072\u0007\u0010\u008f\u0001\u001a\u00020\u0007J\u0012\u0010\u0091\u0001\u001a\u00020\u00072\u0007\u0010\u0092\u0001\u001a\u00020\u0003H\u0002J@\u0010\u0093\u0001\u001a\u00020\u001c2\b\u0010\u0083\u0001\u001a\u00030\u0084\u00012\b\u0010\u0088\u0001\u001a\u00030\u0089\u00012\u0007\u0010\u008d\u0001\u001a\u00020|2\u0007\u0010\u008e\u0001\u001a\u00020\u00072\u0007\u0010\u008f\u0001\u001a\u00020\u00072\b\u0010\u008a\u0001\u001a\u00030\u008b\u0001J%\u0010\u0094\u0001\u001a\u00020\u001c2\b\u0010\u0095\u0001\u001a\u00030\u0096\u00012\b\u0010\u0097\u0001\u001a\u00030\u0098\u00012\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001J%\u0010\u0099\u0001\u001a\u00020\u001c2\b\u0010\u0095\u0001\u001a\u00030\u0096\u00012\b\u0010\u0097\u0001\u001a\u00030\u0098\u00012\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001J%\u0010\u009a\u0001\u001a\u00020\u001c2\b\u0010\u0095\u0001\u001a\u00030\u0096\u00012\b\u0010\u0097\u0001\u001a\u00030\u0098\u00012\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001J\u0010\u0010\u009b\u0001\u001a\u00020\r2\u0007\u0010\u009c\u0001\u001a\u00020\u0007J\u0010\u0010\u009d\u0001\u001a\u00020\r2\u0007\u0010\u009c\u0001\u001a\u00020\u0007J2\u0010\u009e\u0001\u001a\u0011\u0012\u0005\u0012\u00030\u00a0\u0001\u0012\u0005\u0012\u00030\u00a1\u00010\u009f\u00012\u0007\u0010\u00a2\u0001\u001a\u00020\u00072\u0007\u0010\u00a3\u0001\u001a\u00020\u00072\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001J\u001b\u0010\u00a4\u0001\u001a\u00020\u001c2\b\u0010\u0088\u0001\u001a\u00030\u0089\u00012\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001J\u001b\u0010\u00a5\u0001\u001a\u00020\u001c2\b\u0010\u00a6\u0001\u001a\u00030\u0096\u00012\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001J%\u0010\u00a7\u0001\u001a\u00020\u001c2\b\u0010\u0095\u0001\u001a\u00030\u0096\u00012\b\u0010\u0097\u0001\u001a\u00030\u0098\u00012\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001J\u001b\u0010\u00a8\u0001\u001a\u00020\u001c2\b\u0010\u0083\u0001\u001a\u00030\u0084\u00012\b\u0010\u00a9\u0001\u001a\u00030\u0089\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u001a\u0010\u0015\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000f\"\u0004\b\u0017\u0010\u0011R\u001a\u0010\u0018\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u000f\"\u0004\b\u001a\u0010\u0011R\u001a\u0010\"\u001a\u00020#X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010%\"\u0004\b*\u0010'R\u001a\u0010+\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u000f\"\u0004\b-\u0010\u0011R\u001a\u0010.\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001a\u00104\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u000f\"\u0004\b6\u0010\u0011R\u001a\u00107\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00101\"\u0004\b9\u00103R\u001a\u0010:\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010\u000f\"\u0004\b<\u0010\u0011R\u001a\u0010=\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010%\"\u0004\b?\u0010'R\u001a\u0010@\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010\u000f\"\u0004\bB\u0010\u0011R\u001c\u0010C\u001a\u0004\u0018\u00010DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010F\"\u0004\bG\u0010HR\u001a\u0010I\u001a\u00020JX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR\u001a\u0010O\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010Q\"\u0004\bR\u0010SR\u001a\u0010T\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bU\u0010\u000f\"\u0004\bV\u0010\u0011R\u001c\u0010W\u001a\u0004\u0018\u00010XX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bY\u0010Z\"\u0004\b[\u0010\\R\u001c\u0010]\u001a\u0004\u0018\u00010^X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b_\u0010`\"\u0004\ba\u0010bR\u001c\u0010c\u001a\u0004\u0018\u00010^X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bd\u0010`\"\u0004\be\u0010bR&\u0010f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020i0h0gX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bj\u0010k\"\u0004\bl\u0010mR$\u0010o\u001a\u0004\u0018\u00010\r2\b\u0010n\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010r\u001a\u0004\bp\u0010qR$\u0010s\u001a\u0004\u0018\u00010\r2\b\u0010n\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010r\u001a\u0004\bt\u0010qR\u001a\u0010u\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bv\u0010%\"\u0004\bw\u0010'R\u001a\u0010x\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\by\u0010%\"\u0004\bz\u0010'R\u0011\u0010{\u001a\u00020|8F\u00a2\u0006\u0006\u001a\u0004\b}\u0010~\u00a8\u0006\u00aa\u0001"}, d2={"Lvet/inpulse/krafiks/Waveform;", "Lvet/inpulse/krafiks/KrafiksChart;", "data", "Lvet/inpulse/krafiks/CircularFloatArray;", "<init>", "(Lvet/inpulse/krafiks/CircularFloatArray;)V", "initialDataSize", "", "growthFactor", "(II)V", "getData", "()Lvet/inpulse/krafiks/CircularFloatArray;", "posX", "", "getPosX", "()F", "setPosX", "(F)V", "posY", "getPosY", "setPosY", "sizeX", "getSizeX", "setSizeX", "sizeY", "getSizeY", "setSizeY", "setPosition", "", "x", "y", "setSize", "width", "height", "visible", "", "getVisible", "()Z", "setVisible", "(Z)V", "clipBounds", "getClipBounds", "setClipBounds", "valueMin", "getValueMin", "setValueMin", "colorMin", "Ldev/romainguy/kotlin/math/Float4;", "getColorMin", "()Ldev/romainguy/kotlin/math/Float4;", "setColorMin", "(Ldev/romainguy/kotlin/math/Float4;)V", "valueMax", "getValueMax", "setValueMax", "colorMax", "getColorMax", "setColorMax", "thickness", "getThickness", "setThickness", "filled", "getFilled", "setFilled", "gain", "getGain", "setGain", "grid", "Lvet/inpulse/krafiks/Grid;", "getGrid", "()Lvet/inpulse/krafiks/Grid;", "setGrid", "(Lvet/inpulse/krafiks/Grid;)V", "drawMode", "Lvet/inpulse/krafiks/WaveformDrawMode;", "getDrawMode", "()Lvet/inpulse/krafiks/WaveformDrawMode;", "setDrawMode", "(Lvet/inpulse/krafiks/WaveformDrawMode;)V", "cursorSize", "getCursorSize", "()I", "setCursorSize", "(I)V", "dataOffsetY", "getDataOffsetY", "setDataOffsetY", "label", "Lvet/inpulse/krafiks/WaveformLabel;", "getLabel", "()Lvet/inpulse/krafiks/WaveformLabel;", "setLabel", "(Lvet/inpulse/krafiks/WaveformLabel;)V", "legendX", "Lvet/inpulse/krafiks/WaveformLegend;", "getLegendX", "()Lvet/inpulse/krafiks/WaveformLegend;", "setLegendX", "(Lvet/inpulse/krafiks/WaveformLegend;)V", "legendY", "getLegendY", "setLegendY", "markers", "", "Lvet/inpulse/krafiks/Markers;", "", "getMarkers", "()Ljava/util/List;", "setMarkers", "(Ljava/util/List;)V", "value", "graphOffsetX", "getGraphOffsetX", "()Ljava/lang/Float;", "Ljava/lang/Float;", "graphOffsetY", "getGraphOffsetY", "debugBounds", "getDebugBounds", "setDebugBounds", "debugLegend", "getDebugLegend", "setDebugLegend", "modelMatrix", "Ldev/romainguy/kotlin/math/Mat4;", "getModelMatrix", "()Ldev/romainguy/kotlin/math/Mat4;", "addMarker", "m", "clearMarkers", "isInView", "camera", "Lvet/inpulse/krafiks/Camera;", "firstVisibleX", "lastVisibleX", "drawWaveform", "renderer", "Lvet/inpulse/krafiks/Renderer;", "meshCache", "Lvet/inpulse/krafiks/MeshCache;", "drawWipeMode", "model", "firstX", "lastX", "drawScrollMode", "handleFromData", "circularFloatArray", "drawStaticMode", "drawLegend", "scope", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "textMeasurer", "Landroidx/compose/ui/text/TextMeasurer;", "drawLegendY", "drawLegendX", "indexToY", "index", "indexToX", "indexArea", "Lkotlin/Pair;", "Landroidx/compose/ui/geometry/Offset;", "Landroidx/compose/ui/geometry/Size;", "startX", "endX", "drawGlMarkers", "drawComposeMarkers", "drawScope", "drawLabel", "drawGrid", "lineRenderer", "waveform-graph"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nWaveform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Waveform.kt\nvet/inpulse/krafiks/Waveform\n+ 2 Size.kt\nandroidx/compose/ui/geometry/Size\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 4 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 5 DrawScope.kt\nandroidx/compose/ui/graphics/drawscope/DrawScopeKt\n+ 6 IntSize.kt\nandroidx/compose/ui/unit/IntSize\n+ 7 Canvas.kt\nandroidx/compose/ui/graphics/CanvasKt\n+ 8 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 9 Rect.kt\nandroidx/compose/ui/geometry/Rect\n+ 10 Offset.kt\nandroidx/compose/ui/geometry/OffsetKt\n+ 11 Size.kt\nandroidx/compose/ui/geometry/SizeKt\n*L\n1#1,570:1\n57#2:571\n61#2:574\n57#2:576\n61#2:579\n57#2:597\n61#2:600\n57#2:628\n61#2:631\n60#3:572\n70#3:575\n60#3:577\n70#3:580\n90#3:583\n85#3:585\n90#3:587\n60#3:598\n70#3:601\n85#3:604\n90#3:606\n85#3:608\n90#3:610\n53#3,3:621\n53#3,3:625\n60#3:629\n70#3:632\n85#3:635\n90#3:637\n22#4:573\n22#4:578\n22#4:599\n22#4:630\n233#5:581\n233#5:602\n233#5:633\n59#6:582\n54#6:584\n59#6:586\n54#6:603\n59#6:605\n54#6:607\n59#6:609\n54#6:634\n59#6:636\n42#7,3:588\n46#7,3:592\n42#7,7:611\n42#7,7:638\n1#8:591\n56#9:595\n56#9:596\n61#9:618\n61#9:619\n30#10:620\n33#11:624\n*S KotlinDebug\n*F\n+ 1 Waveform.kt\nvet/inpulse/krafiks/Waveform\n*L\n361#1:571\n361#1:574\n369#1:576\n369#1:579\n418#1:597\n418#1:600\n505#1:628\n505#1:631\n361#1:572\n361#1:575\n369#1:577\n369#1:580\n396#1:583\n397#1:585\n398#1:587\n418#1:598\n418#1:601\n443#1:604\n444#1:606\n445#1:608\n446#1:610\n477#1:621,3\n478#1:625,3\n505#1:629\n505#1:632\n526#1:635\n527#1:637\n361#1:573\n369#1:578\n418#1:599\n505#1:630\n388#1:581\n436#1:602\n517#1:633\n396#1:582\n397#1:584\n398#1:586\n443#1:603\n444#1:605\n445#1:607\n446#1:609\n526#1:634\n527#1:636\n401#1:588,3\n401#1:592,3\n449#1:611,7\n530#1:638,7\n409#1:595\n410#1:596\n454#1:618\n455#1:619\n477#1:620\n478#1:624\n*E\n"})
public final class Waveform
implements KrafiksChart {
    @NotNull
    private final CircularFloatArray data;
    private float posX;
    private float posY;
    private float sizeX;
    private float sizeY;
    private boolean visible;
    private boolean clipBounds;
    private float valueMin;
    @NotNull
    private Float4 colorMin;
    private float valueMax;
    @NotNull
    private Float4 colorMax;
    private float thickness;
    private boolean filled;
    private float gain;
    @Nullable
    private Grid grid;
    @NotNull
    private WaveformDrawMode drawMode;
    private int cursorSize;
    private float dataOffsetY;
    @Nullable
    private WaveformLabel label;
    @Nullable
    private WaveformLegend legendX;
    @Nullable
    private WaveformLegend legendY;
    @NotNull
    private List<Markers<Object>> markers;
    @Nullable
    private Float graphOffsetX;
    @Nullable
    private Float graphOffsetY;
    private boolean debugBounds;
    private boolean debugLegend;
    public static final int $stable = 8;

    public Waveform(@NotNull CircularFloatArray data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.data = data;
        this.visible = true;
        this.colorMin = new Float4(0.0f, 0.0f, 0.0f, 1.0f);
        this.valueMax = 1.0f;
        this.colorMax = new Float4(0.0f, 0.0f, 0.0f, 1.0f);
        this.thickness = 2.0f;
        this.gain = 1.0f;
        this.drawMode = WaveformDrawMode.WIPE;
        this.markers = new ArrayList();
    }

    @NotNull
    public final CircularFloatArray getData() {
        return this.data;
    }

    public Waveform(int initialDataSize, int growthFactor) {
        this(new CircularFloatArray(initialDataSize, true, growthFactor));
    }

    public /* synthetic */ Waveform(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 10000;
        }
        if ((n3 & 2) != 0) {
            n2 = 2;
        }
        this(n, n2);
    }

    @Override
    public float getPosX() {
        return this.posX;
    }

    @Override
    public void setPosX(float f) {
        this.posX = f;
    }

    @Override
    public float getPosY() {
        return this.posY;
    }

    @Override
    public void setPosY(float f) {
        this.posY = f;
    }

    @Override
    public float getSizeX() {
        return this.sizeX;
    }

    @Override
    public void setSizeX(float f) {
        this.sizeX = f;
    }

    @Override
    public float getSizeY() {
        return this.sizeY;
    }

    @Override
    public void setSizeY(float f) {
        this.sizeY = f;
    }

    @Override
    public void setPosition(float x, float y) {
        this.setPosX(x);
        this.setPosY(y);
    }

    @Override
    public void setSize(float width, float height) {
        this.setSizeX(width);
        this.setSizeY(height);
    }

    @Override
    public boolean getVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public final boolean getClipBounds() {
        return this.clipBounds;
    }

    public final void setClipBounds(boolean bl) {
        this.clipBounds = bl;
    }

    public final float getValueMin() {
        return this.valueMin;
    }

    public final void setValueMin(float f) {
        this.valueMin = f;
    }

    @NotNull
    public final Float4 getColorMin() {
        return this.colorMin;
    }

    public final void setColorMin(@NotNull Float4 float4) {
        Intrinsics.checkNotNullParameter((Object)float4, (String)"<set-?>");
        this.colorMin = float4;
    }

    public final float getValueMax() {
        return this.valueMax;
    }

    public final void setValueMax(float f) {
        this.valueMax = f;
    }

    @NotNull
    public final Float4 getColorMax() {
        return this.colorMax;
    }

    public final void setColorMax(@NotNull Float4 float4) {
        Intrinsics.checkNotNullParameter((Object)float4, (String)"<set-?>");
        this.colorMax = float4;
    }

    public final float getThickness() {
        return this.thickness;
    }

    public final void setThickness(float f) {
        this.thickness = f;
    }

    public final boolean getFilled() {
        return this.filled;
    }

    public final void setFilled(boolean bl) {
        this.filled = bl;
    }

    public final float getGain() {
        return this.gain;
    }

    public final void setGain(float f) {
        this.gain = f;
    }

    @Nullable
    public final Grid getGrid() {
        return this.grid;
    }

    public final void setGrid(@Nullable Grid grid) {
        this.grid = grid;
    }

    @NotNull
    public final WaveformDrawMode getDrawMode() {
        return this.drawMode;
    }

    public final void setDrawMode(@NotNull WaveformDrawMode waveformDrawMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)waveformDrawMode), (String)"<set-?>");
        this.drawMode = waveformDrawMode;
    }

    public final int getCursorSize() {
        return this.cursorSize;
    }

    public final void setCursorSize(int n) {
        this.cursorSize = n;
    }

    public final float getDataOffsetY() {
        return this.dataOffsetY;
    }

    public final void setDataOffsetY(float f) {
        this.dataOffsetY = f;
    }

    @Override
    @Nullable
    public WaveformLabel getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(@Nullable WaveformLabel waveformLabel) {
        this.label = waveformLabel;
    }

    @Nullable
    public final WaveformLegend getLegendX() {
        return this.legendX;
    }

    public final void setLegendX(@Nullable WaveformLegend waveformLegend) {
        this.legendX = waveformLegend;
    }

    @Nullable
    public final WaveformLegend getLegendY() {
        return this.legendY;
    }

    public final void setLegendY(@Nullable WaveformLegend waveformLegend) {
        this.legendY = waveformLegend;
    }

    @NotNull
    public final List<Markers<Object>> getMarkers() {
        return this.markers;
    }

    public final void setMarkers(@NotNull List<Markers<Object>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.markers = list;
    }

    @Nullable
    public final Float getGraphOffsetX() {
        return this.graphOffsetX;
    }

    @Nullable
    public final Float getGraphOffsetY() {
        return this.graphOffsetY;
    }

    public final boolean getDebugBounds() {
        return this.debugBounds;
    }

    public final void setDebugBounds(boolean bl) {
        this.debugBounds = bl;
    }

    public final boolean getDebugLegend() {
        return this.debugLegend;
    }

    public final void setDebugLegend(boolean bl) {
        this.debugLegend = bl;
    }

    @NotNull
    public final Mat4 getModelMatrix() {
        int linesGraph = this.data.getMaxSize() - 1;
        Float f = this.graphOffsetX;
        float graphSizeX = this.getSizeX() - (f != null ? f.floatValue() : 0.0f);
        Float f2 = this.graphOffsetY;
        float graphSizeY = this.getSizeY() - (f2 != null ? f2.floatValue() : 0.0f);
        Float f3 = this.graphOffsetX;
        float graphX = this.getPosX() + (f3 != null ? f3.floatValue() : 0.0f);
        Float f4 = this.graphOffsetY;
        float graphY = this.getPosY() - (f4 != null ? f4.floatValue() : 0.0f) / 2.0f;
        return KotlinMathExtKt.translationAndScale$default((float)graphX, (float)(graphY + this.dataOffsetY), (float)0.0f, (float)(graphSizeX / (float)linesGraph), (float)(-Math.abs(graphSizeY) * Math.abs(this.gain)), (float)0.0f, (int)36, null);
    }

    public final void addMarker(@NotNull Markers<?> m) {
        Intrinsics.checkNotNullParameter(m, (String)"m");
        this.markers.add(m);
    }

    public final void clearMarkers() {
        this.markers.clear();
    }

    public final boolean isInView(@NotNull Camera camera) {
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        Rect waveRect = new Rect(this.getPosX(), this.getPosY() - this.getSizeY(), this.getPosX() + this.getSizeX(), this.getPosY() + this.getSizeY());
        return ComposeUtilsKt.isInView((Camera)camera, (Rect)waveRect);
    }

    public final int firstVisibleX(@NotNull Camera camera) {
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        int linesGraph = this.data.getMaxSize() - 1;
        Float f = this.graphOffsetX;
        float graphSizeX = this.getSizeX() - (f != null ? f.floatValue() : 0.0f);
        Float f2 = this.graphOffsetX;
        float graphX = this.getPosX() + (f2 != null ? f2.floatValue() : 0.0f);
        float firstXPx = camera.unproject(new Float2(0.0f, 0.0f)).getX();
        float ix = (float)linesGraph / graphSizeX;
        return RangesKt.coerceAtLeast((int)MathKt.roundToInt((float)((firstXPx - graphX) * ix)), (int)0);
    }

    public final int lastVisibleX(@NotNull Camera camera) {
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        int linesGraph = this.data.getMaxSize() - 1;
        Float f = this.graphOffsetX;
        float graphSizeX = this.getSizeX() - (f != null ? f.floatValue() : 0.0f);
        Float f2 = this.graphOffsetX;
        float graphX = this.getPosX() + (f2 != null ? f2.floatValue() : 0.0f);
        float lastXPx = camera.unproject(new Float2(-camera.getWidth(), 0.0f)).getX();
        float ix = (float)linesGraph / graphSizeX;
        return RangesKt.coerceAtMost((int)MathKt.roundToInt((float)((lastXPx - graphX) * ix)), (int)linesGraph);
    }

    public final void drawWaveform(@NotNull Camera camera, @NotNull Renderer renderer, @NotNull MeshCache meshCache) {
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)meshCache, (String)"meshCache");
        if (!this.getVisible()) {
            return;
        }
        if (this.legendY != null && this.graphOffsetX == null) {
            return;
        }
        if (this.legendX != null && this.graphOffsetY == null) {
            return;
        }
        int linesGraph = this.data.getMaxSize() - 1;
        if (linesGraph < 1) {
            return;
        }
        if (!this.isInView(camera)) {
            return;
        }
        Float f = this.graphOffsetX;
        float graphSizeX = this.getSizeX() - (f != null ? f.floatValue() : 0.0f);
        Float f2 = this.graphOffsetY;
        float graphSizeY = this.getSizeY() - (f2 != null ? f2.floatValue() : 0.0f);
        Float f3 = this.graphOffsetX;
        float graphX = this.getPosX() + (f3 != null ? f3.floatValue() : 0.0f);
        Float f4 = this.graphOffsetY;
        float graphY = this.getPosY() - (f4 != null ? f4.floatValue() : 0.0f) / 2.0f;
        float firstXPx = camera.unproject(new Float2(0.0f, 0.0f)).getX();
        float lastXPx = camera.unproject(new Float2(-camera.getWidth(), 0.0f)).getX();
        float ix = (float)linesGraph / graphSizeX;
        int firstXIndex = RangesKt.coerceAtLeast((int)MathKt.roundToInt((float)((firstXPx - graphX) * ix)), (int)0);
        int lastXIndex = RangesKt.coerceAtMost((int)MathKt.roundToInt((float)((lastXPx - graphX) * ix)), (int)linesGraph);
        if (lastXIndex - firstXIndex < 2) {
            return;
        }
        renderer.setMode(Renderer.Mode.LINE);
        if (this.debugBounds) {
            renderer.reset();
            renderer.setLineColorMin(new Float4(0.0f, 0.0f, 1.0f, 1.0f));
            renderer.setLineColorMax(new Float4(0.0f, 0.0f, 1.0f, 1.0f));
            Renderer.addPoint$default((Renderer)renderer, (float)graphX, (float)(graphY - graphSizeY), null, (float)0.0f, (int)12, null);
            Renderer.addPoint$default((Renderer)renderer, (float)(graphX + graphSizeX), (float)(graphY - graphSizeY), null, (float)0.0f, (int)12, null);
            Renderer.addPoint$default((Renderer)renderer, (float)(graphX + graphSizeX), (float)(graphY + graphSizeY), null, (float)0.0f, (int)12, null);
            Renderer.addPoint$default((Renderer)renderer, (float)graphX, (float)(graphY + graphSizeY), null, (float)0.0f, (int)12, null);
            Renderer.addPoint$default((Renderer)renderer, (float)graphX, (float)(graphY - graphSizeY), null, (float)0.0f, (int)12, null);
            renderer.render(camera, Mat4.Companion.identity());
        }
        boolean scissorEnabled = GLES_jvmKt.glIsEnabled((int)3089);
        if (this.clipBounds) {
            float scissorY = camera.getHeight() - graphY - Math.abs(graphSizeY) + camera.getEye().getY();
            float scissorMaxY = scissorY + Math.abs(graphSizeY) * 2.0f;
            float scissorHeight = RangesKt.coerceAtMost((float)((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(scissorMaxY), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)(Math.abs(graphSizeY) * 2.0f))))).floatValue(), (float)camera.getHeight());
            GLES_jvmKt.glEnable((int)3089);
            GLES_jvmKt.glScissor((int)0, (int)RangesKt.coerceAtLeast((int)MathKt.roundToInt((float)scissorY), (int)0), (int)MathKt.roundToInt((float)camera.getWidth()), (int)RangesKt.coerceAtLeast((int)MathKt.roundToInt((float)scissorHeight), (int)0));
        }
        renderer.reset();
        renderer.setLineValueMin(this.valueMin);
        renderer.setLineColorMin(this.colorMin);
        renderer.setLineValueMax(this.valueMax);
        renderer.setLineColorMax(this.colorMax);
        renderer.setLineThickness(this.thickness);
        renderer.setLineStrip(true);
        renderer.setLineCap(true);
        switch (WhenMappings.$EnumSwitchMapping$0[this.drawMode.ordinal()]) {
            case 1: {
                this.drawWipeMode(camera, renderer, this.getModelMatrix(), firstXIndex, lastXIndex);
                break;
            }
            case 2: {
                this.drawScrollMode(camera, renderer, this.getModelMatrix(), firstXIndex, lastXIndex);
                break;
            }
            case 3: {
                this.drawStaticMode(camera, renderer, this.getModelMatrix(), firstXIndex, lastXIndex, meshCache);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (this.clipBounds && !scissorEnabled) {
            GLES_jvmKt.glDisable((int)3089);
        }
        renderer.reset();
    }

    public final void drawWipeMode(@NotNull Camera camera, @NotNull Renderer renderer, @NotNull Mat4 model, int firstX, int lastX) {
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        IntRange limits = new IntRange(firstX, lastX);
        this.data.data((arg_0, arg_1, arg_2, arg_3, arg_4) -> Waveform.drawWipeMode$lambda$0(this, renderer, limits, camera, model, arg_0, arg_1, arg_2, arg_3, arg_4));
    }

    public final void drawScrollMode(@NotNull Camera camera, @NotNull Renderer renderer, @NotNull Mat4 model, int firstX, int lastX) {
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        IntRange limits = new IntRange(firstX, lastX);
        this.data.data((arg_0, arg_1, arg_2, arg_3, arg_4) -> Waveform.drawScrollMode$lambda$1(this, renderer, limits, camera, model, arg_0, arg_1, arg_2, arg_3, arg_4));
    }

    private final int handleFromData(CircularFloatArray circularFloatArray) {
        int result = circularFloatArray.getPersistentHandle();
        result = 31 * result + circularFloatArray.getTotalData();
        return result;
    }

    public final void drawStaticMode(@NotNull Camera camera, @NotNull Renderer renderer, @NotNull Mat4 model, int firstX, int lastX, @NotNull MeshCache meshCache) {
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)meshCache, (String)"meshCache");
        int handle = this.handleFromData(this.data);
        Mesh mesh = meshCache.getOrCreateMesh(handle, () -> Waveform.drawStaticMode$lambda$5(this));
        renderer.renderWaveform(camera, model, mesh, firstX, lastX - firstX);
    }

    public final void drawLegend(@NotNull DrawScope scope, @NotNull TextMeasurer textMeasurer, @NotNull Camera camera) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
                Intrinsics.checkNotNullParameter((Object)textMeasurer, (String)"textMeasurer");
                Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
                long arg0$iv = scope.getSize-NH-jbRc();
                boolean bl = false;
                long value$iv$iv = arg0$iv;
                boolean $i$f$unpackFloat1 = false;
                int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
                boolean $i$f$floatFromBits = false;
                if (Float.intBitsToFloat(bits$iv$iv$iv) <= 0.0f) break block2;
                arg0$iv = scope.getSize-NH-jbRc();
                boolean bl2 = false;
                value$iv$iv = arg0$iv;
                boolean $i$f$unpackFloat2 = false;
                bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
                $i$f$floatFromBits = false;
                if (!(Float.intBitsToFloat(bits$iv$iv$iv) <= 0.0f)) break block3;
            }
            return;
        }
        this.drawLegendX(scope, textMeasurer, camera);
        this.drawLegendY(scope, textMeasurer, camera);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void drawLegendY(@NotNull DrawScope scope, @NotNull TextMeasurer textMeasurer, @NotNull Camera camera) {
        block15: {
            block14: {
                Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
                Intrinsics.checkNotNullParameter((Object)textMeasurer, (String)"textMeasurer");
                Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
                long arg0$iv = scope.getSize-NH-jbRc();
                boolean bl = false;
                long value$iv$iv = arg0$iv;
                boolean $i$f$unpackFloat1 = false;
                int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
                boolean $i$f$floatFromBits = false;
                if (Float.intBitsToFloat(bits$iv$iv$iv) <= 0.0f) break block14;
                arg0$iv = scope.getSize-NH-jbRc();
                boolean bl2 = false;
                value$iv$iv = arg0$iv;
                boolean $i$f$unpackFloat2 = false;
                bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
                $i$f$floatFromBits = false;
                if (!(Float.intBitsToFloat(bits$iv$iv$iv) <= 0.0f)) break block15;
            }
            return;
        }
        WaveformLegend waveformLegend = this.legendY;
        if (waveformLegend == null) {
            return;
        }
        WaveformLegend legendY = waveformLegend;
        if (legendY.getLegend().isEmpty()) {
            this.graphOffsetX = Float.valueOf(0.0f);
            return;
        }
        float newGraphOffsetX = 0.0f;
        float step = legendY.getLegend().size() == 1 ? 0.0f : this.getSizeY() * (float)2 / (float)(legendY.getLegend().size() - 1);
        Iterator iterator = ((Iterable)legendY.getLegend()).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            String legend = (String)iterator.next();
            float x = this.getPosX();
            float y = this.getPosY() - this.getSizeY() + (float)i * step;
            DrawScope $this$drawIntoCanvas$iv = scope;
            boolean $i$f$drawIntoCanvas = false;
            Canvas it = $this$drawIntoCanvas$iv.getDrawContext().getCanvas();
            boolean bl = false;
            TextStyle textStyle = legendY.getTextStyle();
            if (textStyle == null) {
                textStyle = TextStyle.Companion.getDefault();
            }
            TextLayoutResult measurement = TextMeasurer.measure-wNUYSr0$default((TextMeasurer)textMeasurer, (String)legend, (TextStyle)textStyle, (int)0, (boolean)false, (int)1, (long)0L, null, null, null, (boolean)false, (int)1004, null);
            long arg0$iv = measurement.getSize-YbymL2g();
            boolean bl3 = false;
            long value$iv$iv = arg0$iv;
            boolean $i$f$unpackInt2 = false;
            float f = y - (float)((int)(value$iv$iv & 0xFFFFFFFFL)) / 2.0f;
            arg0$iv = measurement.getSize-YbymL2g();
            boolean bl4 = false;
            value$iv$iv = arg0$iv;
            boolean $i$f$unpackInt1 = false;
            float f2 = x + (float)((int)(value$iv$iv >> 32));
            arg0$iv = measurement.getSize-YbymL2g();
            bl3 = false;
            value$iv$iv = arg0$iv;
            $i$f$unpackInt2 = false;
            float f3 = y + (float)((int)(value$iv$iv & 0xFFFFFFFFL));
            arg0$iv = measurement.getSize-YbymL2g();
            bl3 = false;
            value$iv$iv = arg0$iv;
            $i$f$unpackInt2 = false;
            Rect textRect = new Rect(x, f, f2, f3 - (float)((int)(value$iv$iv & 0xFFFFFFFFL)) / 2.0f);
            if (ComposeUtilsKt.isInView((Camera)camera, (Rect)textRect)) {
                Canvas $this$withSave$iv = it;
                boolean $i$f$withSave = false;
                try {
                    $this$withSave$iv.save();
                    boolean bl5 = false;
                    it.translate(textRect.getLeft() - camera.getEye().getX(), textRect.getTop() - camera.getEye().getY());
                    if (this.debugLegend) {
                        void $this$drawLegendY_u24lambda_u248_u24lambda_u247_u24lambda_u246;
                        Paint paint;
                        Paint paint2 = paint = SkiaBackedPaint_skikoKt.Paint();
                        Rect rect = textRect;
                        Canvas canvas = it;
                        boolean bl6 = false;
                        $this$drawLegendY_u24lambda_u248_u24lambda_u247_u24lambda_u246.setColor-8_81llA(Color.Companion.getCyan-0d7_KjU());
                        Unit unit = Unit.INSTANCE;
                        canvas.drawRect(rect, paint);
                    }
                    MultiParagraph multiParagraph = measurement.getMultiParagraph();
                    TextStyle textStyle2 = legendY.getTextStyle();
                    if (textStyle2 == null || (textStyle2 = textStyle2.getDrawStyle()) == null) {
                        textStyle2 = (DrawStyle)Fill.INSTANCE;
                    }
                    MultiParagraph.paint-LG529CI$default((MultiParagraph)multiParagraph, (Canvas)it, (long)0L, null, null, (DrawStyle)textStyle2, (int)0, (int)46, null);
                }
                finally {
                    $this$withSave$iv.restore();
                }
            }
            Rect this_$iv = textRect;
            boolean $i$f$getWidth = false;
            if (!(this_$iv.getRight() - this_$iv.getLeft() > newGraphOffsetX)) continue;
            this_$iv = textRect;
            $i$f$getWidth = false;
            newGraphOffsetX = this_$iv.getRight() - this_$iv.getLeft();
        }
        this.graphOffsetX = Float.valueOf(newGraphOffsetX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void drawLegendX(@NotNull DrawScope scope, @NotNull TextMeasurer textMeasurer, @NotNull Camera camera) {
        block14: {
            block13: {
                Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
                Intrinsics.checkNotNullParameter((Object)textMeasurer, (String)"textMeasurer");
                Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
                long arg0$iv = scope.getSize-NH-jbRc();
                boolean bl = false;
                long value$iv$iv = arg0$iv;
                boolean $i$f$unpackFloat1 = false;
                int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
                boolean $i$f$floatFromBits = false;
                if (Float.intBitsToFloat(bits$iv$iv$iv) <= 0.0f) break block13;
                arg0$iv = scope.getSize-NH-jbRc();
                boolean bl2 = false;
                value$iv$iv = arg0$iv;
                boolean $i$f$unpackFloat2 = false;
                bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
                $i$f$floatFromBits = false;
                if (!(Float.intBitsToFloat(bits$iv$iv$iv) <= 0.0f)) break block14;
            }
            return;
        }
        WaveformLegend waveformLegend = this.legendX;
        if (waveformLegend == null) {
            return;
        }
        WaveformLegend legendX = waveformLegend;
        if (legendX.getLegend().isEmpty()) {
            this.graphOffsetY = Float.valueOf(0.0f);
            return;
        }
        float newGraphOffsetY = 0.0f;
        float step = legendX.getLegend().size() > 1 ? this.getSizeX() / (float)(legendX.getLegend().size() - 1) : 0.0f;
        Iterator iterator = ((Iterable)legendX.getLegend()).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            String legend = (String)iterator.next();
            float x = this.getPosX() + (float)i * step;
            float y = this.getPosY() + this.getSizeY();
            DrawScope $this$drawIntoCanvas$iv = scope;
            boolean $i$f$drawIntoCanvas = false;
            Canvas it = $this$drawIntoCanvas$iv.getDrawContext().getCanvas();
            boolean bl = false;
            TextStyle textStyle = legendX.getTextStyle();
            if (textStyle == null) {
                textStyle = TextStyle.Companion.getDefault();
            }
            TextLayoutResult measurement = TextMeasurer.measure-wNUYSr0$default((TextMeasurer)textMeasurer, (String)legend, (TextStyle)textStyle, (int)0, (boolean)false, (int)1, (long)0L, null, null, null, (boolean)false, (int)1004, null);
            long arg0$iv = measurement.getSize-YbymL2g();
            boolean bl3 = false;
            long value$iv$iv = arg0$iv;
            boolean $i$f$unpackInt1 = false;
            float f = x - (float)((int)(value$iv$iv >> 32)) / 2.0f;
            arg0$iv = measurement.getSize-YbymL2g();
            boolean bl4 = false;
            value$iv$iv = arg0$iv;
            boolean $i$f$unpackInt2 = false;
            float f2 = y - (float)((int)(value$iv$iv & 0xFFFFFFFFL)) / 2.0f;
            arg0$iv = measurement.getSize-YbymL2g();
            bl3 = false;
            value$iv$iv = arg0$iv;
            $i$f$unpackInt1 = false;
            float f3 = x + (float)((int)(value$iv$iv >> 32));
            arg0$iv = measurement.getSize-YbymL2g();
            bl4 = false;
            value$iv$iv = arg0$iv;
            $i$f$unpackInt2 = false;
            Rect textRect = new Rect(f, f2, f3, y + (float)((int)(value$iv$iv & 0xFFFFFFFFL)));
            if (ComposeUtilsKt.isInView((Camera)camera, (Rect)textRect)) {
                Canvas $this$withSave$iv = it;
                boolean $i$f$withSave = false;
                try {
                    $this$withSave$iv.save();
                    boolean bl5 = false;
                    it.translate(textRect.getLeft() - camera.getEye().getX(), textRect.getTop() - camera.getEye().getY());
                    MultiParagraph multiParagraph = measurement.getMultiParagraph();
                    TextStyle textStyle2 = legendX.getTextStyle();
                    if (textStyle2 == null || (textStyle2 = textStyle2.getDrawStyle()) == null) {
                        textStyle2 = (DrawStyle)Fill.INSTANCE;
                    }
                    MultiParagraph.paint-LG529CI$default((MultiParagraph)multiParagraph, (Canvas)it, (long)0L, null, null, (DrawStyle)textStyle2, (int)0, (int)46, null);
                }
                finally {
                    $this$withSave$iv.restore();
                }
            }
            Rect this_$iv = textRect;
            boolean $i$f$getHeight = false;
            if (!(this_$iv.getBottom() - this_$iv.getTop() > newGraphOffsetY)) continue;
            this_$iv = textRect;
            $i$f$getHeight = false;
            newGraphOffsetY = this_$iv.getBottom() - this_$iv.getTop();
        }
        this.graphOffsetY = Float.valueOf(0.0f);
    }

    public final float indexToY(int index) {
        return this.getModelMatrix().times(new Float4((float)index, this.data.getStorage()[index], 0.0f, 1.0f)).getY();
    }

    public final float indexToX(int index) {
        return this.getModelMatrix().times(new Float4((float)index, 0.0f, 0.0f, 1.0f)).getX();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<Offset, Size> indexArea(int startX, int endX, @NotNull Camera camera) {
        void width$iv;
        void x$iv;
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        float x1 = this.indexToX(startX);
        float x2 = this.indexToX(endX);
        Float f = this.graphOffsetY;
        float graphSizeY = Math.abs(this.getSizeY()) * 2.0f - (f != null ? f.floatValue() : 0.0f);
        Float f2 = this.graphOffsetY;
        float graphY = this.getPosY() - (f2 != null ? f2.floatValue() : 0.0f);
        float f3 = x1;
        float y$iv = graphY - graphSizeY / 2.0f - camera.getEye().getY();
        boolean $i$f$Offset22 = false;
        boolean $i$f$packFloats = false;
        long v1$iv$iv = Float.floatToRawIntBits((float)x$iv);
        long v2$iv$iv = Float.floatToRawIntBits(y$iv);
        long offset = Offset.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
        float $i$f$Offset22 = x2 - x1;
        float height$iv = graphSizeY;
        boolean $i$f$Size = false;
        boolean $i$f$packFloats2 = false;
        long v1$iv$iv2 = Float.floatToRawIntBits((float)width$iv);
        long v2$iv$iv2 = Float.floatToRawIntBits(height$iv);
        long size = Size.constructor-impl((long)(v1$iv$iv2 << 32 | v2$iv$iv2 & 0xFFFFFFFFL));
        return new Pair((Object)Offset.box-impl((long)offset), (Object)Size.box-impl((long)size));
    }

    public final void drawGlMarkers(@NotNull Renderer renderer, @NotNull Camera camera) {
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        for (Markers<Object> m : this.markers) {
            MarkerDrawer<Object> drawer = m.getDrawer();
            if (drawer instanceof MarkerDrawer.GlDrawer) {
                ((MarkerDrawer.GlDrawer)drawer).drawMarkers(renderer, this, m.getMarkers(), camera);
                continue;
            }
            if (drawer instanceof MarkerDrawer.ComposeDrawer) continue;
            throw new NoWhenBranchMatchedException();
        }
    }

    public final void drawComposeMarkers(@NotNull DrawScope drawScope, @NotNull Camera camera) {
        Intrinsics.checkNotNullParameter((Object)drawScope, (String)"drawScope");
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        for (Markers<Object> m : this.markers) {
            MarkerDrawer<Object> drawer = m.getDrawer();
            if (drawer instanceof MarkerDrawer.ComposeDrawer) {
                ((MarkerDrawer.ComposeDrawer)drawer).drawMarkers(drawScope, this, m.getMarkers(), camera);
                continue;
            }
            if (drawer instanceof MarkerDrawer.GlDrawer) continue;
            throw new NoWhenBranchMatchedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void drawLabel(@NotNull DrawScope scope, @NotNull TextMeasurer textMeasurer, @NotNull Camera camera) {
        block13: {
            block12: {
                Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
                Intrinsics.checkNotNullParameter((Object)textMeasurer, (String)"textMeasurer");
                Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
                long arg0$iv = scope.getSize-NH-jbRc();
                boolean bl = false;
                long value$iv$iv = arg0$iv;
                boolean $i$f$unpackFloat1 = false;
                int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
                boolean $i$f$floatFromBits = false;
                if (Float.intBitsToFloat(bits$iv$iv$iv) <= 0.0f) break block12;
                arg0$iv = scope.getSize-NH-jbRc();
                boolean bl2 = false;
                value$iv$iv = arg0$iv;
                boolean $i$f$unpackFloat2 = false;
                bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
                $i$f$floatFromBits = false;
                if (!(Float.intBitsToFloat(bits$iv$iv$iv) <= 0.0f)) break block13;
            }
            return;
        }
        WaveformLabel waveformLabel = this.getLabel();
        if (waveformLabel == null) {
            return;
        }
        WaveformLabel label = waveformLabel;
        if (StringsKt.isBlank((CharSequence)label.getLabel())) {
            return;
        }
        float x = this.getPosX() + label.getTopLeftOffsetX();
        float y = this.getPosY() - this.getSizeY() - camera.getEye().getY() + label.getTopLeftOffsetY();
        DrawScope $this$drawIntoCanvas$iv = scope;
        boolean $i$f$drawIntoCanvas = false;
        Canvas it = $this$drawIntoCanvas$iv.getDrawContext().getCanvas();
        boolean bl = false;
        String string = label.getLabel();
        TextStyle textStyle = label.getTextStyle();
        if (textStyle == null) {
            textStyle = TextStyle.Companion.getDefault();
        }
        TextLayoutResult measurement = TextMeasurer.measure-wNUYSr0$default((TextMeasurer)textMeasurer, (String)string, (TextStyle)textStyle, (int)0, (boolean)false, (int)1, (long)0L, null, null, null, (boolean)false, (int)1004, null);
        long arg0$iv = measurement.getSize-YbymL2g();
        boolean bl3 = false;
        long value$iv$iv = arg0$iv;
        boolean $i$f$unpackInt1 = false;
        float f = x + (float)((int)(value$iv$iv >> 32));
        arg0$iv = measurement.getSize-YbymL2g();
        boolean bl4 = false;
        value$iv$iv = arg0$iv;
        boolean $i$f$unpackInt2 = false;
        Rect textRect = new Rect(x, y, f, y + (float)((int)(value$iv$iv & 0xFFFFFFFFL)));
        if (ComposeUtilsKt.isInView((Camera)camera, (Rect)textRect)) {
            Canvas $this$withSave$iv = it;
            boolean $i$f$withSave = false;
            try {
                $this$withSave$iv.save();
                boolean bl5 = false;
                it.translate(textRect.getLeft(), textRect.getTop());
                MultiParagraph multiParagraph = measurement.getMultiParagraph();
                TextStyle textStyle2 = label.getTextStyle();
                if (textStyle2 == null || (textStyle2 = textStyle2.getDrawStyle()) == null) {
                    textStyle2 = (DrawStyle)Fill.INSTANCE;
                }
                MultiParagraph.paint-LG529CI$default((MultiParagraph)multiParagraph, (Canvas)it, (long)0L, null, null, (DrawStyle)textStyle2, (int)0, (int)46, null);
            }
            finally {
                $this$withSave$iv.restore();
            }
        }
    }

    public final void drawGrid(@NotNull Camera camera, @NotNull Renderer lineRenderer) {
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        Intrinsics.checkNotNullParameter((Object)lineRenderer, (String)"lineRenderer");
        Grid grid = this.grid;
        if (grid == null) {
            return;
        }
        Grid grid2 = grid;
        if (grid2.getDivsXPx() < 1.0f || grid2.getDivsYPx() < 1.0f) {
            return;
        }
        Float f = this.graphOffsetX;
        float graphSizeX = this.getSizeX() - (f != null ? f.floatValue() : 0.0f);
        Float f2 = this.graphOffsetY;
        float graphSizeY = Math.abs(this.getSizeY()) - (f2 != null ? f2.floatValue() : 0.0f);
        Float f3 = this.graphOffsetX;
        float graphX = this.getPosX() + (f3 != null ? f3.floatValue() : 0.0f);
        Float f4 = this.graphOffsetY;
        float graphY = this.getPosY() - (f4 != null ? f4.floatValue() : 0.0f) / 2.0f;
        lineRenderer.renderGrid(camera, graphX, graphY - graphSizeY, graphSizeX, graphSizeY * 2.0f, grid2.getDivsXPx(), this.dataOffsetY * (float)2, grid2.getThickness(), grid2.getColorMinor(), grid2.getColorMajor());
    }

    private static final void drawWipeMode$lambda$0(Waveform this$0, Renderer $renderer, IntRange $limits, Camera $camera, Mat4 $model, float[] d, int fo, int fl, int so, int sl) {
        int n;
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        if (this$0.filled) {
            $renderer.setMode(Renderer.Mode.LINE_FILLED);
        } else {
            $renderer.setMode(Renderer.Mode.LINE);
        }
        if (fl > 2) {
            int firstFirst = sl > 0 ? RangesKt.coerceAtLeast((int)(this$0.cursorSize - sl), (int)0) : 0;
            n = fo + fl;
            for (int i = fo + firstFirst; i < n; ++i) {
                int n2 = $limits.getFirst();
                boolean bl = i <= $limits.getLast() ? n2 <= i : false;
                if (!bl) continue;
                Renderer.addPoint$default((Renderer)$renderer, (float)i, (float)d[i], null, (float)0.0f, (int)12, null);
            }
            $renderer.render($camera, $model);
            $renderer.reset();
        }
        if (sl > 2 && sl > this$0.cursorSize) {
            int n3 = so + sl;
            for (int i = so + this$0.cursorSize; i < n3; ++i) {
                n = $limits.getFirst();
                boolean bl = i <= $limits.getLast() ? n <= i : false;
                if (!bl) continue;
                Renderer.addPoint$default((Renderer)$renderer, (float)i, (float)d[i], null, (float)0.0f, (int)12, null);
            }
            $renderer.render($camera, $model);
        }
    }

    private static final void drawScrollMode$lambda$1(Waveform this$0, Renderer $renderer, IntRange $limits, Camera $camera, Mat4 $model, float[] d, int fo, int fl, int so, int sl) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        int totalPoints = fl + sl;
        if (totalPoints < 2) {
            return;
        }
        if (this$0.filled) {
            $renderer.setMode(Renderer.Mode.LINE_FILLED);
        } else {
            $renderer.setMode(Renderer.Mode.LINE);
        }
        for (int i = 0; i < totalPoints; ++i) {
            float f;
            int xi = totalPoints - i - 1;
            int n = $limits.getFirst();
            boolean bl = xi <= $limits.getLast() ? n <= xi : false;
            if (!bl) continue;
            float x = xi;
            if (i < fl) {
                offset = fo + fl - i - 1;
                f = d[offset];
            } else {
                if (sl <= 0) break;
                offset = so + sl - (i - fl) - 1;
                f = d[offset];
            }
            float y = f;
            Renderer.addPoint$default((Renderer)$renderer, (float)x, (float)y, null, (float)0.0f, (int)12, null);
        }
        $renderer.render($camera, $model);
    }

    private static final Unit drawStaticMode$lambda$5$lambda$2(LayoutBuilder $this$bufferLayout) {
        Intrinsics.checkNotNullParameter((Object)$this$bufferLayout, (String)"$this$bufferLayout");
        $this$bufferLayout.positionX();
        return Unit.INSTANCE;
    }

    private static final Unit drawStaticMode$lambda$5$lambda$3(LayoutBuilder $this$bufferLayout) {
        Intrinsics.checkNotNullParameter((Object)$this$bufferLayout, (String)"$this$bufferLayout");
        $this$bufferLayout.positionY();
        return Unit.INSTANCE;
    }

    private static final void drawStaticMode$lambda$5$lambda$4(Mesh $mesh, float[] d, int n, int fl, int n2, int sl) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        float[] indices = new float[fl + sl];
        int n3 = indices.length;
        for (int i = 0; i < n3; ++i) {
            indices[i] = i;
        }
        Mesh.bufferData$default((Mesh)$mesh, (int)0, (float[])indices, (int)0, (int)0, (int)0, (int)28, null);
        Mesh.bufferData$default((Mesh)$mesh, (int)1, (float[])d, (int)0, (int)(fl + sl), (int)0, (int)20, null);
    }

    private static final Mesh drawStaticMode$lambda$5(Waveform this$0) {
        VertexBufferLayout[] vertexBufferLayoutArray = new VertexBufferLayout[]{VertexBufferLayoutKt.bufferLayout(Waveform::drawStaticMode$lambda$5$lambda$2), VertexBufferLayoutKt.bufferLayout(Waveform::drawStaticMode$lambda$5$lambda$3)};
        Mesh mesh = new Mesh.Builder().layout(vertexBufferLayoutArray).primitive(4).build();
        this$0.data.data((arg_0, arg_1, arg_2, arg_3, arg_4) -> Waveform.drawStaticMode$lambda$5$lambda$4(mesh, arg_0, arg_1, arg_2, arg_3, arg_4));
        return mesh;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WaveformDrawMode.values().length];
            try {
                nArray[WaveformDrawMode.WIPE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WaveformDrawMode.SCROLL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WaveformDrawMode.STATIC.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

