/*
 * Decompiled with CFR 0.152.
 */
package com.github.panpf.zoomimage.util;

import com.github.panpf.zoomimage.util.Core_utils_commonKt;
import com.github.panpf.zoomimage.util.OffsetCompat;
import com.github.panpf.zoomimage.util.OffsetCompatKt;
import com.github.panpf.zoomimage.util.SizeCompatKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b$\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u0000 K2\u00020\u0001:\u0001KB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0016\u0010\u001b\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0003J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0003J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0000J\u000e\u0010'\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u0000J\u0018\u0010>\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0086\u0002\u00a2\u0006\u0004\b?\u0010@J\b\u0010A\u001a\u00020BH\u0016J\t\u0010C\u001a\u00020\u0003H\u00c6\u0003J\t\u0010D\u001a\u00020\u0003H\u00c6\u0003J\t\u0010E\u001a\u00020\u0003H\u00c6\u0003J\t\u0010F\u001a\u00020\u0003H\u00c6\u0003J1\u0010G\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010H\u001a\u00020\u00172\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010I\u001a\u00020JH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u000e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\nR\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\nR\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0018R\u0011\u0010\u001a\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0011\u0010(\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\nR\u0011\u0010*\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\nR\u0011\u0010,\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0015R\u0011\u0010.\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0015R\u0011\u00100\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0015R\u0011\u00102\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0015R\u0011\u00104\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u0015R\u0011\u00106\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u0015R\u0011\u00108\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u0015R\u0011\u0010:\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b;\u0010\u0015R\u0011\u0010<\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b=\u0010\u0015\u00a8\u0006L"}, d2={"Lcom/github/panpf/zoomimage/util/RectCompat;", "", "left", "", "top", "right", "bottom", "<init>", "(FFFF)V", "getLeft", "()F", "getTop", "getRight", "getBottom", "width", "getWidth", "height", "getHeight", "size", "Lcom/github/panpf/zoomimage/util/SizeCompat;", "getSize-eGdS8bc", "()J", "isInfinite", "", "()Z", "isFinite", "isEmpty", "translate", "offset", "Lcom/github/panpf/zoomimage/util/OffsetCompat;", "translate-qkGJC9g", "(J)Lcom/github/panpf/zoomimage/util/RectCompat;", "translateX", "translateY", "inflate", "delta", "deflate", "intersect", "other", "overlaps", "minDimension", "getMinDimension", "maxDimension", "getMaxDimension", "topLeft", "getTopLeft-TU8dGBY", "topCenter", "getTopCenter-TU8dGBY", "topRight", "getTopRight-TU8dGBY", "centerLeft", "getCenterLeft-TU8dGBY", "center", "getCenter-TU8dGBY", "centerRight", "getCenterRight-TU8dGBY", "bottomLeft", "getBottomLeft-TU8dGBY", "bottomCenter", "getBottomCenter-TU8dGBY", "bottomRight", "getBottomRight-TU8dGBY", "contains", "contains-qkGJC9g", "(J)Z", "toString", "", "component1", "component2", "component3", "component4", "copy", "equals", "hashCode", "", "Companion", "zoomimage-core"})
public final class RectCompat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float left;
    private final float top;
    private final float right;
    private final float bottom;
    @NotNull
    private static final RectCompat Zero = new RectCompat(0.0f, 0.0f, 0.0f, 0.0f);

    public RectCompat(float left, float top, float right, float bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
    }

    public final float getLeft() {
        return this.left;
    }

    public final float getTop() {
        return this.top;
    }

    public final float getRight() {
        return this.right;
    }

    public final float getBottom() {
        return this.bottom;
    }

    public final float getWidth() {
        return this.right - this.left;
    }

    public final float getHeight() {
        return this.bottom - this.top;
    }

    public final long getSize-eGdS8bc() {
        return SizeCompatKt.SizeCompat(this.getWidth(), this.getHeight());
    }

    public final boolean isInfinite() {
        return this.left >= Float.POSITIVE_INFINITY || this.top >= Float.POSITIVE_INFINITY || this.right >= Float.POSITIVE_INFINITY || this.bottom >= Float.POSITIVE_INFINITY;
    }

    public final boolean isFinite() {
        return Math.abs(this.left) <= Float.MAX_VALUE && Math.abs(this.top) <= Float.MAX_VALUE && Math.abs(this.right) <= Float.MAX_VALUE && Math.abs(this.bottom) <= Float.MAX_VALUE;
    }

    public final boolean isEmpty() {
        return this.left >= this.right || this.top >= this.bottom;
    }

    @NotNull
    public final RectCompat translate-qkGJC9g(long offset2) {
        return new RectCompat(this.left + OffsetCompat.getX-impl(offset2), this.top + OffsetCompat.getY-impl(offset2), this.right + OffsetCompat.getX-impl(offset2), this.bottom + OffsetCompat.getY-impl(offset2));
    }

    @NotNull
    public final RectCompat translate(float translateX, float translateY) {
        return new RectCompat(this.left + translateX, this.top + translateY, this.right + translateX, this.bottom + translateY);
    }

    @NotNull
    public final RectCompat inflate(float delta) {
        return new RectCompat(this.left - delta, this.top - delta, this.right + delta, this.bottom + delta);
    }

    @NotNull
    public final RectCompat deflate(float delta) {
        return this.inflate(-delta);
    }

    @NotNull
    public final RectCompat intersect(@NotNull RectCompat other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new RectCompat(Math.max(this.left, other.left), Math.max(this.top, other.top), Math.min(this.right, other.right), Math.min(this.bottom, other.bottom));
    }

    public final boolean overlaps(@NotNull RectCompat other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.right <= other.left || other.right <= this.left) {
            return false;
        }
        return !(this.bottom <= other.top) && !(other.bottom <= this.top);
    }

    public final float getMinDimension() {
        return Math.min(Math.abs(this.getWidth()), Math.abs(this.getHeight()));
    }

    public final float getMaxDimension() {
        return Math.max(Math.abs(this.getWidth()), Math.abs(this.getHeight()));
    }

    public final long getTopLeft-TU8dGBY() {
        return OffsetCompatKt.OffsetCompat(this.left, this.top);
    }

    public final long getTopCenter-TU8dGBY() {
        return OffsetCompatKt.OffsetCompat(this.left + this.getWidth() / 2.0f, this.top);
    }

    public final long getTopRight-TU8dGBY() {
        return OffsetCompatKt.OffsetCompat(this.right, this.top);
    }

    public final long getCenterLeft-TU8dGBY() {
        return OffsetCompatKt.OffsetCompat(this.left, this.top + this.getHeight() / 2.0f);
    }

    public final long getCenter-TU8dGBY() {
        return OffsetCompatKt.OffsetCompat(this.left + this.getWidth() / 2.0f, this.top + this.getHeight() / 2.0f);
    }

    public final long getCenterRight-TU8dGBY() {
        return OffsetCompatKt.OffsetCompat(this.right, this.top + this.getHeight() / 2.0f);
    }

    public final long getBottomLeft-TU8dGBY() {
        return OffsetCompatKt.OffsetCompat(this.left, this.bottom);
    }

    public final long getBottomCenter-TU8dGBY() {
        return OffsetCompatKt.OffsetCompat(this.left + this.getWidth() / 2.0f, this.bottom);
    }

    public final long getBottomRight-TU8dGBY() {
        return OffsetCompatKt.OffsetCompat(this.right, this.bottom);
    }

    public final boolean contains-qkGJC9g(long offset2) {
        return OffsetCompat.getX-impl(offset2) >= this.left && OffsetCompat.getX-impl(offset2) < this.right && OffsetCompat.getY-impl(offset2) >= this.top && OffsetCompat.getY-impl(offset2) < this.bottom;
    }

    @NotNull
    public String toString() {
        return "RectCompat.fromLTRB(" + Core_utils_commonKt.toStringAsFixed(this.left, 1) + ", " + Core_utils_commonKt.toStringAsFixed(this.top, 1) + ", " + Core_utils_commonKt.toStringAsFixed(this.right, 1) + ", " + Core_utils_commonKt.toStringAsFixed(this.bottom, 1) + ')';
    }

    public final float component1() {
        return this.left;
    }

    public final float component2() {
        return this.top;
    }

    public final float component3() {
        return this.right;
    }

    public final float component4() {
        return this.bottom;
    }

    @NotNull
    public final RectCompat copy(float left, float top, float right, float bottom) {
        return new RectCompat(left, top, right, bottom);
    }

    public static /* synthetic */ RectCompat copy$default(RectCompat rectCompat, float f, float f2, float f3, float f4, int n, Object object) {
        if ((n & 1) != 0) {
            f = rectCompat.left;
        }
        if ((n & 2) != 0) {
            f2 = rectCompat.top;
        }
        if ((n & 4) != 0) {
            f3 = rectCompat.right;
        }
        if ((n & 8) != 0) {
            f4 = rectCompat.bottom;
        }
        return rectCompat.copy(f, f2, f3, f4);
    }

    public int hashCode() {
        int result = Float.hashCode(this.left);
        result = result * 31 + Float.hashCode(this.top);
        result = result * 31 + Float.hashCode(this.right);
        result = result * 31 + Float.hashCode(this.bottom);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RectCompat)) {
            return false;
        }
        RectCompat rectCompat = (RectCompat)other;
        if (Float.compare(this.left, rectCompat.left) != 0) {
            return false;
        }
        if (Float.compare(this.top, rectCompat.top) != 0) {
            return false;
        }
        if (Float.compare(this.right, rectCompat.right) != 0) {
            return false;
        }
        return Float.compare(this.bottom, rectCompat.bottom) == 0;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/github/panpf/zoomimage/util/RectCompat$Companion;", "", "<init>", "()V", "Zero", "Lcom/github/panpf/zoomimage/util/RectCompat;", "getZero", "()Lcom/github/panpf/zoomimage/util/RectCompat;", "zoomimage-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RectCompat getZero() {
            return Zero;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

