/*
 * Decompiled with CFR 0.152.
 */
package com.github.panpf.zoomimage.subsampling.internal;

import com.github.panpf.zoomimage.subsampling.SamplingTiles;
import com.github.panpf.zoomimage.subsampling.Tile;
import com.github.panpf.zoomimage.util.Core_utils_commonKt;
import com.github.panpf.zoomimage.util.IntOffsetCompat;
import com.github.panpf.zoomimage.util.IntOffsetCompatKt;
import com.github.panpf.zoomimage.util.IntRectCompat;
import com.github.panpf.zoomimage.util.IntRectCompatKt;
import com.github.panpf.zoomimage.util.IntSizeCompat;
import com.github.panpf.zoomimage.util.IntSizeCompatKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a'\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0006H\u0000\u001a3\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\fH\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a\u001f\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001a-\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001b\u001a%\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0000\u00a2\u0006\u0004\b\u001e\u0010\u001f\u001a/\u0010 \u001a\u00020!2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010#\u001a\u00020!H\u0000\u00a2\u0006\u0004\b$\u0010%\u00a8\u0006&"}, d2={"findSampleSize", "", "imageSize", "Lcom/github/panpf/zoomimage/util/IntSizeCompat;", "thumbnailSize", "scale", "", "findSampleSize-kjLh3nM", "(JJF)I", "closestPowerOfTwo", "number", "calculateGridSize", "Lcom/github/panpf/zoomimage/util/IntOffsetCompat;", "preferredTileSize", "sampleSize", "maxGridSize", "calculateGridSize-xojIVns", "(JJILcom/github/panpf/zoomimage/util/IntOffsetCompat;)J", "calculateMaxGridSize", "singleDirectionMaxTiles", "calculateMaxGridSize-wW3DvEY", "(JI)J", "calculateTiles", "", "Lcom/github/panpf/zoomimage/subsampling/Tile;", "gridSize", "calculateTiles-4uQ0JDQ", "(JJI)Ljava/util/List;", "calculateTileGridMap", "Lcom/github/panpf/zoomimage/subsampling/SamplingTiles;", "calculateTileGridMap-MEmoHmQ", "(JJ)Ljava/util/List;", "calculateImageLoadRect", "Lcom/github/panpf/zoomimage/util/IntRectCompat;", "contentSize", "contentVisibleRect", "calculateImageLoadRect-uV7mNCg", "(JJJLcom/github/panpf/zoomimage/util/IntRectCompat;)Lcom/github/panpf/zoomimage/util/IntRectCompat;", "zoomimage-core"})
@SourceDebugExtension(value={"SMAP\ntile_manages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 tile_manages.kt\ncom/github/panpf/zoomimage/subsampling/internal/Tile_managesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,219:1\n1#2:220\n*E\n"})
public final class Tile_managesKt {
    public static final int findSampleSize-kjLh3nM(long imageSize, long thumbnailSize, float scale2) {
        if (IntSizeCompatKt.isEmpty-grz_zgQ(imageSize) || IntSizeCompatKt.isEmpty-grz_zgQ(thumbnailSize) || scale2 <= 0.0f) {
            return 0;
        }
        float scaledFactor = Core_utils_commonKt.format((float)IntSizeCompat.getWidth-impl(imageSize) / ((float)IntSizeCompat.getWidth-impl(thumbnailSize) * scale2), 1);
        int sampleSize = Tile_managesKt.closestPowerOfTwo(scaledFactor);
        int limitedSampleSize = RangesKt.coerceAtLeast((int)sampleSize, (int)1);
        return limitedSampleSize;
    }

    public static final int closestPowerOfTwo(float number) {
        float logValue = MathKt.log2((float)number);
        int closestInteger = MathKt.roundToInt((float)logValue);
        double powerOfTwo = Math.pow(2.0, closestInteger);
        return (int)powerOfTwo;
    }

    public static final long calculateGridSize-xojIVns(long imageSize, long preferredTileSize, int sampleSize, @Nullable IntOffsetCompat maxGridSize) {
        float sampledWidth = (float)IntSizeCompat.getWidth-impl(imageSize) / (float)sampleSize;
        float xTiles = sampledWidth / (float)IntSizeCompat.getWidth-impl(preferredTileSize);
        int xTilesInt = RangesKt.coerceAtLeast((int)((int)Math.ceil(xTiles)), (int)1);
        float sampledHeight = (float)IntSizeCompat.getHeight-impl(imageSize) / (float)sampleSize;
        float yTiles = sampledHeight / (float)IntSizeCompat.getHeight-impl(preferredTileSize);
        int yTilesInt = RangesKt.coerceAtLeast((int)((int)Math.ceil(yTiles)), (int)1);
        long initialGridSize = IntOffsetCompatKt.IntOffsetCompat(xTilesInt, yTilesInt);
        long gridSize = maxGridSize != null ? IntOffsetCompatKt.IntOffsetCompat(RangesKt.coerceAtMost((int)IntOffsetCompat.getX-impl(initialGridSize), (int)IntOffsetCompat.getX-impl(maxGridSize.unbox-impl())), RangesKt.coerceAtMost((int)IntOffsetCompat.getY-impl(initialGridSize), (int)IntOffsetCompat.getY-impl(maxGridSize.unbox-impl()))) : initialGridSize;
        return gridSize;
    }

    public static /* synthetic */ long calculateGridSize-xojIVns$default(long l, long l2, int n, IntOffsetCompat intOffsetCompat, int n2, Object object) {
        if ((n2 & 8) != 0) {
            intOffsetCompat = null;
        }
        return Tile_managesKt.calculateGridSize-xojIVns(l, l2, n, intOffsetCompat);
    }

    public static final long calculateMaxGridSize-wW3DvEY(long imageSize, int singleDirectionMaxTiles) {
        long l;
        if (!(singleDirectionMaxTiles > 0)) {
            boolean $i$a$-require-Tile_managesKt$calculateMaxGridSize$22 = false;
            String $i$a$-require-Tile_managesKt$calculateMaxGridSize$22 = "singleDirectionMaxTiles must be greater than 0";
            throw new IllegalArgumentException($i$a$-require-Tile_managesKt$calculateMaxGridSize$22.toString());
        }
        if (IntSizeCompat.getWidth-impl(imageSize) > IntSizeCompat.getHeight-impl(imageSize)) {
            float proportion = (float)IntSizeCompat.getHeight-impl(imageSize) / (float)IntSizeCompat.getWidth-impl(imageSize);
            float heightMaxTiles = proportion * (float)singleDirectionMaxTiles;
            int heightMaxTilesInt = MathKt.roundToInt((float)heightMaxTiles);
            l = IntOffsetCompatKt.IntOffsetCompat(singleDirectionMaxTiles, RangesKt.coerceAtLeast((int)heightMaxTilesInt, (int)1));
        } else {
            float proportion = (float)IntSizeCompat.getWidth-impl(imageSize) / (float)IntSizeCompat.getHeight-impl(imageSize);
            float heightMaxTiles = proportion * (float)singleDirectionMaxTiles;
            int heightMaxTilesInt = MathKt.roundToInt((float)heightMaxTiles);
            l = IntOffsetCompatKt.IntOffsetCompat(RangesKt.coerceAtLeast((int)heightMaxTilesInt, (int)1), singleDirectionMaxTiles);
        }
        return l;
    }

    @NotNull
    public static final List<Tile> calculateTiles-4uQ0JDQ(long imageSize, long gridSize, int sampleSize) {
        int tileWidth = RangesKt.coerceIn((int)((int)Math.ceil((float)IntSizeCompat.getWidth-impl(imageSize) / (float)IntOffsetCompat.getX-impl(gridSize))), (int)1, (int)IntSizeCompat.getWidth-impl(imageSize));
        int tileHeight = RangesKt.coerceIn((int)((int)Math.ceil((float)IntSizeCompat.getHeight-impl(imageSize) / (float)IntOffsetCompat.getY-impl(gridSize))), (int)1, (int)IntSizeCompat.getHeight-impl(imageSize));
        ArrayList<Tile> tileList = new ArrayList<Tile>(IntOffsetCompat.getX-impl(gridSize) * IntOffsetCompat.getY-impl(gridSize));
        int n = IntOffsetCompat.getY-impl(gridSize);
        for (int y = 0; y < n; ++y) {
            int n2 = IntOffsetCompat.getX-impl(gridSize);
            for (int x = 0; x < n2; ++x) {
                long coordinate = IntOffsetCompatKt.IntOffsetCompat(x, y);
                IntRectCompat srcRect = new IntRectCompat(x * tileWidth, y * tileHeight, RangesKt.coerceAtMost((int)((x + 1) * tileWidth), (int)IntSizeCompat.getWidth-impl(imageSize)), RangesKt.coerceAtMost((int)((y + 1) * tileHeight), (int)IntSizeCompat.getHeight-impl(imageSize)));
                tileList.add(new Tile(coordinate, srcRect, sampleSize, null));
            }
        }
        return tileList;
    }

    @NotNull
    public static final List<SamplingTiles> calculateTileGridMap-MEmoHmQ(long imageSize, long preferredTileSize) {
        long gridSize;
        List tileMap = new ArrayList();
        long maxGridSize = Tile_managesKt.calculateMaxGridSize-wW3DvEY(imageSize, 50);
        int sampleSize = 1;
        do {
            gridSize = Tile_managesKt.calculateGridSize-xojIVns(imageSize, preferredTileSize, sampleSize, IntOffsetCompat.box-impl(maxGridSize));
            List<Tile> tiles = Tile_managesKt.calculateTiles-4uQ0JDQ(imageSize, gridSize, sampleSize);
            tileMap.add(new SamplingTiles(sampleSize, tiles));
            sampleSize *= 2;
        } while (IntOffsetCompat.getX-impl(gridSize) * IntOffsetCompat.getY-impl(gridSize) > 1);
        return CollectionsKt.sortedWith((Iterable)tileMap, (arg_0, arg_1) -> Tile_managesKt.calculateTileGridMap_MEmoHmQ$lambda$2(Tile_managesKt::calculateTileGridMap_MEmoHmQ$lambda$1, arg_0, arg_1));
    }

    @NotNull
    public static final IntRectCompat calculateImageLoadRect-uV7mNCg(long imageSize, long contentSize, long preferredTileSize, @NotNull IntRectCompat contentVisibleRect) {
        Intrinsics.checkNotNullParameter((Object)contentVisibleRect, (String)"contentVisibleRect");
        if (IntSizeCompatKt.isEmpty-grz_zgQ(imageSize) || IntSizeCompatKt.isEmpty-grz_zgQ(contentSize) || contentVisibleRect.isEmpty()) {
            return IntRectCompat.Companion.getZero();
        }
        float widthScale = (float)IntSizeCompat.getWidth-impl(imageSize) / (float)IntSizeCompat.getWidth-impl(contentSize);
        float heightScale = (float)IntSizeCompat.getHeight-impl(imageSize) / (float)IntSizeCompat.getHeight-impl(contentSize);
        IntRectCompat imageVisibleRect = new IntRectCompat((int)Math.floor((float)contentVisibleRect.getLeft() * widthScale), (int)Math.floor((float)contentVisibleRect.getTop() * heightScale), (int)Math.ceil((float)contentVisibleRect.getRight() * widthScale), (int)Math.ceil((float)contentVisibleRect.getBottom() * heightScale));
        float horExtend = (float)IntSizeCompat.getWidth-impl(preferredTileSize) / 2.0f;
        float verExtend = (float)IntSizeCompat.getHeight-impl(preferredTileSize) / 2.0f;
        IntRectCompat imageLoadRect = new IntRectCompat((int)Math.floor((float)imageVisibleRect.getLeft() - horExtend), (int)Math.floor((float)imageVisibleRect.getTop() - verExtend), (int)Math.ceil((float)imageVisibleRect.getRight() + horExtend), (int)Math.ceil((float)imageVisibleRect.getBottom() + verExtend));
        IntRectCompat limitedImageLoadRect = IntRectCompatKt.limitTo-Rn4tGQs(imageLoadRect, imageSize);
        return limitedImageLoadRect;
    }

    private static final int calculateTileGridMap_MEmoHmQ$lambda$1(SamplingTiles o1, SamplingTiles o2) {
        return (o1.getSampleSize() - o2.getSampleSize()) * -1;
    }

    private static final int calculateTileGridMap_MEmoHmQ$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }
}

