/*
 * Decompiled with CFR 0.152.
 */
package com.github.panpf.zoomimage.subsampling.internal;

import com.github.panpf.zoomimage.subsampling.ImageInfo;
import com.github.panpf.zoomimage.subsampling.TileImage;
import com.github.panpf.zoomimage.subsampling.TileImageCache;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013J(\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/github/panpf/zoomimage/subsampling/internal/TileImageCacheHelper;", "", "<init>", "()V", "disabled", "", "getDisabled", "()Z", "setDisabled", "(Z)V", "tileImageCache", "Lcom/github/panpf/zoomimage/subsampling/TileImageCache;", "getTileImageCache", "()Lcom/github/panpf/zoomimage/subsampling/TileImageCache;", "setTileImageCache", "(Lcom/github/panpf/zoomimage/subsampling/TileImageCache;)V", "get", "Lcom/github/panpf/zoomimage/subsampling/TileImage;", "key", "", "put", "tileImage", "imageUrl", "imageInfo", "Lcom/github/panpf/zoomimage/subsampling/ImageInfo;", "zoomimage-core"})
public final class TileImageCacheHelper {
    private boolean disabled;
    @Nullable
    private TileImageCache tileImageCache;

    public final boolean getDisabled() {
        return this.disabled;
    }

    public final void setDisabled(boolean bl) {
        this.disabled = bl;
    }

    @Nullable
    public final TileImageCache getTileImageCache() {
        return this.tileImageCache;
    }

    public final void setTileImageCache(@Nullable TileImageCache tileImageCache) {
        this.tileImageCache = tileImageCache;
    }

    @Nullable
    public final TileImage get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        boolean disabled = this.disabled;
        TileImageCache tileMemoryCache = this.tileImageCache;
        if (disabled || tileMemoryCache == null) {
            return null;
        }
        return tileMemoryCache.get(key);
    }

    @Nullable
    public final TileImage put(@NotNull String key, @NotNull TileImage tileImage, @NotNull String imageUrl, @NotNull ImageInfo imageInfo) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)tileImage, (String)"tileImage");
        Intrinsics.checkNotNullParameter((Object)imageUrl, (String)"imageUrl");
        Intrinsics.checkNotNullParameter((Object)imageInfo, (String)"imageInfo");
        boolean disabled = this.disabled;
        TileImageCache tileMemoryCache = this.tileImageCache;
        return !disabled && tileMemoryCache != null ? tileMemoryCache.put(key, tileImage, imageUrl, imageInfo) : null;
    }
}

