/*
 * Decompiled with CFR 0.152.
 */
package com.github.panpf.zoomimage.subsampling.internal;

import com.github.panpf.zoomimage.subsampling.ImageInfo;
import com.github.panpf.zoomimage.subsampling.RegionDecoder;
import com.github.panpf.zoomimage.util.Core_utils_commonKt;
import com.github.panpf.zoomimage.util.IntRectCompat;
import com.github.panpf.zoomimage.util.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Bitmap;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ#\u0010\u001b\u001a\n\u0018\u00010\u001cj\u0004\u0018\u0001`\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0013\u00a2\u0006\u0002\u0010!J@\u0010\"\u001a\n\u0018\u00010\u001cj\u0004\u0018\u0001`\u001d2)\u0010#\u001a%\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\f\u0012\n\u0018\u00010\u001cj\u0004\u0018\u0001`\u001d0$H\u0002\u00a2\u0006\u0002\u0010(J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020,H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006-"}, d2={"Lcom/github/panpf/zoomimage/subsampling/internal/TileDecoder;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "logger", "Lcom/github/panpf/zoomimage/util/Logger;", "regionDecoder", "Lcom/github/panpf/zoomimage/subsampling/RegionDecoder;", "<init>", "(Lcom/github/panpf/zoomimage/util/Logger;Lcom/github/panpf/zoomimage/subsampling/RegionDecoder;)V", "getLogger", "()Lcom/github/panpf/zoomimage/util/Logger;", "closed", "", "decoderPool", "", "poolSyncLock", "", "Lkotlinx/atomicfu/locks/SynchronizedObject;", "regionDecoderCount", "", "decoderPoolSize", "getDecoderPoolSize", "()I", "imageInfo", "Lcom/github/panpf/zoomimage/subsampling/ImageInfo;", "getImageInfo", "()Lcom/github/panpf/zoomimage/subsampling/ImageInfo;", "decode", "Lorg/jetbrains/skia/Bitmap;", "Lcom/github/panpf/zoomimage/subsampling/TileBitmap;", "srcRect", "Lcom/github/panpf/zoomimage/util/IntRectCompat;", "sampleSize", "(Lcom/github/panpf/zoomimage/util/IntRectCompat;I)Lorg/jetbrains/skia/Bitmap;", "useDecoder", "block", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "decoder", "(Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/skia/Bitmap;", "close", "", "toString", "", "zoomimage-core"})
@SourceDebugExtension(value={"SMAP\nTileDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileDecoder.kt\ncom/github/panpf/zoomimage/subsampling/internal/TileDecoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1#2:105\n1869#3,2:106\n*S KotlinDebug\n*F\n+ 1 TileDecoder.kt\ncom/github/panpf/zoomimage/subsampling/internal/TileDecoder\n*L\n95#1:106,2\n*E\n"})
public final class TileDecoder
implements AutoCloseable {
    @NotNull
    private final Logger logger;
    @NotNull
    private final RegionDecoder regionDecoder;
    private boolean closed;
    @NotNull
    private final List<RegionDecoder> decoderPool;
    @NotNull
    private final Object poolSyncLock;
    private int regionDecoderCount;
    @NotNull
    private final ImageInfo imageInfo;

    public TileDecoder(@NotNull Logger logger, @NotNull RegionDecoder regionDecoder2) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)regionDecoder2, (String)"regionDecoder");
        this.logger = logger;
        this.regionDecoder = regionDecoder2;
        this.decoderPool = new ArrayList();
        this.poolSyncLock = new Object();
        this.imageInfo = this.regionDecoder.getImageInfo();
        this.decoderPool.add(this.regionDecoder);
        int n = this.regionDecoderCount;
        this.regionDecoderCount = n + 1;
        this.logger.d((Function0<String>)((Function0)() -> TileDecoder._init_$lambda$0(this)));
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public final int getDecoderPoolSize() {
        return this.decoderPool.size();
    }

    @NotNull
    public final ImageInfo getImageInfo() {
        return this.imageInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Bitmap decode(@NotNull IntRectCompat srcRect, int sampleSize) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)srcRect, (String)"srcRect");
        Object object = this.poolSyncLock;
        synchronized (object) {
            boolean bl2 = false;
            bl = this.closed;
        }
        boolean closed = bl;
        if (!(!closed)) {
            boolean bl3 = false;
            String string = "TileDecoder is closed. " + this.regionDecoder;
            throw new IllegalStateException(string.toString());
        }
        return this.useDecoder((Function1<? super RegionDecoder, Bitmap>)((Function1)arg_0 -> TileDecoder.decode$lambda$3(srcRect, sampleSize, arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Bitmap useDecoder(Function1<? super RegionDecoder, Bitmap> block) {
        Object object;
        RegionDecoder regionDecoder2 = null;
        Object object2 = this.poolSyncLock;
        synchronized (object2) {
            boolean bl = false;
            object = !((Collection)this.decoderPool).isEmpty() ? this.decoderPool.remove(0) : null;
        }
        regionDecoder2 = object;
        if (regionDecoder2 == null) {
            int n = this.regionDecoderCount;
            this.regionDecoderCount = n + 1;
            this.logger.d((Function0<String>)((Function0)() -> TileDecoder.useDecoder$lambda$5(this)));
            regionDecoder2 = this.regionDecoder.copy();
        }
        Bitmap tileImage = (Bitmap)block.invoke((Object)regionDecoder2);
        object = this.poolSyncLock;
        synchronized (object) {
            Object object3;
            boolean bl = false;
            if (!this.closed) {
                object3 = this.decoderPool.add(regionDecoder2);
            } else {
                Core_utils_commonKt.closeQuietly(regionDecoder2);
                object3 = Unit.INSTANCE;
            }
            Object object4 = object3;
        }
        return tileImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        boolean bl;
        Object object = this.poolSyncLock;
        synchronized (object) {
            bl = false;
            bl = this.closed;
        }
        boolean closed = bl;
        if (!closed) {
            this.closed = true;
            this.logger.d((Function0<String>)((Function0)() -> TileDecoder.close$lambda$8(this)));
            object = this.poolSyncLock;
            synchronized (object) {
                boolean bl2 = false;
                Iterable $this$forEach$iv = this.decoderPool;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RegionDecoder it = (RegionDecoder)element$iv;
                    boolean bl3 = false;
                    Core_utils_commonKt.closeQuietly(it);
                }
                this.decoderPool.clear();
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @NotNull
    public String toString() {
        return "TileDecoder(" + this.regionDecoder + ')';
    }

    private static final String _init_$lambda$0(TileDecoder this$0) {
        return "TileDecoder. useDecoder. regionDecoderCount=" + this$0.regionDecoderCount + ". " + this$0.regionDecoder;
    }

    private static final Bitmap decode$lambda$3(IntRectCompat $srcRect, int $sampleSize, RegionDecoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        return decoder.decodeRegion($srcRect, $sampleSize);
    }

    private static final String useDecoder$lambda$5(TileDecoder this$0) {
        return "TileDecoder. useDecoder. regionDecoderCount=" + this$0.regionDecoderCount + ". " + this$0.regionDecoder;
    }

    private static final String close$lambda$8(TileDecoder this$0) {
        return "TileDecoder. close. " + this$0.regionDecoder;
    }
}

