/*
 * Decompiled with CFR 0.152.
 */
package com.github.panpf.zoomimage.subsampling;

import com.github.panpf.zoomimage.subsampling.TileImage;
import com.github.panpf.zoomimage.subsampling.TileImageFrom;
import com.github.panpf.zoomimage.subsampling.TileState;
import com.github.panpf.zoomimage.util.IntOffsetCompat;
import com.github.panpf.zoomimage.util.IntOffsetCompatKt;
import com.github.panpf.zoomimage.util.IntRectCompat;
import com.github.panpf.zoomimage.util.IntRectCompatKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00013B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010)\u001a\u00020*2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010+\u001a\u00020,J\u0006\u0010-\u001a\u00020*J\u0013\u0010.\u001a\u00020,2\b\u0010/\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u00100\u001a\u00020\u0007H\u0016J\b\u00101\u001a\u000202H\u0016R\u0013\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\"\u0010\u0019\u001a\u0004\u0018\u00010\u00182\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR$\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010\u0010R \u0010 \u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b!\u0010\u001e\u001a\u0004\b\"\u0010\u0010\"\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u00064"}, d2={"Lcom/github/panpf/zoomimage/subsampling/Tile;", "", "coordinate", "Lcom/github/panpf/zoomimage/util/IntOffsetCompat;", "srcRect", "Lcom/github/panpf/zoomimage/util/IntRectCompat;", "sampleSize", "", "<init>", "(JLcom/github/panpf/zoomimage/util/IntRectCompat;ILkotlin/jvm/internal/DefaultConstructorMarker;)V", "getCoordinate-QQ-czBQ", "()J", "J", "getSrcRect", "()Lcom/github/panpf/zoomimage/util/IntRectCompat;", "getSampleSize", "()I", "loadJob", "Lkotlinx/coroutines/Job;", "getLoadJob$zoomimage_core", "()Lkotlinx/coroutines/Job;", "setLoadJob$zoomimage_core", "(Lkotlinx/coroutines/Job;)V", "value", "Lcom/github/panpf/zoomimage/subsampling/TileImage;", "tileImage", "getTileImage", "()Lcom/github/panpf/zoomimage/subsampling/TileImage;", "from", "getFrom$annotations", "()V", "getFrom", "state", "getState$annotations", "getState", "setState", "(I)V", "animationState", "Lcom/github/panpf/zoomimage/subsampling/Tile$AnimationState;", "getAnimationState", "()Lcom/github/panpf/zoomimage/subsampling/Tile$AnimationState;", "setTileImage", "", "allowAnimate", "", "cleanTileImage", "equals", "other", "hashCode", "toString", "", "AnimationState", "zoomimage-core"})
public final class Tile {
    private final long coordinate;
    @NotNull
    private final IntRectCompat srcRect;
    private final int sampleSize;
    @Nullable
    private Job loadJob;
    @Nullable
    private TileImage tileImage;
    private int from;
    private int state;
    @NotNull
    private final AnimationState animationState;

    private Tile(long coordinate, IntRectCompat srcRect, int sampleSize) {
        Intrinsics.checkNotNullParameter((Object)srcRect, (String)"srcRect");
        this.coordinate = coordinate;
        this.srcRect = srcRect;
        this.sampleSize = sampleSize;
        this.animationState = new AnimationState();
    }

    public final long getCoordinate-QQ-czBQ() {
        return this.coordinate;
    }

    @NotNull
    public final IntRectCompat getSrcRect() {
        return this.srcRect;
    }

    public final int getSampleSize() {
        return this.sampleSize;
    }

    @Nullable
    public final Job getLoadJob$zoomimage_core() {
        return this.loadJob;
    }

    public final void setLoadJob$zoomimage_core(@Nullable Job job) {
        this.loadJob = job;
    }

    @Nullable
    public final TileImage getTileImage() {
        return this.tileImage;
    }

    public final int getFrom() {
        return this.from;
    }

    public static /* synthetic */ void getFrom$annotations() {
    }

    public final int getState() {
        return this.state;
    }

    public final void setState(int n) {
        this.state = n;
    }

    public static /* synthetic */ void getState$annotations() {
    }

    @NotNull
    public final AnimationState getAnimationState() {
        return this.animationState;
    }

    public final void setTileImage(@Nullable TileImage tileImage, int from, boolean allowAnimate) {
        TileImage oldTileImage = this.tileImage;
        if (Intrinsics.areEqual((Object)tileImage, (Object)oldTileImage)) {
            return;
        }
        TileImage tileImage2 = oldTileImage;
        if (tileImage2 != null) {
            tileImage2.setIsDisplayed(false);
        }
        this.tileImage = tileImage;
        this.from = from;
        TileImage tileImage3 = tileImage;
        if (tileImage3 != null) {
            tileImage3.setIsDisplayed(true);
        }
        if (tileImage != null && allowAnimate) {
            this.animationState.restart();
        } else {
            this.animationState.stop();
        }
    }

    public final void cleanTileImage() {
        this.setTileImage(null, 0, false);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Tile cfr_ignored_0 = (Tile)other;
        if (!IntOffsetCompat.equals-impl0(this.coordinate, ((Tile)other).coordinate)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.srcRect, (Object)((Tile)other).srcRect)) {
            return false;
        }
        return this.sampleSize == ((Tile)other).sampleSize;
    }

    public int hashCode() {
        int result = IntOffsetCompat.hashCode-impl(this.coordinate);
        result = 31 * result + this.srcRect.hashCode();
        result = 31 * result + this.sampleSize;
        return result;
    }

    @NotNull
    public String toString() {
        return "Tile(coordinate=" + IntOffsetCompatKt.toShortString-1tlllzA(this.coordinate) + ",srcRect=" + IntRectCompatKt.toShortString(this.srcRect) + ",srcSize=" + this.srcRect.getWidth() + 'x' + this.srcRect.getHeight() + ",state=" + TileState.Companion.name(this.state) + ",from=" + TileImageFrom.Companion.name(this.from) + ",sampleSize=" + this.sampleSize + ",bitmap=" + this.tileImage + ')';
    }

    public /* synthetic */ Tile(long coordinate, IntRectCompat srcRect, int sampleSize, DefaultConstructorMarker $constructor_marker) {
        this(coordinate, srcRect, sampleSize);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0018R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\n\u0010\u000bR\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lcom/github/panpf/zoomimage/subsampling/Tile$AnimationState;", "", "<init>", "()V", "startTime", "Lkotlin/time/TimeSource$Monotonic$ValueTimeMark;", "J", "value", "", "progress", "setProgress", "(F)V", "", "alpha", "getAlpha", "()I", "running", "", "getRunning", "()Z", "calculate", "duration", "", "restart", "", "stop", "zoomimage-core"})
    public static final class AnimationState {
        private long startTime = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        private float progress = 1.0f;
        private int alpha = 255;

        private final void setProgress(float value) {
            if (!(value == this.progress)) {
                this.progress = value;
                this.alpha = (int)(value * (float)255);
            }
        }

        public final int getAlpha() {
            return this.alpha;
        }

        public final boolean getRunning() {
            return this.progress < 1.0f;
        }

        public final boolean calculate(long duration) {
            long elapsedTime;
            this.setProgress(duration > 0L ? ((elapsedTime = Duration.getInWholeMilliseconds-impl((long)TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)this.startTime))) >= duration ? 1.0f : (float)elapsedTime / (float)duration) : 1.0f);
            return this.getRunning();
        }

        public final void restart() {
            this.startTime = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
            this.setProgress(0.0f);
            this.alpha = 0;
        }

        public final void stop() {
            if (this.getRunning()) {
                this.startTime = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
                this.setProgress(1.0f);
                this.alpha = 255;
            }
        }
    }
}

