/*
 * Decompiled with CFR 0.152.
 */
package com.github.panpf.zoomimage.subsampling;

import com.github.panpf.zoomimage.subsampling.ImageSource;
import com.github.panpf.zoomimage.subsampling.internal.ClassLoaderResourceLoader;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/github/panpf/zoomimage/subsampling/KotlinResourceImageSource;", "Lcom/github/panpf/zoomimage/subsampling/ImageSource;", "resourcePath", "", "<init>", "(Ljava/lang/String;)V", "getResourcePath", "()Ljava/lang/String;", "key", "getKey", "openSource", "Lokio/Source;", "equals", "", "other", "", "hashCode", "", "toString", "zoomimage-core"})
public final class KotlinResourceImageSource
implements ImageSource {
    @NotNull
    private final String resourcePath;
    @NotNull
    private final String key;

    public KotlinResourceImageSource(@NotNull String resourcePath) {
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        this.resourcePath = resourcePath;
        this.key = "file:///kotlin_resource/" + this.resourcePath;
    }

    @NotNull
    public final String getResourcePath() {
        return this.resourcePath;
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public Source openSource() {
        return Okio.source((InputStream)ClassLoaderResourceLoader.Companion.getDefault().load(this.resourcePath));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        KotlinResourceImageSource cfr_ignored_0 = (KotlinResourceImageSource)other;
        return Intrinsics.areEqual((Object)this.resourcePath, (Object)((KotlinResourceImageSource)other).resourcePath);
    }

    public int hashCode() {
        return this.resourcePath.hashCode();
    }

    @NotNull
    public String toString() {
        return "KotlinResourceImageSource('" + this.resourcePath + "')";
    }
}

