/*
 * Decompiled with CFR 0.152.
 */
package com.github.panpf.zoomimage.subsampling;

import com.github.panpf.zoomimage.subsampling.ImageSource;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/github/panpf/zoomimage/subsampling/ByteArrayImageSource;", "Lcom/github/panpf/zoomimage/subsampling/ImageSource;", "byteArray", "", "<init>", "([B)V", "getByteArray", "()[B", "key", "", "getKey", "()Ljava/lang/String;", "openSource", "Lokio/Source;", "equals", "", "other", "", "hashCode", "", "toString", "zoomimage-core"})
public final class ByteArrayImageSource
implements ImageSource {
    @NotNull
    private final byte[] byteArray;
    @NotNull
    private final String key;

    public ByteArrayImageSource(@NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        this.byteArray = byteArray;
        this.key = this.byteArray.toString();
    }

    @NotNull
    public final byte[] getByteArray() {
        return this.byteArray;
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public Source openSource() {
        return (Source)new Buffer().write(this.byteArray);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ByteArrayImageSource cfr_ignored_0 = (ByteArrayImageSource)other;
        return Arrays.equals(this.byteArray, ((ByteArrayImageSource)other).byteArray);
    }

    public int hashCode() {
        return this.byteArray.hashCode();
    }

    @NotNull
    public String toString() {
        return "ByteArrayImageSource('" + this.byteArray + "')";
    }
}

